//=============================================================================
// HXWHPiano.
//=============================================================================
class HXWHPiano extends HXWashingtonDecoration;

var Sound PianoSounds[2];
var float NextUseTime;

// ----------------------------------------------------------------------------
// Frob().
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	local Sound SelectedSound;

	Super.Frob( Frobber, FrobWith );

	if ( NextUseTime<Level.TimeSeconds && !IsInState('Conversation') && !IsInState('FirstPersonConversation') )
	{
		SelectedSound = PianoSounds[Rand(2)];
		NextUseTime = Level.TimeSeconds + GetSoundDuration(SelectedSound) + 0.5;
		PlaySound( SelectedSound, SLOT_Misc,,, 256 );
	}
}

// ----------------------------------------------------------------------------
// StopPianoSound().
//
// Sole purpose of this function is to call StopSoundSlot() inside a non
// simulated function.
// ----------------------------------------------------------------------------

function StopPianoSound()
{
	StopSoundSlot( SLOT_Misc );
}

// ----------------------------------------------------------------------------
// Destroyed().
// ----------------------------------------------------------------------------

simulated function Destroyed()
{
	Super.Destroyed();

	if ( Role==ROLE_Authority )
		StopPianoSound();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PianoSounds(0)=Piano1
	PianoSounds(1)=Piano2
	NextUseTime=-1.0
	FragType=WoodFragment
	bCanBeBase=True
	ItemName="Grand Piano"
	bPushable=False
	Mesh=WHPiano
	CollisionRadius=100.00
	//CollisionHeight=32.50
	CollisionHeight=31.75
	Mass=750.0
	Buoyancy=100.0
	bFlammable=True
}
