//=============================================================================
// HXWIB.
//
// Notes:
//  * Use lower tier pain sounds?
//=============================================================================
class HXWIB extends HXHumanMilitary;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

// Copying CollisionSize is suspended for now, making this quirk obsolete.
/*
function Succeeds( Actor Other )
{
	local WIB OtherWIB;

	// Call Super.
	Super.Succeeds( Other );

	// Special WIB Init.
	OtherWIB = WIB(Other);
	if ( OtherWIB!=None )
	{
		// Original CollisionHeight didn't match the other GFM_SuitSkirt characters.
		if ( OtherWIB.CollisionHeight==(OtherWIB.default.CollisionHeight-4.5) && OtherWIB.CollisionRadius==OtherWIB.default.CollisionRadius ) 
		{
			SetCollisionSize( default.CollisionRadius, default.CollisionHeight );
		}
	}
}
*/

// ----------------------------------------------------------------------
// SpawnCarcass()
//
// Blow up instead of spawning a carcass
// ----------------------------------------------------------------------

function Carcass SpawnCarcass()
{
	if (bStunned)
		return Super.SpawnCarcass();

	Explode();

	return None;
}

function Explode()
{
	local HXSphereEffect sphere;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local float explosionDamage;
	local float explosionRadius;

	explosionDamage = 100;
	explosionRadius = 256;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'LargeExplosion1', SLOT_None,,, explosionRadius*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionLarge',,, Location + 2*VRand()*CollisionRadius);

	sphere = Spawn(class'HXSphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks and flesh fragments
	for (i=0; i<explosionDamage/6; i++)
	{
		if (FRand() < 0.3)
			spawn(class'Rockchip',,,Location);
		else
			spawn(class'FleshFragment',,,Location);
	}


	HurtRadius(explosionDamage, explosionRadius, 'Exploded', explosionDamage*100, Location);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MinHealth=0.0
	CarcassType=WIBCarcass
	WalkingSpeed=0.296
	CloseCombatMult=0.5
	BaseAssHeight=-18.0
	WalkAnimMult=0.87
	bIsFemale=True
	GroundSpeed=200.0
	Health=300
	HealthHead=300
	HealthTorso=300
	HealthLegLeft=300
	HealthLegRight=300
	HealthArmLeft=300
	HealthArmRight=300
	Mesh=GFM_SuitSkirt
	DrawScale=1.1
	MultiSkins(0)=WIBTex0
	MultiSkins(1)=PinkMaskTex
	MultiSkins(2)=WIBTex0
	MultiSkins(3)=LegsTex2
	MultiSkins(4)=WIBTex1
	MultiSkins(5)=WIBTex1
	MultiSkins(6)=FramesTex2
	MultiSkins(7)=LensesTex3
	CollisionRadius=22.0
	// Original incorrect CollisionHeight.
	////CollisionHeight=47.3
	//CollisionHeight=42.8
	// Adjusted to match other GFM_SuitSkirt uses.
	//CollisionHeight=46.85
	CollisionHeight=42.35
	BindName="WIB"
	FamiliarName="Woman In Black"
	UnfamiliarName="Woman In Black"
	NameArticle="a "
	HitSound1=FemalePainMedium
	HitSound2=FemalePainLarge
	Die=FemaleDeath
}
