//=============================================================================
// HXWaltonSimons.
//
// Damage type table for Walton Simons:
//
// Shot			- 100%
// Sabot		- 100%
// Exploded		- 100%
// TearGas		- 10%
// PoisonGas	- 10%
// Poison		- 10%
// PoisonEffect	- 10%
// HalonGas		- 10%
// Radiation	- 10%
// Shocked		- 10%
// Stunned		- 0%
// KnockedOut   - 0%
// Flamed		- 0%
// Burned		- 0%
// NanoVirus	- 0%
// EMP			- 0%
//
//=============================================================================
class HXWaltonSimons extends HXHumanMilitary;

var localized String ObsoletedBy;

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'Flamed') || (damageType == 'Burned') || (damageType == 'Stunned') ||
	    (damageType == 'KnockedOut'))
		return 0.0;
	else if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas') ||
			(damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'Poison') ||
	        (damageType == 'PoisonEffect'))
		return 0.1;
	else
		return Super.ShieldDamage(damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

// ----------------------------------------------------------------------------
// KillMessage()
// ----------------------------------------------------------------------------

function string KillMessage( Name DamageType, Pawn Other )
{
	return ObsoletedBy;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ObsoletedBy=" was obsoleted by the more advanced model."
	CarcassType=WaltonSimonsCarcass
	WalkingSpeed=0.333333
	bImportant=True
	bInvincible=True
	CloseCombatMult=0.5
	BaseAssHeight=-23.0
	BurnPeriod=0.0
	bHasCloak=True
	CloakThreshold=150
	walkAnimMult=1.4
	GroundSpeed=240.0
	Health=600
	HealthHead=900
	HealthTorso=600
	HealthLegLeft=600
	HealthLegRight=600
	HealthArmLeft=600
	HealthArmRight=600
	Mesh=GM_Trench
	MultiSkins(0)=WaltonSimonsTex0
	MultiSkins(1)=WaltonSimonsTex2
	MultiSkins(2)=PantsTex5
	MultiSkins(3)=WaltonSimonsTex0
	MultiSkins(4)=WaltonSimonsTex1
	MultiSkins(5)=WaltonSimonsTex2
	MultiSkins(6)=GrayMaskTex
	MultiSkins(7)=BlackMaskTex
	CollisionRadius=20.0
	//CollisionHeight=47.5
	CollisionHeight=43.0
	BindName="WaltonSimons"
	FamiliarName="Walton Simons"
	UnfamiliarName="Walton Simons"
}
