//=============================================================================
// HXWaterFountain.
//=============================================================================
class HXWaterFountain extends HXDecoration;

var localized String MsgEmpty;
var() Sound BubbleSound;
var() int HealAmount;
var() int NumUses;
var() float ReuseDelay;
var float BubbleTime; // Used for BubbleTimer()

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	Super.Frob( Frobber, FrobWith );

	if ( NumUses<=0 )
	{
		if ( Pawn(Frobber)!=None )
			Pawn(Frobber).ClientMessage( MsgEmpty );
		return;
	}

	if ( BubbleTime>0.0 )
		return;

	// Heal the frobber a small bit.
	if ( HXPlayerPawn(Frobber)!= None )
		HXPlayerPawn(Frobber).HealPlayer( HealAmount );

	// Alert AI.
	Instigator = Pawn(Frobber);
	AISendEvent( 'LoudNoise', EAITYPE_Audio,, 256 );

	StartUseAnim();
	AmbientSound = BubbleSound;
	NumUses--;
	BubbleTime = ReuseDelay;
}

// ----------------------------------------------------------------------------
// StartUseAnim()
// ----------------------------------------------------------------------------

function StartUseAnim()
{
	LoopAnim( 'Use' );
}

// ----------------------------------------------------------------------------
// StopUseAnim()
// ----------------------------------------------------------------------------

function StopUseAnim()
{
	PlayAnim( 'Still' );
}

// ----------------------------------------------------------------------------
// BubbleTimer()
// ----------------------------------------------------------------------------

function BubbleTimer()
{
	AmbientSound = None;
	Instigator   = None;
	StopUseAnim();
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	Super.Tick( DeltaTime );

	if ( Role==ROLE_Authority )
	{
		// Additional BubbleTimer().
		if ( BubbleTime>0.0 )
		{
			BubbleTime -= DeltaTime;

			if ( BubbleTime<0.001 )
			{
				BubbleTime = 0.0;
				BubbleTimer();
			}
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	BubbleSound=WaterBubbling
	HealAmount=1
	NumUses=10
	ReuseDelay=2.0
	MsgEmpty="It's out of water"
	ItemName="Water Fountain"
	bPushable=False
	Physics=PHYS_None
	Mesh=WaterFountain
	CollisionRadius=20.00
	//CollisionHeight=24.36
	CollisionHeight=23.61
	Mass=70.0
	Buoyancy=100.0
}
