//=============================================================================
// HXWaterRing.
//=============================================================================
class HXWaterRing extends HXEffects;

var bool bNoExtraRings;
var bool bScaleOnce;

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	local Rotator RndRot;

	Super.PostBeginPlay();

	RndRot.Pitch = 16384;
	RndRot.Roll  = 0;
	RndRot.Yaw   = 65535*FRand();
	SetRotation( RndRot );
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	// Cut the scale in half the first time we draw. 
	// Ugh! --han
	if ( !bScaleOnce )
	{
		DrawScale *= 0.5;
		bScaleOnce = True;
	}

	DrawScale += 2.0 * DeltaTime;
	ScaleGlow  = LifeSpan / Default.LifeSpan;
}

// ----------------------------------------------------------------------------
// EffectsTimer()
//
// Spawn two more rings during lifetime.
// ----------------------------------------------------------------------------

simulated event EffectsTimer()
{
	local HXWaterRing Ring;

	if ( !bNoExtraRings )
	{
		EffectsTime = 0.2;
		Ring = Spawn( Class );
		if ( Ring!=None )
		{
			Ring.RemoteRole    = ROLE_None;
			Ring.bNoExtraRings = True;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	EffectsTime=0.2
	LifeSpan=0.5
	DrawType=DT_Mesh
	Style=STY_Translucent
	Skin=Texture'DeusExItems.Skins.FlatFXTex46'
	Mesh=LodMesh'DeusExItems.FlatFX'
	bUnlit=True
}
