//=============================================================================
// HXWeapon.
//=============================================================================
class HXWeapon extends DeusExWeapon
	abstract;

var transient HXGameInfo Game;
var Name PrecessorName;
var bool bSpawning;

/*
//
// enums for weapons (duh)
//
enum EEnemyEffective
{
	ENMEFF_All,
	ENMEFF_Organic,
	ENMEFF_Robot
};

enum EEnviroEffective
{
	ENVEFF_All,
	ENVEFF_Air,
	ENVEFF_Water,
	ENVEFF_Vacuum,
	ENVEFF_AirWater,
	ENVEFF_AirVacuum,
	ENVEFF_WaterVacuum
};

enum EConcealability
{
	CONC_None,
	CONC_Visual,
	CONC_Metal,
	CONC_All
};

enum EAreaType
{
	AOE_Point,
	AOE_Cone,
	AOE_Sphere
};

enum ELockMode
{
	LOCK_None,
	LOCK_Invalid,
	LOCK_Range,
	LOCK_Acquire,
	LOCK_Locked
};

var bool				bReadyToFire;			// true if our bullets are loaded, etc.
var() int				LowAmmoWaterMark;		// critical low ammo count
var travel int			ClipCount;				// number of bullets remaining in current clip

var() class<Skill>		GoverningSkill;			// skill that affects this weapon
var() travel float		NoiseLevel;				// amount of noise that weapon makes when fired
var() EEnemyEffective	EnemyEffective;			// type of enemies that weapon is effective against
var() EEnviroEffective	EnviroEffective;		// type of environment that weapon is effective in
var() EConcealability	Concealability;			// concealability of weapon
var() travel bool		bAutomatic;				// is this an automatic weapon?
var() travel float		ShotTime;				// number of seconds between shots
var() travel float		ReloadTime;				// number of seconds needed to reload the clip
var() int				HitDamage;				// damage done by a single shot (or for shotguns, a single slug)
var() int				MaxRange;				// absolute maximum range in world units (feet * 16)
var() travel int		AccurateRange;			// maximum accurate range in world units (feet * 16)
var() travel float		BaseAccuracy;			// base accuracy (0.0 is dead on, 1.0 is far off)

var bool				bCanHaveScope;			// can this weapon have a scope?
var() travel bool		bHasScope;				// does this weapon have a scope?
var() int				ScopeFOV;				// FOV while using scope
var bool				bZoomed;				// are we currently zoomed?
var bool				bWasZoomed;				// were we zoomed? (used during reloading)

var bool				bCanHaveLaser;			// can this weapon have a laser sight?
var() travel bool		bHasLaser;				// does this weapon have a laser sight?
var bool				bLasing;				// is the laser sight currently on?
var LaserEmitter		Emitter;				// actual laser emitter - valid only when bLasing == True

var bool				bCanHaveSilencer;		// can this weapon have a silencer?
var() travel bool		bHasSilencer;			// does this weapon have a silencer?

var() bool				bCanTrack;				// can this weapon lock on to a target?
var() float				LockTime;				// how long the target must stay targetted to lock
var float				LockTimer;				// used for lock checking
var float            MaintainLockTimer;   // Used for maintaining a lock even after moving off target.
var Actor            LockTarget;          // Used for maintaining a lock even after moving off target.
var Actor				Target;					// actor currently targetted
var ELockMode			LockMode;				// is this target locked?
var string				TargetMessage;			// message to print during targetting
var float				TargetRange;			// range to current target
var() Sound				LockedSound;			// sound to play when locked
var() Sound				TrackingSound;			// sound to play while tracking a target
var float				SoundTimer;				// to time the sounds correctly

var() class<Ammo>		AmmoNames[3];			// three possible types of ammo per weapon
var() class<Projectile> ProjectileNames[3];		// projectile classes for different ammo
var() EAreaType			AreaOfEffect;			// area of effect of the weapon
var() bool				bPenetrating;			// shot will penetrate and cause blood
var() float				StunDuration;			// how long the shot stuns the target
var() bool				bHasMuzzleFlash;		// does this weapon have a flash when fired?
var() bool				bHandToHand;			// is this weapon hand to hand (no ammo)?
var globalconfig vector SwingOffset;     // offsets for this weapon swing.
var() travel float		recoilStrength;			// amount that the weapon kicks back after firing (0.0 is none, 1.0 is large)
var bool				bFiring;				// True while firing, used for recoil
var bool				bOwnerWillNotify;		// True if firing hand-to-hand weapons is dependent on the owner's animations
var bool				bFallbackWeapon;		// If True, only use if no other weapons are available
var bool				bNativeAttack;			// True if weapon represents a native attack
var bool				bEmitWeaponDrawn;		// True if drawing this weapon should make NPCs react
var bool				bUseWhileCrouched;		// True if NPCs should crouch while using this weapon
var bool				bUseAsDrawnWeapon;		// True if this weapon should be carried by NPCs as a drawn weapon
var bool				bWasInFiring;

var bool bNearWall;								// used for prox. mine placement
var Vector placeLocation;						// used for prox. mine placement
var Vector placeNormal;							// used for prox. mine placement
var Mover placeMover;							// used for prox. mine placement

var float ShakeTimer;
var float ShakeYaw;
var float ShakePitch;

var float AIMinRange;							// minimum "best" range for AI; 0=default min range
var float AIMaxRange;							// maximum "best" range for AI; 0=default max range
var float AITimeLimit;							// maximum amount of time an NPC should hold the weapon; 0=no time limit
var float AIFireDelay;							// Once fired, use as fallback weapon until the timeout expires; 0=no time limit

var float standingTimer;						// how long we've been standing still (to increase accuracy)
var float currentAccuracy;						// what the currently calculated accuracy is (updated every tick)

var MuzzleFlash flash;							// muzzle flash actor

var float MinSpreadAcc;        // Minimum accuracy for multiple slug weapons (shotgun).  Affects only multiplayer,
                               // keeps shots from all going in same place (ruining shotgun effect)
var float MinProjSpreadAcc;
var float MinWeaponAcc;        // Minimum accuracy for a weapon at all.  Affects only multiplayer.

var bool	bDestroyOnFinish;

var float	mpReloadTime;			
var int		mpHitDamage;
var float	mpBaseAccuracy;
var int		mpAccurateRange;
var int		mpMaxRange;
var int		mpReloadCount;
var int		mpPickupAmmoCount;

// Used to track weapon mods accurately.
var bool bCanHaveModBaseAccuracy;
var bool bCanHaveModReloadCount;
var bool bCanHaveModAccurateRange;
var bool bCanHaveModReloadTime;
var bool bCanHaveModRecoilStrength;
var travel float ModBaseAccuracy;
var travel float ModReloadCount;
var travel float ModAccurateRange;
var travel float ModReloadTime;
var travel float ModRecoilStrength;

var localized String msgCannotBeReloaded;
var localized String MsgOutOf;
var localized String MsgNowHas;
var localized String msgAlreadyHas;
var localized String msgNone;
var localized String msgLockInvalid;
var localized String msgLockRange;
var localized String msgLockAcquire;
var localized String msgLockLocked;
var localized String msgRangeUnit;
var localized String msgTimeUnit;
var localized String msgMassUnit;
var localized String msgNotWorking;

//
// strings for info display
//
var localized String msgInfoAmmoLoaded;
var localized String msgInfoAmmo;
var localized String msgInfoDamage;
var localized String msgInfoClip;
var localized String msgInfoROF;
var localized String msgInfoReload;
var localized String msgInfoRecoil;
var localized String msgInfoAccuracy;
var localized String msgInfoAccRange;
var localized String msgInfoMaxRange;
var localized String msgInfoMass;
var localized String msgInfoLaser;
var localized String msgInfoScope;
var localized String msgInfoSilencer;
var localized String msgInfoNA;
var localized String msgInfoYes;
var localized String msgInfoNo;
var localized String msgInfoAuto;
var localized String msgInfoSingle;
var localized String msgInfoRounds;
var localized String msgInfoRoundsPerSec;
var localized String msgInfoSkill;
var localized String msgInfoWeaponStats;

var bool		bClientReadyToFire, bClientReady, bInProcess, bFlameOn, bLooping;
var int		SimClipCount, flameShotCount, SimAmmoAmount;
var float	TimeLockSet;

*/
var Sound FireSounds[3]; // For ammo specific fire sounds if FireSounds[j]!=None.

var const bool bIsGrenade; // Used for special handling for grenade ammo.
var const bool bCanDrop;   // Whether we can be DropItem'ed.

var const localized string MsgAmmoLoaded;
var const localized string MsgCannotBeDroppedInState; // More like some sort of debug output...
var const localized string MsgCannotThrow;
var const localized string MsgDropNotAllowed;

// ----------------------------------------------------------------------------
// network replication
// ----------------------------------------------------------------------------
/*
replication
{
    // server to client
    reliable if ((Role == ROLE_Authority) && (bNetOwner))
        ClipCount, bZoomed, bHasSilencer, bHasLaser, ModBaseAccuracy, ModReloadCount, ModAccurateRange, ModReloadTime, ModRecoilStrength;

	// Things the client should send to the server
	//reliable if ( (Role<ROLE_Authority) )
		//LockTimer, Target, LockMode, TargetMessage, TargetRange, bCanTrack, LockTarget;

    // Functions client calls on server
    reliable if ( Role < ROLE_Authority )
        ReloadAmmo, LoadAmmo, CycleAmmo, LaserOn, LaserOff, LaserToggle, ScopeOn, ScopeOff, ScopeToggle, PropagateLockState, ServerForceFire, 
		  ServerGenerateBullet, ServerGotoFinishFire, ServerHandleNotify, StartFlame, StopFlame, ServerDoneReloading, DestroyOnFinish;

    // Functions Server calls in client
    reliable if ( Role == ROLE_Authority )
      RefreshScopeDisplay, ReadyClientToFire, SetClientAmmoParams, ClientDownWeapon, ClientActive, ClientReload;
}
*/

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	// Save Precessors name aside for debugging purposes.
	PrecessorName        = Other.Name;

	// Advanced (partial).
	bHidden              = Other.bHidden;
	bOwned               = Other.bOwned;

	// Collision and Blocking.
	bCollideWhenPlacing = Other.bCollideWhenPlacing; // Still used for far moving after spawn.
	bCollideWorld       = true; //Other.bCollideWorld;

	SetCollisionSize( Other.CollisionRadius, Other.CollisionHeight );
	SetCollision( Other.bCollideActors, Other.bBlockActors, Other.bBlockPlayers );

	// Events. 
	Event                = Other.Event;
//Tag                  = Other.Tag;   // Set by Spawn.

	// Object (partial).
	Group                = Other.Group;

	// Filter.
	bDifficulty0         = Other.bDifficulty0;
	bDifficulty1         = Other.bDifficulty1;
	bDifficulty2         = Other.bDifficulty2;
	bDifficulty3         = Other.bDifficulty3;
	bSinglePlayer        = Other.bSinglePlayer;

	// Make sure old Actor has Tag, Event, Group, BindName and BarkBindName removed.
	Other.Tag            = '';
	Other.Event          = '';
	Other.Group          = '';
	Other.BindName       = "";
	Other.BarkBindName   = "";
}

// ----------------------------------------------------------------------------
// IsInRelevant()
// 
// Whether code is currently running during a spawn inside a mutator in which
// case the properties are not yet properly set.
// ----------------------------------------------------------------------------

simulated function bool IsInRelevant()
{
	if ( Level.Game==None ) // Will happen on client too.
		return false;
	return Level.Game.IsInState( 'InIsRelevant' );
}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	Super.Spawned();

	if ( Level.bStartup )
		bGameRelevant = true;

	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	// Handle autodestruction if desired. Moved this here because the
	// config properties won't have their correct value set when spawned inside
	// the mutator, so you can't replace them at first pass there.
	if ( !bGameRelevant && Level.NetMode!=NM_Client && !Level.Game.IsRelevant(Self) )
	{
		Destroy();
		return;
	}
}

// -----------------------------------------------------------------------------
// PostBeginPlay()
// -----------------------------------------------------------------------------

function PostBeginPlay()
{
	Super(Weapon).PostBeginPlay();
}

// ----------------------------------------------------------------------------
// SetInitialState()
//
// Called after PostBeginPlay.
// ----------------------------------------------------------------------------

simulated event SetInitialState()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( InitialState!='' )
		GotoState( InitialState );
	else
		GotoState( 'Auto' );

	bSpawning = false;
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------------

event PostPostBeginPlay()
{
	// This may need to be reset, as a new GameInfo is spawned each time.
	Game = HXGameInfo(Level.Game);

	Super(Weapon).PostPostBeginPlay();
}

// ----------------------------------------------------------------------------
// FellOutOfWorld()
// ----------------------------------------------------------------------------

event FellOutOfWorld()
{
	if ( PrecessorName!='' )
	{
		Log( Sprintf("Precessor of falling out of world %s was %s.",Name,PrecessorName), 'FellOutOfWorld' );
	}

	SetPhysics( PHYS_None );
	Destroy();
}

// ----------------------------------------------------------------------------
// PropagateLockState()
// ----------------------------------------------------------------------------

simulated function PropagateLockState(ELockMode NewMode, Actor NewTarget)
{
   LockMode = NewMode;
   LockTarget = NewTarget;
}

// ----------------------------------------------------------------------------
// SetLockMode()
// ----------------------------------------------------------------------------
simulated function SetLockMode(ELockMode NewMode)
{
   if ((LockMode != NewMode) && (Role != ROLE_Authority))
   {
      if (NewMode != LOCK_Locked)
         PropagateLockState(NewMode, None);
      else
         PropagateLockState(NewMode, Target);
   }
	TimeLockSet = Level.Timeseconds;
   LockMode = NewMode;
}

// ----------------------------------------------------------------------------
// PlayLockSound()
// Because playing a sound from a simulated function doesn't play it 
// server side.
// ----------------------------------------------------------------------------
function PlayLockSound()
{
   Owner.PlaySound(LockedSound, SLOT_None);
}

// ----------------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------------

function TravelPostAccept()
{
	local int i;

	// Weapon.
	if ( Pawn(Owner)!=None )
	{
		if ( AmmoName!=None )
		{
			// DEUS_EX CNN - if AmmoType isn't already set (through a travel),
			// find the default in the inventory list
			if ( AmmoType==None )
			{		
				AmmoType = Ammo(Pawn(Owner).FindInventoryType(AmmoName));
				if ( AmmoType==None )
				{
					AmmoType = Spawn(AmmoName);	// Create ammo type required		
					Pawn(Owner).AddInventory(AmmoType);		// and add to player's inventory
					AmmoType.BecomeItem();
					AmmoType.AmmoAmount = 0; //PickUpAmmoCount; // Don't want to magically add any amount of ammo here. --han
					AmmoType.GotoState('Idle2');
				}
			}
		}
		if ( Self==Pawn(Owner).Weapon )
			BringUp();
		else
			GoToState('Idle2');
	}

	// Reset Weapon based on AmmoType (installs the correct projectile info if needed, etc.).
	if ( AmmoType!=None )
	{
		LoadAmmoTypeExt( AmmoType, true, true, true );
	}
}

// -----------------------------------------------------------------------------
// BaseChange()
// -----------------------------------------------------------------------------

singular function BaseChange()
{
	Super(Weapon).BaseChange();

	// Make sure we fall if we don't have a base.
	if ( Base==None && Owner==None )
		SetPhysics( PHYS_Falling );
}

// -----------------------------------------------------------------------------
// HandlePickupQuery()
// -----------------------------------------------------------------------------

function bool HandlePickupQuery( Inventory Item )
{
	local HXWeapon W;
	local HXPlayerPawn player;
	local bool bResult;
	local class<Ammo> defAmmoClass;
	local Ammo defAmmo;
	local HXPlayerPawn PickupOwner;

	PickupOwner = HXPlayerPawn( Owner );
	
	// make sure that if you pick up a modded weapon that you
	// already have, you get the mods
	W = HXWeapon(Item);
	if ((W != None) && (W.Class == Class))
	{
		if (W.ModBaseAccuracy > ModBaseAccuracy)
		{
			ModBaseAccuracy = W.ModBaseAccuracy;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModAccuracy'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}
		if (W.ModReloadCount > ModReloadCount)
		{
			ModReloadCount = W.ModReloadCount;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModReload'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}
		if (W.ModAccurateRange > ModAccurateRange)
		{
			ModAccurateRange = W.ModAccurateRange;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModRange'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}

		// these are negative
		if (W.ModReloadTime < ModReloadTime)
		{
			ModReloadTime = W.ModReloadTime;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModReload'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}
		if (W.ModRecoilStrength < ModRecoilStrength)
		{
			ModRecoilStrength = W.ModRecoilStrength;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModRecoil'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}

		if ( W.bHasLaser && !bHasLaser )
		{
			bHasLaser = True;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModLaser'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}
		if ( W.bHasSilencer && !bHasSilencer )
		{
			bHasSilencer = True;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModSilencer'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}
		if ( W.bHasScope && !bHasScope )
		{
			bHasScope = True;

			if ( PickupOwner != None )
				PickupOwner.ClientMessage( PickupMessage@ItemArticle@class'HXWeaponModScope'.Default.ItemName@"for your"@itemName $ ".", 'Pickup' );
		}

		// copy the actual stats as well
		if (W.ReloadCount > ReloadCount)
			ReloadCount = W.ReloadCount;
		if (W.AccurateRange > AccurateRange)
			AccurateRange = W.AccurateRange;

		// these are negative
		if (W.BaseAccuracy < BaseAccuracy)
			BaseAccuracy = W.BaseAccuracy;
		if (W.ReloadTime < ReloadTime)
			ReloadTime = W.ReloadTime;
		if (W.RecoilStrength < RecoilStrength)
			RecoilStrength = W.RecoilStrength;
	}
	player = HXPlayerPawn(Owner);

	if (Item.Class == Class)
	{
    if (!( (Weapon(item).bWeaponStay && (Level.NetMode == NM_Standalone)) && (!Weapon(item).bHeldItem || Weapon(item).bTossedOut)))
		{
			// Only add ammo of the default type
			// There was an easy way to get 32 20mm shells, buy picking up another assault rifle with 20mm ammo selected
			if ( AmmoType != None )
			{
				// Add to default ammo only
				if ( AmmoNames[0] == None )
					defAmmoClass = AmmoName;
				else
					defAmmoClass = AmmoNames[0];

				defAmmo = Ammo(player.FindInventoryType(defAmmoClass));
				defAmmo.AddAmmo( Weapon(Item).PickupAmmoCount );

				if ( Level.NetMode != NM_Standalone )
				{
					if (( player != None ) && ( player.InHand != None ))
					{
						if ( HXWeapon(item).class == HXWeapon(player.InHand).class )
							ReadyToFire();
					}
				}
			}
		}
	}

	bResult = Super(Weapon).HandlePickupQuery(Item);

	// Notify the object belt of the new ammo
	//if (player != None)
		//player.UpdateBeltText(Self);

	return bResult;
}

function BringUp()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( false );

	// alert NPCs that I'm whipping it out
	if (!bNativeAttack && bEmitWeaponDrawn)
		AIStartEvent('WeaponDrawn', EAITYPE_Visual);

	// reset the standing still accuracy bonus
	standingTimer = 0;

	Super(Weapon).BringUp();
}

function bool PutDown()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( false );

	// alert NPCs that I'm putting away my gun
	AIEndEvent('WeaponDrawn', EAITYPE_Visual);

	// reset the standing still accuracy bonus
	standingTimer = 0;

	return Super(Weapon).PutDown();
}

simulated function TweenDown()
{
	if ( (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
		TweenAnim( AnimSequence, AnimFrame * 0.4 );
	else
	{
		// Have the put away animation play twice as fast in multiplayer
		//if ( Level.NetMode != NM_Standalone )
			//PlayAnim('Down', 2.0, 0.05);
		//else
			PlayAnim('Down', 1.0, 0.05);
	}
}

function ReloadAmmo()
{
	// single use or hand to hand weapon if ReloadCount == 0
	if (ReloadCount == 0)
	{
		Pawn(Owner).ClientMessage(msgCannotBeReloaded);
		return;
	}

	if (!IsInState('Reload'))
	{
		TweenAnim('Still', 0.1);
		GotoState('Reload');
	}
}

//
// Note we need to control what's calling this...but I'll get rid of the access nones for now
//
simulated function float GetWeaponSkill()
{
	local HXPlayerPawn player;
	local float value;

	value = 0;

	if ( Owner != None )
	{
		player = HXPlayerPawn(Owner);
		if (player != None)
		{
			if ((player.AugmentationSystem != None ) && ( player.SkillSystem != None ))
			{
				// get the target augmentation
				value = player.AugmentationSystem.GetAugLevelValue(class'HXAugTarget');
				if (value == -1.0)
					value = 0;

				// get the skill
				value += player.SkillSystem.GetSkillLevelValue(GoverningSkill);
			}
		}
	}
	return value;
}

// calculate the accuracy for this weapon and the owner's damage
simulated function float CalculateAccuracy()
{
	local float accuracy;	// 0 is dead on, 1 is pretty far off
	local float tempacc, div;
	local float weapskill; // so we don't keep looking it up (slower).
	local int HealthArmRight, HealthArmLeft, HealthHead;
	local int BestArmRight, BestArmLeft, BestHead;
	local bool checkit;
	local HXPlayerPawn player;

	accuracy = BaseAccuracy;		// start with the weapon's base accuracy
	weapskill = GetWeaponSkill();

	player = HXPlayerPawn(Owner);

	if (player != None)
	{
		// check the player's skill
		// 0.0 = dead on, 1.0 = way off
		accuracy += weapskill;

		// get the health values for the player
		HealthArmRight = player.HealthArmRight;
		HealthArmLeft  = player.HealthArmLeft;
		HealthHead     = player.HealthHead;
		BestArmRight   = player.Default.HealthArmRight;
		BestArmLeft    = player.Default.HealthArmLeft;
		BestHead       = player.Default.HealthHead;
		checkit = True;
	}
	else if (HXScriptedPawn(Owner) != None)
	{
		// update the weapon's accuracy with the HXScriptedPawn's BaseAccuracy
		// (BaseAccuracy uses higher values for less accuracy, hence we add)
		accuracy += HXScriptedPawn(Owner).BaseAccuracy;

		// get the health values for the NPC
		HealthArmRight = HXScriptedPawn(Owner).HealthArmRight;
		HealthArmLeft  = HXScriptedPawn(Owner).HealthArmLeft;
		HealthHead     = HXScriptedPawn(Owner).HealthHead;
		BestArmRight   = HXScriptedPawn(Owner).Default.HealthArmRight;
		BestArmLeft    = HXScriptedPawn(Owner).Default.HealthArmLeft;
		BestHead       = HXScriptedPawn(Owner).Default.HealthHead;
		checkit = True;
	}
	else
		checkit = false;

	// Disabled accuracy mods based on health in multiplayer
	//if ( Level.NetMode != NM_Standalone )
		//checkit = false;

	if (checkit)
	{
		if (HealthArmRight < 1)
			accuracy += 0.5;
		else if (HealthArmRight < BestArmRight * 0.34)
			accuracy += 0.2;
		else if (HealthArmRight < BestArmRight * 0.67)
			accuracy += 0.1;

		if (HealthArmLeft < 1)
			accuracy += 0.5;
		else if (HealthArmLeft < BestArmLeft * 0.34)
			accuracy += 0.2;
		else if (HealthArmLeft < BestArmLeft * 0.67)
			accuracy += 0.1;

		if (HealthHead < BestHead * 0.67)
			accuracy += 0.1;
	}

	// increase accuracy (decrease value) if we haven't been moving for awhile
	// this only works for the player, because NPCs don't need any more aiming help!
	if (player != None)
	{
		tempacc = accuracy;
		if (standingTimer > 0)
		{
			// higher skill makes standing bonus greater
			div = Max(15.0 + 29.0 * weapskill, 0.0);
			accuracy -= FClamp(standingTimer/div, 0.0, 0.6);
	
			// don't go too low
			if ((accuracy < 0.1) && (tempacc > 0.1))
				accuracy = 0.1;
		}
	}

	// make sure we don't go negative
	if (accuracy < 0.0)
		accuracy = 0.0;

//   if (Level.NetMode != NM_Standalone)
//     if (accuracy < MinWeaponAcc)
//        accuracy = MinWeaponAcc;

	// Scale accuracy of pawns based on difficulty
	if ( ROLE == ROLE_Authority && Owner.IsA('HXScriptedPawn') && Level.Game != None && Level.Game.IsA('HXGameInfo') )
	{
		accuracy *= HXGameInfo(Level.Game).ScalePawnAccuracy( Self, HXScriptedPawn(Owner) );
	}

	return accuracy;
}

//
// functions to change ammo types
//
function bool LoadAmmo( int AmmoNum )
{
	return LoadAmmoExt( AmmoNum );
}

//
// Extended LoadAmmo function to take more parameters.
//
function bool LoadAmmoExt( int AmmoNum, optional bool bForce, optional bool bSilent, optional bool bSkipReload )
{
	local Class<Ammo> NewAmmoClass;
	local Ammo NewAmmo;
	local Pawn P;

	if ( AmmoNum<0 || AmmoNum>2 )
		return false;

	P = Pawn(Owner);

	// Sorry, only pawns can have weapons.
	if ( P==None )
		return false;

	NewAmmoClass = AmmoNames[AmmoNum];

	if ( NewAmmoClass!=None )
	{
		if ( NewAmmoClass!=AmmoName || bForce )
		{
			NewAmmo = Ammo(P.FindInventoryType(NewAmmoClass));
			if ( NewAmmo==None )
			{
				if ( !bSilent )
				{
					P.ClientMessage( Sprintf(MsgOutOf, NewAmmoClass.Default.ItemName) );
				}
				return false;
			}
			
			// If we don't have a projectile for this ammo type, then set instant hit.
			if ( ProjectileNames[AmmoNum]==None )
			{
				bInstantHit = true;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;

				if ( HasReloadMod() )
				{
					ReloadTime = Default.ReloadTime*(1.0+ModReloadTime);
				}
				else
				{
					ReloadTime = Default.ReloadTime;
				}

				// Set custom FireSound if available.
				if ( FireSounds[AmmoNum]!=None )
					FireSound = FireSounds[AmmoNum];
				else
					FireSound = Default.FireSound;

				ProjectileClass = None;
			}
			else
			{
				// otherwise, set us to fire projectiles
				bInstantHit = false;
				bAutomatic = false;
				ShotTime = 1.0;

				if ( HasReloadMod() )
				{
					ReloadTime = 2.0*(1.0+ModReloadTime);
				}
				else
				{
					ReloadTime = 2.0;
				}

				// Defauls to no fire sound (but set for each projectile?).
				FireSound = FireSounds[AmmoNum];

				ProjectileClass = ProjectileNames[AmmoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;
			}

			AmmoName = NewAmmoClass;
			AmmoType = NewAmmo;

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if ( HXPlayerPawn(P)!=None && !bSilent )
			{
				//HXPlayerPawn(P).UpdateBeltText(Self);
				HXPlayerPawn(P).ClientUpdatePersonaStatusLineWindow( Sprintf(MsgAmmoLoaded,AmmoName.Default.ItemName) );
				HXPlayerPawn(P).ClientUpdatePersonaScreenInventoryAmmoSelected( Self.Class, AmmoName );
			}

			if ( !bSkipReload )
			{
				ReloadAmmo();
			}

			if ( !bSilent )
			{
				P.ClientMessage( Sprintf(MsgNowHas,ItemName,NewAmmoClass.Default.ItemName) );
			}
			return true;
		}
		else
		{
			if ( !bSilent )
			{
				P.ClientMessage( Sprintf(MsgAlreadyHas,ItemName,NewAmmoClass.Default.ItemName) );
			}
		}
	}

	return false;
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------

simulated function SetClientAmmoParams( bool bInstant, bool bAuto, float sTime, Sound FireSnd, class<projectile> pClass, float pSpeed )
{
	bInstantHit = bInstant;
	bAutomatic = bAuto;
	ShotTime = sTime;
	FireSound = FireSnd;
	ProjectileClass = pClass;
	ProjectileSpeed = pSpeed;
}

// -----------------------------------------------------------------------------
// CanLoadAmmoType()
//
// Returns True if this ammo type can be used with this weapon
// -----------------------------------------------------------------------------

simulated function bool CanLoadAmmoType(Ammo ammo)
{
	local int  ammoIndex;
	local bool bCanLoad;

	bCanLoad = false;

	if (ammo != None)
	{
		// First check "AmmoName"

		if (AmmoName == ammo.Class)
		{
			bCanLoad = True;
		}
		else
		{
			for (ammoIndex=0; ammoIndex<3; ammoIndex++)
			{
				if (AmmoNames[ammoIndex] == ammo.Class)
				{
					bCanLoad = True;
					break;
				}
			}
		}
	}

	return bCanLoad;
}

// -----------------------------------------------------------------------------
// LoadAmmoType()
// 
// Load this ammo type given the actual object
// -----------------------------------------------------------------------------

function LoadAmmoType( Ammo Ammo )
{
	LoadAmmoTypeExt( Ammo );
}
function LoadAmmoTypeExt( Ammo Ammo, optional bool bForce, optional bool bSilent, optional bool bSkipReload )
{
	local int i;

	if ( Ammo!=None )
		for ( i=0; i<ArrayCount(AmmoNames); i++ )
			if ( AmmoNames[i]==Ammo.Class )
				LoadAmmoExt( i, bForce, bSilent, bSkipReload );
}

// -----------------------------------------------------------------------------
// LoadAmmoClass()
// 
// Load this ammo type given the class
// -----------------------------------------------------------------------------

function LoadAmmoClass( Class<Ammo> AmmoClass )
{
	LoadAmmoClassExt( AmmoClass );
}
function LoadAmmoClassExt( Class<Ammo> AmmoClass, optional bool bForce, optional bool bSilent, optional bool bSkipReload )
{
	local int i;

	if ( AmmoClass!=None )
		for (i=0; i<ArrayCount(AmmoNames); i++)
			if ( AmmoNames[i]==AmmoClass )
				LoadAmmoExt( i, bForce, bSilent, bSkipReload );
}

// -----------------------------------------------------------------------------
// CycleAmmo()
// -----------------------------------------------------------------------------

function CycleAmmo()
{
	local int i, last;

	if (NumAmmoTypesAvailable() < 2)
		return;

	for (i=0; i<ArrayCount(AmmoNames); i++)
		if (AmmoNames[i] == AmmoName)
			break;

	last = i;

	do
	{
		if (++i >= 3)
			i = 0;

		if (LoadAmmo(i))
			break;
	} until (last == i);
}

simulated function bool CanReload()
{
	if ((ClipCount > 0) && (ReloadCount != 0) && (AmmoType != None) && (AmmoType.AmmoAmount > 0) &&
	    (AmmoType.AmmoAmount > (ReloadCount-ClipCount)))
		return true;
	else
		return false;
}

simulated function bool MustReload()
{
	if ((AmmoLeftInClip() == 0) && (AmmoType != None) && (AmmoType.AmmoAmount > 0))
		return true;
	else
		return false;
}

simulated function int AmmoLeftInClip()
{
	if (ReloadCount == 0)	// if this weapon is not reloadable
		return 1;
	else if (AmmoType == None)
		return 0;
	else if (AmmoType.AmmoAmount == 0)		// if we are out of ammo
		return 0;
	else if (ReloadCount - ClipCount > AmmoType.AmmoAmount)		// if we have no clips left
		return AmmoType.AmmoAmount;
	else
		return ReloadCount - ClipCount;
}

simulated function int NumClips()
{
	if (ReloadCount == 0)  // if this weapon is not reloadable
		return 0;
	else if (AmmoType == None)
		return 0;
	else if (AmmoType.AmmoAmount == 0)	// if we are out of ammo
		return 0;
	else  // compute remaining clips
		return ((AmmoType.AmmoAmount-AmmoLeftInClip()) + (ReloadCount-1)) / ReloadCount;
}

simulated function int AmmoAvailable(int AmmoNum)
{
	local class<Ammo> NewAmmoClass;
	local Ammo NewAmmo;
	local Pawn P;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return 0;

	NewAmmoClass = AmmoNames[AmmoNum];

	if (NewAmmoClass == None)
		return 0;

	NewAmmo = Ammo(P.FindInventoryType(NewAmmoClass));

	if (NewAmmo == None)
		return 0;

	return NewAmmo.AmmoAmount;
}

simulated function int NumAmmoTypesAvailable()
{
	local int i;

	for (i=0; i<ArrayCount(AmmoNames); i++)
		if (AmmoNames[i] == None)
			break;

	// to make Al fucking happy
	if (i == 0)
		i = 1;

	return i;
}

function name WeaponDamageType()
{
	local name                    damageType;
	local Class<HXProjectile> projClass;

	projClass = Class<HXProjectile>(ProjectileClass);
	if (bInstantHit)
	{
		if (StunDuration > 0)
			damageType = 'Stunned';
		else
			damageType = 'Shot';

		if (AmmoType != None)
			if (AmmoType.IsA('HXAmmoSabot'))
				damageType = 'Sabot';
	}
	else if (projClass != None)
		damageType = projClass.Default.damageType;
	else
		damageType = 'None';

	return (damageType);
}


//
// target tracking info
//
simulated function Actor AcquireTarget()
{
	local vector StartTrace, EndTrace, HitLocation, HitNormal;
	local Actor hit, retval;
	local Pawn p;

	p = Pawn(Owner);
	if (p == None)
		return None;

	StartTrace = p.Location;
	if (PlayerPawn(p) != None)
		EndTrace = p.Location + (10000 * Vector(p.ViewRotation));
	else
		EndTrace = p.Location + (10000 * Vector(p.Rotation));

	// adjust for eye height
	StartTrace.Z += p.BaseEyeHeight;
	EndTrace.Z += p.BaseEyeHeight;

	foreach TraceActors(class'Actor', hit, HitLocation, HitNormal, EndTrace, StartTrace)
		if (!hit.bHidden && (hit.IsA('Decoration') || hit.IsA('Pawn')))
			return hit;

	return None;
}

//
// Used to determine if we are near (and facing) a wall for placing LAMs, etc.
//
simulated function bool NearWallCheck()
{
	local Vector StartTrace, EndTrace, HitLocation, HitNormal;
	local Actor HitActor;

	// Scripted pawns can't place LAMs
	if (HXScriptedPawn(Owner) != None)
		return false;

	// Don't let players place grenades when they have something highlighted
	//if ( Level.NetMode != NM_Standalone )
	//{
		//if ( Owner.IsA('HXPlayerPawn') && (HXPlayerPawn(Owner).frobTarget != None) )
		//{
			//if ( HXPlayerPawn(Owner).IsFrobbable( HXPlayerPawn(Owner).frobTarget ) )
				//return false;
		//}
	//}

	// trace out one foot in front of the pawn
	StartTrace = Owner.Location;
	EndTrace = StartTrace + Vector(Pawn(Owner).ViewRotation) * 32;

	StartTrace.Z += Pawn(Owner).BaseEyeHeight;
	EndTrace.Z += Pawn(Owner).BaseEyeHeight;

	HitActor = Trace(HitLocation, HitNormal, EndTrace, StartTrace);
	if ((HitActor == Level) || ((HitActor != None) && HitActor.IsA('Mover')))
	{
		placeLocation = HitLocation;
		placeNormal = HitNormal;
		placeMover = Mover(HitActor);
		return True;
	}

	return false;
}

//
// used to place a grenade on the wall
//
function PlaceGrenade()
{
	local HXThrownProjectile gren;
	local float dmgX;

	gren = HXThrownProjectile(spawn(ProjectileClass, Owner,, placeLocation, Rotator(placeNormal)));
	if (gren != None)
	{
		AmmoType.UseAmmo(1);
		if ( AmmoType.AmmoAmount <= 0 )
			bDestroyOnFinish = True;

		gren.PlayAnim('Open');
		gren.PlaySound(gren.MiscSound, SLOT_None, 0.5+FRand()*0.5,, 512, 0.85+FRand()*0.3);
		gren.SetPhysics(PHYS_None);
		gren.bBounce = false;
		gren.bProximityTriggered = True;
		gren.bStuck = true;
		gren.bHighlight = true;
		gren.bIgnoresNanoDefense = true;
		if (placeMover != None)
			gren.SetBase(placeMover);

		// up the damage based on the skill
		// returned value from GetWeaponSkill is negative, so negate it to make it positive
		// dmgX value ranges from 1.0 to 2.4 (max demo skill and max target aug)
		dmgX = -2.0 * GetWeaponSkill() + 1.0;
		gren.Damage *= dmgX;

		// Update ammo count on object belt
		//if (HXPlayerPawn(Owner) != None)
			//HXPlayerPawn(Owner).UpdateBeltText(Self);
	}
}

//
// scope, laser, and targetting updates are done here
//
simulated function Tick(float deltaTime)
{
	local vector loc;
	local rotator rot;
	local float beepspeed, recoil;
	local HXPlayerPawn player;
   local Actor RealTarget;
	local Pawn pawn;

	player = HXPlayerPawn(Owner);
	pawn = Pawn(Owner);

	Super(Weapon).Tick(deltaTime);

	// don't do any of this if this weapon isn't currently in use
	if (pawn == None)
   {
      LockMode = LOCK_None;
      MaintainLockTimer = 0;
      LockTarget = None;
      LockTimer = 0;
		return;
   }

	if (pawn.Weapon != self)
   {
      LockMode = LOCK_None;
      MaintainLockTimer = 0;
      LockTarget = None;
      LockTimer = 0;
		return;
   }

	// all this should only happen IF you have ammo loaded
	if (ClipCount < ReloadCount)
	{
		// check for LAM or other placed mine placement
		if (bHandToHand && (ProjectileClass != None) && (!Self.IsA('HXWeaponShuriken')))
		{
			if (NearWallCheck())
			{
				if (( Level.NetMode != NM_Standalone ) && IsAnimating() && (AnimSequence == 'Select'))
				{
				}
				else
				{
					if (!bNearWall || (AnimSequence == 'Select'))
					{
						PlayAnim('PlaceBegin',, 0.1);
						bNearWall = True;
					}
				}
			}
			else
			{
				if (bNearWall)
				{
					PlayAnim('PlaceEnd',, 0.1);
					bNearWall = false;
				}
			}
		}


      SoundTimer += deltaTime;

      if ( (Level.Netmode == NM_Standalone) || ( (Player != None) && (Player.PlayerIsClient()) ) )
      {
         if (bCanTrack)
         {
            Target = AcquireTarget();
            RealTarget = Target;
            
            // calculate the range
            if (Target != None)
               TargetRange = Abs(VSize(Target.Location - Location));
            
            // update our timers
            //SoundTimer += deltaTime;
            MaintainLockTimer -= deltaTime;
            
            // check target and range info to see what our mode is
            if ((Target == None) || IsInState('Reload'))
            {
               if (MaintainLockTimer <= 0)
               {				
                  SetLockMode(LOCK_None);
                  MaintainLockTimer = 0;
                  LockTarget = None;
               }
               else if (LockMode == LOCK_Locked)
               {
                  Target = LockTarget;
               }
            }
            else if ((Target != LockTarget) && (Target.IsA('Pawn')) && (LockMode == LOCK_Locked))
            {
               SetLockMode(LOCK_None);
               LockTarget = None;
            }
            else if (!Target.IsA('Pawn'))
            {
               if (MaintainLockTimer <=0 )
               {
                  SetLockMode(LOCK_Invalid);
               }
            }
            else if ( (Target.IsA('HXPlayerPawn')) && (Target.Style == STY_Translucent) )
            {
               //DEUS_EX AMSD Don't allow locks on cloaked targets.
               SetLockMode(LOCK_Invalid);
            }
            else
            {
               if (TargetRange > MaxRange)
               {
                  SetLockMode(LOCK_Range);
               }
               else
               {
                  // change LockTime based on skill
                  // -0.7 = max skill
                  // DEUS_EX AMSD Only do weaponskill check here when first checking.
                  if (LockTimer == 0)
                  {
                     LockTime = FMax(Default.LockTime + 3.0 * GetWeaponSkill(), 0.0);
                     //if ((Level.Netmode != NM_Standalone) && (LockTime < 0.25))
                        //LockTime = 0.25;
                  }
                  
                  LockTimer += deltaTime;
                  if (LockTimer >= LockTime)
                  {
                     SetLockMode(LOCK_Locked);
                  }
                  else
                  {
                     SetLockMode(LOCK_Acquire);
                  }
               }
            }
            
            // act on the lock mode
            switch (LockMode)
            {
            case LOCK_None:
               TargetMessage = msgNone;
               LockTimer -= deltaTime;
               break;
               
            case LOCK_Invalid:
               TargetMessage = msgLockInvalid;
               LockTimer -= deltaTime;
               break;
               
            case LOCK_Range:
               TargetMessage = msgLockRange @ Int(TargetRange/16) @ msgRangeUnit;
               LockTimer -= deltaTime;
               break;
               
            case LOCK_Acquire:
               TargetMessage = msgLockAcquire @ Left(String(LockTime-LockTimer), 4) @ msgTimeUnit;
               beepspeed = FClamp((LockTime - LockTimer) / Default.LockTime, 0.2, 1.0);
               if (SoundTimer > beepspeed)
               {
                  Owner.PlaySound(TrackingSound, SLOT_None);
                  SoundTimer = 0;
               }
               break;
               
            case LOCK_Locked:
               // If maintaining a lock, or getting a new one, increment maintainlocktimer
               if ((RealTarget != None) && ((RealTarget == LockTarget) || (LockTarget == None)))
               {
                  //if (Level.NetMode != NM_Standalone)
                     //MaintainLockTimer = default.MaintainLockTimer;
                  //else
                     MaintainLockTimer = 0;
                  LockTarget = Target;
               }
               TargetMessage = msgLockLocked @ Int(TargetRange/16) @ msgRangeUnit;
               // DEUS_EX AMSD Moved out so server can play it so that client knows for sure when locked.
               /*if (SoundTimer > 0.1)
               {
                  Owner.PlaySound(LockedSound, SLOT_None);
                  SoundTimer = 0;
               }*/
               break;
            }
         }
         else
         {
            LockMode = LOCK_None;
            TargetMessage = msgNone;
            LockTimer = 0;
            MaintainLockTimer = 0;
            LockTarget = None;
         }
         
         if (LockTimer < 0)
            LockTimer = 0;
      }
   }
   else
   {
      LockMode = LOCK_None;
	  TargetMessage=msgNone;
      MaintainLockTimer = 0;
      LockTarget = None;
      LockTimer = 0;
   }

   if ((LockMode == LOCK_Locked) && (SoundTimer > 0.1) && (Role == ROLE_Authority))
   {
      PlayLockSound();
      SoundTimer = 0;
   }

	currentAccuracy = CalculateAccuracy();

	if (player != None)
	{
		// reduce the recoil based on skill
		recoil = recoilStrength + GetWeaponSkill() * 2.0;
		if (recoil < 0.0)
			recoil = 0.0;

		// simulate recoil while firing
		if (bFiring && IsAnimating() && (AnimSequence == 'Shoot') && (recoil > 0.0))
		{
			player.ViewRotation.Yaw += deltaTime * (Rand(4096) - 2048) * recoil;
			player.ViewRotation.Pitch += deltaTime * (Rand(4096) + 4096) * recoil;
			if ((player.ViewRotation.Pitch > 16384) && (player.ViewRotation.Pitch < 32768))
				player.ViewRotation.Pitch = 16384;
		}
	}

	// if were standing still, increase the timer
	if (VSize(Owner.Velocity) < 10)
		standingTimer += deltaTime;
	else	// otherwise, decrease it slowly based on velocity
		standingTimer = FMax(0, standingTimer - 0.03*deltaTime*VSize(Owner.Velocity));

	if (bLasing || bZoomed)
	{
		// shake our view to simulate poor aiming
		if (ShakeTimer > 0.25)
		{
			ShakeYaw = currentAccuracy * (Rand(4096) - 2048);
			ShakePitch = currentAccuracy * (Rand(4096) - 2048);
			ShakeTimer -= 0.25;
		}

		ShakeTimer += deltaTime;

		if (bLasing && (Emitter != None))
		{
			loc = Owner.Location;
			loc.Z += Pawn(Owner).BaseEyeHeight;

			// add a little random jitter - looks cool!
			rot = Pawn(Owner).ViewRotation;
			rot.Yaw += Rand(5) - 2;
			rot.Pitch += Rand(5) - 2;

			Emitter.SetLocation(loc);
			Emitter.SetRotation(rot);
		}

		if ((player != None) && bZoomed)
		{
			player.ViewRotation.Yaw += deltaTime * ShakeYaw;
			player.ViewRotation.Pitch += deltaTime * ShakePitch;
		}
	}
}

//
// scope functions for weapons which have them
//

function ScopeOn()
{
	if (bHasScope && !bZoomed && (Owner != None) && Owner.IsA('HXPlayerPawn'))
	{
		// Show the Scope View
		bZoomed = True;
		RefreshScopeDisplay(HXPlayerPawn(Owner), false, bZoomed);
	}
}

function ScopeOff()
{
	if (bHasScope && bZoomed && (Owner != None) && Owner.IsA('HXPlayerPawn'))
	{
		bZoomed = false;
		// Hide the Scope View
      RefreshScopeDisplay(HXPlayerPawn(Owner), false, bZoomed);
		//HXRootWindow(HXPlayerPawn(Owner).rootWindow).scopeView.DeactivateView();
	}
}

simulated function ScopeToggle()
{
	if (IsInState('Idle'))
	{
		if (bHasScope && (Owner != None) && Owner.IsA('HXPlayerPawn'))
		{
			if (bZoomed)
				ScopeOff();
			else
				ScopeOn();
		}
	}
}

// -----------------------------------------------------------------------------
// RefreshScopeDisplay()
// -----------------------------------------------------------------------------

simulated function RefreshScopeDisplay(DeusExPlayer player, bool bInstant, bool bScopeOn)
{
	if (bScopeOn && (player != None))
	{
		// Show the Scope View
		HXRootWindow(player.rootWindow).scopeView.ActivateView(ScopeFOV, false, bInstant);
	}
   else if (!bScopeOn)
   {
      HXRootWindow(player.rootWindow).scopeView.DeactivateView();
   }
}

//
// laser functions for weapons which have them
//

function LaserOn()
{
	if (bHasLaser && !bLasing)
	{
		// if we don't have an emitter, then spawn one
		// otherwise, just turn it on
		if (Emitter == None)
		{
			Emitter = Spawn(class'LaserEmitter', Self, , Location, Pawn(Owner).ViewRotation);
			if (Emitter != None)
			{
				Emitter.SetHiddenBeam(True);
				Emitter.AmbientSound = None;
				Emitter.TurnOn();
			}
		}
		else
			Emitter.TurnOn();

		bLasing = True;
	}
}

function LaserOff()
{
	if (bHasLaser && bLasing)
	{
		if (Emitter != None)
			Emitter.TurnOff();

		bLasing = false;
	}
}

function LaserToggle()
{
	if (IsInState('Idle'))
	{
		if (bHasLaser)
		{
			if (bLasing)
				LaserOff();
			else
				LaserOn();
		}
	}
}

simulated function SawedOffCockSound()
{
	if ((AmmoType.AmmoAmount > 0) && (HXWeaponSawedOffShotgun(Self) != None))
		Owner.PlaySound(SelectSound, SLOT_None,,, 1024);
}

//
// called from the MESH NOTIFY
//
simulated function SwapMuzzleFlashTexture()
{
   if (!bHasMuzzleFlash)
      return;
	if (FRand() < 0.5)
		MultiSkins[2] = Texture'FlatFXTex34';
	else
		MultiSkins[2] = Texture'FlatFXTex37';

	MuzzleFlashLight();
	SetTimer(0.1, false);
}

simulated function EraseMuzzleFlashTexture()
{
	MultiSkins[2] = None;
}

simulated function Timer()
{
	EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;

 	if (!bHasMuzzleFlash)
		return;

	if ((flash != None) && !flash.bDeleteMe)
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if (flash != None)
			flash.SetBase(Owner);
	}
}

function ServerHandleNotify( bool bInstantHit, class<projectile> ProjClass, float ProjSpeed, bool bWarn )
{
	if (bInstantHit)
		TraceFire(0.0);
	else
		ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
}



//
// HandToHandAttack
// called by the MESH NOTIFY for the H2H weapons
//
simulated function HandToHandAttack()
{
	local bool bOwnerIsPlayerPawn;

	if (bOwnerWillNotify)
		return;

	//Log( Self $ ".HandToHandAttack()" );
	//Log( "Level.NetMode = " $ Level.NetMode );
	//Log( "Owner = " $ Owner );
	//Log( "GetPlayerPawn() = " $ GetPlayerPawn() );

	// The controlling animator should be the one to do the tracefire and projfire
	if ( Level.NetMode != NM_Standalone )
	{
		bOwnerIsPlayerPawn = (HXPlayerPawn(Owner) == HXPlayerPawn(GetPlayerPawn()));

		if (( Role < ROLE_Authority ) && bOwnerIsPlayerPawn )
			ServerHandleNotify( bInstantHit, ProjectileClass, ProjectileSpeed, bWarnTarget );
		else if ( !bOwnerIsPlayerPawn && !Owner.IsA('HXScriptedPawn') )
			return;
	}

	if (HXScriptedPawn(Owner) != None)
		HXScriptedPawn(Owner).SetAttackAngle();

	if (bInstantHit)
		TraceFire(0.0);
	else
		ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

	// if we are a thrown weapon and we run out of ammo, destroy the weapon
	if ( bHandToHand && (ReloadCount > 0) && (SimAmmoAmount <= 0))
	{
		DestroyOnFinish();
		if ( Role < ROLE_Authority )
		{
			ServerGotoFinishFire();
			GotoState('SimQuickFinish');
		}
	}
}

//
// OwnerHandToHandAttack
// called by the MESH NOTIFY for this weapon's owner
//
simulated function OwnerHandToHandAttack()
{
	local bool bOwnerIsPlayerPawn;

	if (!bOwnerWillNotify)
		return;

	//Log( Self $ ".OwnerHandToHandAttack()" );
	//Log( "Level.NetMode = " $ Level.NetMode );
	//Log( "Owner = " $ Owner );
	//Log( "GetPlayerPawn() = " $ GetPlayerPawn() );

	// The controlling animator should be the one to do the tracefire and projfire
	if ( Level.NetMode != NM_Standalone )
	{
		bOwnerIsPlayerPawn = (HXPlayerPawn(Owner) == HXPlayerPawn(GetPlayerPawn()));

		if (( Role < ROLE_Authority ) && bOwnerIsPlayerPawn )
			ServerHandleNotify( bInstantHit, ProjectileClass, ProjectileSpeed, bWarnTarget );
		else if ( !bOwnerIsPlayerPawn && !Owner.IsA('HXScriptedPawn') )
			return;
	}

	if (HXScriptedPawn(Owner) != None)
		HXScriptedPawn(Owner).SetAttackAngle();

	if (bInstantHit)
		TraceFire(0.0);
	else
		ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
}


function ForceFire()
{
	Fire(0);
}

function ForceAltFire()
{
	AltFire(0);
}

//
// ReadyClientToFire is called by the server telling the client it's ok to fire now
//

simulated function ReadyClientToFire( bool bReady )
{
	bClientReadyToFire = bReady;
}

//
// ClientReFire is called when the client is holding down the fire button, loop firing
//

simulated function ClientReFire( float value )
{
	bClientReadyToFire = True;
	bLooping = True;
	bInProcess = false;
	ClientFire(0);
}

function StartFlame()
{
	flameShotCount = 0;
	bFlameOn = True;
	GotoState('FlameThrowerOn');
}

function StopFlame()
{
	bFlameOn = false;
}

//
// ServerForceFire is called from the client when loop firing
//
function ServerForceFire()
{
	bClientReady = True;
	Fire(0);
}

simulated function int PlaySimSound( Sound snd, ESoundSlot Slot, float Volume, float Radius )
{
	if ( Owner != None )
	{
		if ( Level.NetMode == NM_Standalone )
			return ( Owner.PlaySound( snd, Slot, Volume, , Radius ) );
		else
		{
			Owner.PlayOwnedSound( snd, Slot, Volume, , Radius );
			return 1;
		}
	}
	return 0;
}

//
// ClientFire - Attempts to play the firing anim, sounds, and trace fire hits for instant weapons immediately
//				on the client.  The server may have a different interpretation of what actually happen, but this at least
//				cuts down on preceived lag.
//
simulated function bool ClientFire( float value )
{
	local bool bWaitOnAnim;
	local vector shake;

	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				if (!bHandToHand)
					PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
			}
			return false;
		}
	}

	if ( !bLooping ) // Wait on animations when not looping
	{
		bWaitOnAnim = ( IsAnimating() && ((AnimSequence == 'Select') || (AnimSequence == 'Shoot') || (AnimSequence == 'ReloadBegin') || (AnimSequence == 'Reload') || (AnimSequence == 'ReloadEnd') || (AnimSequence == 'Down')));
	}
	else
	{
		bWaitOnAnim = false;
		bLooping = false;
	}

	if ( !bClientReadyToFire || bInProcess || bWaitOnAnim )
	{
		HXPlayerPawn(Owner).bJustFired = false;
		bPointing = false;
		bFiring = false;
		return false;
	}

	if ( !Self.IsA('HXWeaponFlamethrower') )
		ServerForceFire();

	if (bHandToHand)
	{
		SimAmmoAmount = AmmoType.AmmoAmount - 1;

		bClientReadyToFire = false;
		bInProcess = True;
		GotoState('ClientFiring');
		bPointing = True;
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveFiring();
		PlayFiringSound();
	}
	else if ((ClipCount < ReloadCount) || (ReloadCount == 0))
	{
		if ((ReloadCount == 0) || (AmmoType.AmmoAmount > 0))
		{
			SimClipCount = ClipCount + 1;

			if ( AmmoType != None )
				AmmoType.SimUseAmmo();

			bFiring = True;
			bPointing = True;
			bClientReadyToFire = false;
			bInProcess = True;
			GotoState('ClientFiring');
			if ( PlayerPawn(Owner) != None )
			{
				shake.X = 0.0;
				shake.Y = 100.0 * (ShakeTime*0.5);
				shake.Z = 100.0 * -(currentAccuracy * ShakeVert);
				PlayerPawn(Owner).ClientShake( shake );
				PlayerPawn(Owner).PlayFiring();
			}
			// Don't play firing anim for 20mm
			if ( HXAmmo20mm(AmmoType) == None )
				PlaySelectiveFiring();
			PlayFiringSound();

			if ( bInstantHit &&  ( HXAmmo20mm(AmmoType) == None ))
				TraceFire(currentAccuracy);
			else
			{
				if ( !bFlameOn && Self.IsA('HXWeaponFlamethrower'))
				{
					bFlameOn = True;
					StartFlame();
				}
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
			}
		}
		else
		{
			if ( Owner.IsA('HXPlayerPawn') && HXPlayerPawn(Owner).bAutoReload )
			{
				if ( MustReload() && CanReload() )
				{
					bClientReadyToFire = false;
					bInProcess = false;
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();

					ReloadAmmo();
				}
			}
			PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );		// play dry fire sound
		}
	}
	else
	{
		if ( Owner.IsA('HXPlayerPawn') && HXPlayerPawn(Owner).bAutoReload )
		{
			if ( MustReload() && CanReload() )
			{
				bClientReadyToFire = false;
				bInProcess = false;
				if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
					CycleAmmo();
				ReloadAmmo();
			}
		}
		PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );		// play dry fire sound
	}
	return true;
}

//
// from Weapon.uc - modified so we can have the accuracy in TraceFire
//
function Fire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('HXPlayerPawn') && HXPlayerPawn(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;

	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				if (!bHandToHand)
					PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
			}
			GotoState('Idle');
			return;
		}
	}


	if (bHandToHand)
	{
		if (ReloadCount > 0)
			AmmoType.UseAmmo(1);

		if (( Level.NetMode != NM_Standalone ) && !bListenClient )
			bClientReady = false;
		bReadyToFire = false;
		GotoState('NormalFire');
		bPointing=True;
		if ( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveFiring();
		PlayFiringSound();
	}
	// if we are a single-use weapon, then our ReloadCount is 0 and we don't use ammo
	else if ((ClipCount < ReloadCount) || (ReloadCount == 0))
	{
		if ((ReloadCount == 0) || AmmoType.UseAmmo(1))
		{
			if (( Level.NetMode != NM_Standalone ) && !bListenClient )
				bClientReady = false;

			ClipCount++;
			bFiring = True;
			bReadyToFire = false;
			GotoState('NormalFire');
			if ( Level.NetMode==NM_Standalone || bListenClient )
			{
				if ( PlayerPawn(Owner)!=None ) // shake us based on accuracy
					PlayerPawn(Owner).ShakeView(ShakeTime, currentAccuracy * ShakeMag + ShakeMag, currentAccuracy * ShakeVert);
			}
			bPointing=True;

			// SHOT HAPPENS HERE.
			if ( bInstantHit )
				TraceFire(currentAccuracy);
			else
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).PlayFiring();

			// Don't play firing anim for 20mm
			if ( HXAmmo20mm(AmmoType)==None )
				PlaySelectiveFiring();

			PlayFiringSound();
			if ( Owner.bHidden )
				CheckVisibility();
		}
		else
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
	}
	else
		PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
}

function ReadyToFire()
{
	if (!bReadyToFire)
	{
		// BOOGER!
		//if (HXScriptedPawn(Owner) != None)
		//	HXScriptedPawn(Owner).ReadyToFire();
		bReadyToFire = True;
		if ( Level.NetMode != NM_Standalone )
			ReadyClientToFire( True );
	}
}

function PlayPostSelect()
{
	// let's not zero the ammo count anymore - you must always reload
//	ClipCount = 0;		
}

simulated function PlaySelectiveFiring()
{
	local Pawn aPawn;
	local float rnd;
	local Name anim;

	anim = 'Shoot';

	if (bHandToHand)
	{
		rnd = FRand();
		if (rnd < 0.33)
			anim = 'Attack';
		else if (rnd < 0.66)
			anim = 'Attack2';
		else
			anim = 'Attack3';
	}

	if (( Level.NetMode == NM_Standalone ) || ( HXPlayerPawn(Owner) == HXPlayerPawn(GetPlayerPawn())) )
	{
		if (bAutomatic)
			LoopAnim(anim,, 0.1);
		else
			PlayAnim(anim,,0.1);
	}
	else if ( Role == ROLE_Authority )
	{
		for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
		{
			if ( aPawn.IsA('HXPlayerPawn') && ( HXPlayerPawn(Owner) != HXPlayerPawn(aPawn) ) )
			{
				// If they can't see the weapon, don't bother
				if ( HXPlayerPawn(aPawn).FastTrace( HXPlayerPawn(aPawn).Location, Location ))
					HXPlayerPawn(aPawn).ClientPlayAnimation( Self, anim, 0.1, bAutomatic );
			}
		}
	}
}

simulated function PlayFiringSound()
{
	if (bHasSilencer)
		PlaySimSound( Sound'StealthPistolFire', SLOT_None, TransientSoundVolume, 2048 );
	else
	{
		// The sniper rifle sound is heard to it's range in multiplayer
		//if ( ( Level.NetMode != NM_Standalone ) &&  Self.IsA('HXWeaponRifle') )	
			//PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, class'WeaponRifle'.Default.mpMaxRange );
		//else
			PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 2048 );
	}
}

simulated function PlayIdleAnim()
{
	local float rnd;

	if (bZoomed || bNearWall)
		return;

	rnd = FRand();

	if (rnd < 0.1)
		PlayAnim('Idle1',,0.1);
	else if (rnd < 0.2)
		PlayAnim('Idle2',,0.1);
	else if (rnd < 0.3)
		PlayAnim('Idle3',,0.1);
}

//
// SpawnBlood
//

function SpawnBlood(Vector HitLocation, Vector HitNormal)
{
   if ((HXGameInfo(Level.Game) != None) && (!HXGameInfo(Level.Game).bSpawnEffects))
      return;

   spawn(class'BloodSpurt',,,HitLocation+HitNormal);
	spawn(class'BloodDrop',,,HitLocation+HitNormal);
	if (FRand() < 0.5)
		spawn(class'BloodDrop',,,HitLocation+HitNormal);
}

//
// SelectiveSpawnEffects - Continues the simulated chain for the owner, and spawns the effects for other players that can see them
//			No actually spawning occurs on the server itself.
//
simulated function SelectiveSpawnEffects( Vector HitLocation, Vector HitNormal, Actor Other, float Damage)
{
	local HXPlayerPawn fxOwner;
	local Pawn aPawn;

	// The normal path before there was multiplayer
	if ( Level.NetMode == NM_Standalone )
	{
		SpawnEffects(HitLocation, HitNormal, Other, Damage);
		return;
	}

	fxOwner = HXPlayerPawn(Owner);

	if ( Role == ROLE_Authority )
	{
		SpawnEffectSounds(HitLocation, HitNormal, Other, Damage );

		for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
		{
			if ( aPawn.IsA('HXPlayerPawn') && ( HXPlayerPawn(aPawn) != fxOwner ) )
			{
				if ( HXPlayerPawn(aPawn).FastTrace( HXPlayerPawn(aPawn).Location, HitLocation ))
					HXPlayerPawn(aPawn).ClientSpawnHits( bPenetrating, bHandToHand, HitLocation, HitNormal, Other, Damage );
			}
		}
	}
	if ( ( fxOwner != None ) && ( fxOwner == HXPlayerPawn(GetPlayerPawn()) ) )
	{
			fxOwner.ClientSpawnHits( bPenetrating, bHandToHand, HitLocation, HitNormal, Other, Damage );
			SpawnEffectSounds( HitLocation, HitNormal, Other, Damage );
	}
}

//
//	 SpawnEffectSounds - Plays the sound for the effect owner immediately, the server will play them for the other players
//	
simulated function SpawnEffectSounds( Vector HitLocation, Vector HitNormal, Actor Other, float Damage )
{
	if (bHandToHand)
	{
		// if we are hand to hand, play an appropriate sound
		if (Other.IsA('DeusExDecoration'))
			Owner.PlayOwnedSound(Misc3Sound, SLOT_None,,, 1024);
		else if (Other.bIsPawn)
			Owner.PlayOwnedSound(Misc1Sound, SLOT_None,,, 1024);
		else if (Other.IsA('HXBreakableGlass'))
			Owner.PlayOwnedSound(sound'GlassHit1', SLOT_None,,, 1024);
		else if (GetWallMaterial(HitLocation, HitNormal) == 'Glass')
			Owner.PlayOwnedSound(sound'BulletProofHit', SLOT_None,,, 1024);
		else
			Owner.PlayOwnedSound(Misc2Sound, SLOT_None,,, 1024);
	}
}

//
//	SpawnEffects - Spawns the effects like it did in single player
//
function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other, float Damage)
{
	local HXTraceHitSpawner hitspawner;
	local Name damageType;

	damageType = WeaponDamageType();

   if (bPenetrating)
   {
      if (bHandToHand)
      {
         hitspawner = Spawn(class'HXTraceHitHandSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
      else
      {
         hitspawner = Spawn(class'HXTraceHitSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
   }
   else
   {
      if (bHandToHand)
      {
         hitspawner = Spawn(class'HXTraceHitHandNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
      else
      {
         hitspawner = Spawn(class'HXTraceHitNonPenSpawner',Other,,HitLocation,Rotator(HitNormal));
      }
   }
   if (hitSpawner != None)
	{
      hitspawner.HitDamage = Damage;
		hitSpawner.damageType = damageType;
	}
	if (bHandToHand)
	{
		// if we are hand to hand, play an appropriate sound
		if (Other.IsA('DeusExDecoration'))
			Owner.PlaySound(Misc3Sound, SLOT_None,,, 1024);
		else if (Other.bIsPawn)
			Owner.PlaySound(Misc1Sound, SLOT_None,,, 1024);
		else if (Other.IsA('HXBreakableGlass'))
			Owner.PlaySound(sound'GlassHit1', SLOT_None,,, 1024);
		else if (GetWallMaterial(HitLocation, HitNormal) == 'Glass')
			Owner.PlaySound(sound'BulletProofHit', SLOT_None,,, 1024);
		else
			Owner.PlaySound(Misc2Sound, SLOT_None,,, 1024);
	}
}

function name GetWallMaterial(vector HitLocation, vector HitNormal)
{
	local vector EndTrace, StartTrace;
	local actor target;
	local int texFlags;
	local name texName, texGroup;
	local Texture Tex;

	StartTrace = HitLocation + HitNormal*16;		// make sure we start far enough out
	EndTrace = HitLocation - HitNormal;

	//foreach TraceTexture(class'Actor', target, texName, texGroup, texFlags, StartTrace, HitNormal, EndTrace)
	foreach Class'HXActor'.Static.StaticTraceTextures(Self, class'Actor', target, Tex, texName, texGroup, texFlags, StartTrace, HitNormal, EndTrace)
		if ((target == Level) || target.IsA('Mover'))
			break;

	return texGroup;
}

simulated function SimGenerateBullet()
{
	if ( Role < ROLE_Authority )
	{
		if ((ClipCount < ReloadCount) && (ReloadCount != 0))
		{
			if ( AmmoType != None )
				AmmoType.SimUseAmmo();

			if ( bInstantHit )
				TraceFire(currentAccuracy);
			else
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

			SimClipCount++;

			if ( !Self.IsA('HXWeaponFlamethrower') )
				ServerGenerateBullet();
		}
		else
			GotoState('SimFinishFire');
	}
}

function DestroyOnFinish()
{
	bDestroyOnFinish = True;
}

function ServerGotoFinishFire()
{
	GotoState('FinishFire');
}

function ServerDoneReloading()
{
	ClipCount = 0;
}

function ServerGenerateBullet()
{
	if ( ClipCount < ReloadCount )
		GenerateBullet();
}

function GenerateBullet()
{
	if (AmmoType.UseAmmo(1))
	{
		if ( bInstantHit )
			TraceFire(currentAccuracy);
		else
			ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

		ClipCount++;
	}
	else
		GotoState('FinishFire');
}


function PlayLandingSound()
{
	if (LandSound != None)
	{
		if (Velocity.Z <= -200)
		{
			PlaySound(LandSound, SLOT_None, TransientSoundVolume,, 768);
			AISendEvent('LoudNoise', EAITYPE_Audio, TransientSoundVolume, 768);
		}
	}
}


function GetWeaponRanges(out float wMinRange,
                         out float wMaxAccurateRange,
                         out float wMaxRange)
{
	local Class<HXProjectile> dxProjectileClass;

	dxProjectileClass = Class<HXProjectile>(ProjectileClass);
	if (dxProjectileClass != None)
	{
		wMinRange         = dxProjectileClass.Default.blastRadius;
		wMaxAccurateRange = dxProjectileClass.Default.AccurateRange;
		wMaxRange         = dxProjectileClass.Default.MaxRange;
	}
	else
	{
		wMinRange         = 0;
		wMaxAccurateRange = AccurateRange;
		wMaxRange         = MaxRange;
	}
}

//
// computes the start position of a projectile/trace
//
simulated function Vector ComputeProjectileStart(Vector X, Vector Y, Vector Z)
{
	local Vector Start;

	// if we are instant-hit, non-projectile, then don't offset our starting point by PlayerViewOffset
	if (bInstantHit)
		Start = Owner.Location + Pawn(Owner).BaseEyeHeight * vect(0,0,1);// - Vector(Pawn(Owner).ViewRotation)*(0.9*Pawn(Owner).CollisionRadius);
	else
		Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;

	return Start;
}

//
// Modified to work better with scripted pawns
//
simulated function vector CalcDrawOffset()
{
	local vector		DrawOffset, WeaponBob;
	local HXScriptedPawn	SPOwner;
	local Pawn			PawnOwner;

	SPOwner = HXScriptedPawn(Owner);
	if (SPOwner != None)
	{
		DrawOffset = ((0.9/SPOwner.FOVAngle * PlayerViewOffset) >> SPOwner.ViewRotation);
		DrawOffset += (SPOwner.BaseEyeHeight * vect(0,0,1));
	}
	else
	{
		// copied from Engine.Inventory to not be FOVAngle dependent
		PawnOwner = Pawn(Owner);
		DrawOffset = ((0.9/PawnOwner.Default.FOVAngle * PlayerViewOffset) >> PawnOwner.ViewRotation);

		DrawOffset += (PawnOwner.EyeHeight * vect(0,0,1));
		WeaponBob = BobDamping * PawnOwner.WalkBob;
		WeaponBob.Z = (0.45 + 0.55 * BobDamping) * PawnOwner.WalkBob.Z;
		DrawOffset += WeaponBob;
	}

	return DrawOffset;
}

function GetAIVolume(out float volume, out float radius)
{
	volume = 0;
	radius = 0;

	if (!bHasSilencer && !bHandToHand)
	{
		volume = NoiseLevel*Pawn(Owner).SoundDampening;
		radius = volume * 800.0;
	}
}


//
// copied from Weapon.uc
//
simulated function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X, Y, Z;
	local HXProjectile proj;
	local float mult;
	local float volume, radius;
	local int i, numProj;
	local Pawn aPawn;

	// AugCombat increases our speed (distance) if hand to hand
	mult = 1.0;
	if (bHandToHand && (HXPlayerPawn(Owner) != None))
	{
		mult = HXPlayerPawn(Owner).AugmentationSystem.GetAugLevelValue(class'HXAugCombat');
		if (mult == -1.0)
			mult = 1.0;
		ProjSpeed *= mult;
	}

	// skill also affects our damage
	// GetWeaponSkill returns 0.0 to -0.7 (max skill/aug)
	mult += -2.0 * GetWeaponSkill();

	// make noise if we are not silenced
	if (!bHasSilencer && !bHandToHand)
	{
		GetAIVolume(volume, radius);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	// should we shoot multiple projectiles in a spread?
	if (AreaOfEffect == AOE_Cone)
		numProj = 3;
	else
		numProj = 1;

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	Start = ComputeProjectileStart(X, Y, Z);

	for (i=0; i<numProj; i++)
	{
      // If we have multiple slugs, then lower our accuracy a bit after the first slug so the slugs DON'T all go to the same place
//      if ((i > 0) && (Level.NetMode != NM_Standalone))
//         if (currentAccuracy < MinProjSpreadAcc)
//            currentAccuracy = MinProjSpreadAcc;
         
		AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, Start, AimError, True, bWarn);
		AdjustedAim.Yaw += currentAccuracy * (Rand(1024) - 512);
		AdjustedAim.Pitch += currentAccuracy * (Rand(1024) - 512);


		if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('HXPlayerPawn') && HXPlayerPawn(Owner).PlayerIsListenClient()) )
		{
			proj = HXProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
			if (proj != None)
			{
				// AugCombat increases our damage as well
				proj.Damage *= mult;

				// send the targetting information to the projectile
				if (bCanTrack && (LockTarget != None) && (LockMode == LOCK_Locked))
				{
					proj.Target = LockTarget;
					proj.bTracking = True;
				}
			}
		}
		else
		{
			if (( Role == ROLE_Authority ) || (HXPlayerPawn(Owner) == HXPlayerPawn(GetPlayerPawn())) )
			{
				// Do it the old fashioned way if it can track, or if we are a projectile that we could pick up again
				if ( bCanTrack || Self.IsA('HXWeaponShuriken') || Self.IsA('HXWeaponMiniCrossbow') || Self.IsA('HXWeaponLAM') || Self.IsA('HXWeaponEMPGrenade') || Self.IsA('HXWeaponGasGrenade'))
				{
					if ( Role == ROLE_Authority )
					{
						proj = HXProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
						if (proj != None)
						{
							// AugCombat increases our damage as well
								proj.Damage *= mult;
							// send the targetting information to the projectile
							if (bCanTrack && (LockTarget != None) && (LockMode == LOCK_Locked))
							{
								proj.Target = LockTarget;
								proj.bTracking = True;
							}
						}
					}
				}
				else
				{
					proj = HXProjectile(Spawn(ProjClass, Owner,, Start, AdjustedAim));
					if (proj != None)
					{
						proj.RemoteRole = ROLE_None;
						// AugCombat increases our damage as well
						if ( Role == ROLE_Authority )
							proj.Damage *= mult;
						else
							proj.Damage = 0;
					}
					if ( Role == ROLE_Authority )
					{
						for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
						{
							if ( aPawn.IsA('HXPlayerPawn') && ( HXPlayerPawn(aPawn) != HXPlayerPawn(Owner) ))
								HXPlayerPawn(aPawn).ClientSpawnProjectile( ProjClass, Owner, Start, AdjustedAim );
						}
					}
				}
			}
		}

	}
	return proj;
}

//
// copied from Weapon.uc so we can add range information
//
simulated function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local actor Other;
	local float dist, alpha, degrade;
	local int i, numSlugs;
	local float volume, radius;

	// make noise if we are not silenced
	if (!bHasSilencer && !bHandToHand)
	{
		GetAIVolume(volume, radius);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, false, false);

	// check to see if we are a shotgun-type weapon
	if (AreaOfEffect == AOE_Cone)
		numSlugs = 5;
	else
		numSlugs = 1;

	// if there is a scope, but the player isn't using it, decrease the accuracy
	// so there is an advantage to using the scope
	if (bHasScope && !bZoomed)
		Accuracy += 0.2;
	// if the laser sight is on, make this shot dead on
	// also, if the scope is on, zero the accuracy so the shake makes the shot inaccurate
	else if (bLasing || bZoomed)
		Accuracy = 0.0;


	for (i=0; i<numSlugs; i++)
	{
      // If we have multiple slugs, then lower our accuracy a bit after the first slug so the slugs DON'T all go to the same place
      //if ((i > 0) && (Level.NetMode != NM_Standalone) && !(bHandToHand))
         //if (Accuracy < MinSpreadAcc)
            //Accuracy = MinSpreadAcc;

      // Let handtohand weapons have a better swing
      //if ((bHandToHand) && (NumSlugs > 1) && (Level.NetMode != NM_Standalone))
      //{
         //StartTrace = ComputeProjectileStart(X,Y,Z);
         //StartTrace = StartTrace + (numSlugs/2 - i) * SwingOffset;
      //}

      EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
      EndTrace += (FMax(1024.0, MaxRange) * vector(AdjustedAim));
      
      Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

		// randomly draw a tracer for relevant ammo types
		// don't draw tracers if we're zoomed in with a scope - looks stupid
      // DEUS_EX AMSD In multiplayer, draw tracers all the time.
		if ( ((Level.NetMode == NM_Standalone) && (!bZoomed && (numSlugs == 1) && (FRand() < 0.5))) ||
           ((Level.NetMode != NM_Standalone) && (Role == ROLE_Authority) && (numSlugs == 1)) )
		{
			if ((AmmoName == Class'HXAmmo10mm') || (AmmoName == Class'HXAmmo3006') ||
				(AmmoName == Class'HXAmmo762mm'))
			{
				if (VSize(HitLocation - StartTrace) > 250)
				{
					rot = Rotator(EndTrace - StartTrace);
         //if ((Level.NetMode != NM_Standalone) && (Self.IsA('HXWeaponRifle')))
            //Spawn(class'HXSniperTracer',,, StartTrace + 96 * Vector(rot), rot);
         //else
            //Spawn(class'HXTracer',,, StartTrace + 96 * Vector(rot), rot);
						Spawn(class'HXNetTemporaryTracer',,, StartTrace + 96 * Vector(rot), rot);
				}
			}
		}

		// check our range
		dist = Abs(VSize(HitLocation - Owner.Location));

		if (dist <= AccurateRange)		// we hit just fine
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		else if (dist <= MaxRange)
		{
			// simulate gravity by lowering the bullet's hit point
			// based on the owner's distance from the ground
			alpha = (dist - AccurateRange) / (MaxRange - AccurateRange);
			degrade = 0.5 * Square(alpha);
			HitLocation.Z += degrade * (Owner.Location.Z - Owner.CollisionHeight);
			ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		}
	}

	// otherwise we don't hit the target at all
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local float        mult;
	local name         damageType;
	local HXPlayerPawn dxPlayer;

	if (Other != None)
	{
		// AugCombat increases our damage if hand to hand
		mult = 1.0;
		if (bHandToHand && (HXPlayerPawn(Owner) != None))
		{
			mult = HXPlayerPawn(Owner).AugmentationSystem.GetAugLevelValue(class'HXAugCombat');
			if (mult == -1.0)
				mult = 1.0;
		}

		// skill also affects our damage
		// GetWeaponSkill returns 0.0 to -0.7 (max skill/aug)
		mult += -2.0 * GetWeaponSkill();

		// Determine damage type
		damageType = WeaponDamageType();

		if (Other != None)
		{
			if (Other.bOwned)
			{
				dxPlayer = HXPlayerPawn(Owner);
				if (dxPlayer != None)
					dxPlayer.AISendEvent('Futz', EAITYPE_Visual);
			}
		}
		if ((Other == Level) || (Other.IsA('Mover')))
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);

			SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);
		}
		else if ((Other != self) && (Other != Owner))
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);
			if (bHandToHand)
				SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);

			if (bPenetrating && Other.bIsPawn && !(Other.IsA('HXScriptedPawn') && HXScriptedPawn(Other).bIsRobot) )
				SpawnBlood(HitLocation, HitNormal);
		}
	}
   /*if (HXGameInfo(Level.Game) != None)
   {
      if (HXPlayerPawn(Other) != None)
         HXGameInfo(Level.Game).TrackWeapon(self,HitDamage * mult);
      else
         HXGameInfo(Level.Game).TrackWeapon(self,0);
   }*/
}

simulated function IdleFunction()
{
	PlayIdleAnim();
	bInProcess = false;
	if ( bFlameOn )
	{
		StopFlame();
		bFlameOn = false;
	}
}

simulated function SimFinish()
{
	ServerGotoFinishFire();

	bInProcess = false;
	bFiring = false;

	if ( bFlameOn )
	{
		StopFlame();
		bFlameOn = false;
	}

	if (bHasMuzzleFlash)
		EraseMuzzleFlashTexture();

	if ( Owner.IsA('HXPlayerPawn') && HXPlayerPawn(Owner).bAutoReload )
	{
		if ( (SimClipCount >= ReloadCount) && CanReload() )
		{
			SimClipCount = 0;
			bClientReadyToFire = false;
			bInProcess = false;
			if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
				CycleAmmo();
			ReloadAmmo();
		}
	}

	if (Pawn(Owner) == None)
	{
		GotoState('SimIdle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			ClientReFire(0);
		else
			GotoState('SimIdle');
		return;
	}
	if ( Pawn(Owner).bFire != 0 )
		ClientReFire(0);
	else
		GotoState('SimIdle');
}

// Finish a firing sequence (ripped off and modified from Engine\Weapon.uc)
function Finish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
	
	if (bHasMuzzleFlash)
		EraseMuzzleFlashTexture();

	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if (( Level.NetMode != NM_Standalone ) && IsInState('Active'))
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ( ((AmmoType==None) || (AmmoType.AmmoAmount<=0)) && ReloadCount!=0 )
		{
			Pawn(Owner).StopFiring();
			Pawn(Owner).SwitchToBestWeapon();
		}
		else if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else if ( (Pawn(Owner).bAltFire != 0) && (FRand() < AltRefireRate) )
			Global.AltFire(0);	
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('HXPlayerPawn') && !HXPlayerPawn(Owner).PlayerIsListenClient()))
	{
		GotoState('Idle');
		return;
	}

	if ( ((AmmoType==None) || (AmmoType.AmmoAmount<=0)) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

// ----------------------------------------------------------------------------
// InfoTitle() and InfoText()
//
// Text only title and description intended for the info window.
// ----------------------------------------------------------------------------

simulated function string InfoTitle()
{
	return ItemName;
}

simulated function string InfoText()
{
	return Description;
}

// ----------------------------------------------------------------------------
// InventoryCapsString()
//
// Declared in Inventory. Used as a wrapper for retrieving the text for the
// Info window.
// ----------------------------------------------------------------------------

simulated function string InventoryCapsString( Name Property, Pawn Other, Actor Test )
{
	switch ( Property )
	{
		case 'InfoTitle':
			return InfoTitle();
			break;

		case 'InfoText':
			return InfoText();
			break;

		default:
			return "";
			break;
	}
}

// -----------------------------------------------------------------------------
// UpdateInfo()
// -----------------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local HXPersonaInventoryInfoWindow winInfo;
	local string str;
	local int i, dmg;
	local float mod;
	local bool bHasAmmo;
	local bool bAmmoAvailable;
	local class<DeusExAmmo> ammoClass;
	local Pawn P;
	local Ammo weaponAmmo;
	local int  ammoAmount;

	P = Pawn(Owner);
	if (P == None)
		return false;

	winInfo = HXPersonaInventoryInfoWindow(winObject);
	if (winInfo == None)
		return false;

	winInfo.SetTitle(itemName);
	winInfo.SetText(msgInfoWeaponStats);
	winInfo.AddLine();

	// Create the ammo buttons.  Start with the AmmoNames[] array,
	// which is used for weapons that can use more than one 
	// type of ammo.

	if (AmmoNames[0] != None)
	{
		for (i=0; i<ArrayCount(AmmoNames); i++)
		{
			if (AmmoNames[i] != None) 
			{
				// Check to make sure the player has this ammo type
				// *and* that the ammo isn't empty
				weaponAmmo = Ammo(P.FindInventoryType(AmmoNames[i]));

				if (weaponAmmo != None)
				{
					ammoAmount = weaponAmmo.AmmoAmount;
					bHasAmmo = (weaponAmmo.AmmoAmount > 0);
				}
				else
				{
					ammoAmount = 0;
					bHasAmmo = false;
				}

				winInfo.AddAmmo(AmmoNames[i], bHasAmmo, ammoAmount);
				bAmmoAvailable = True;

				if (AmmoNames[i] == AmmoName)
				{
					winInfo.SetLoaded(AmmoName);
					ammoClass = class<DeusExAmmo>(AmmoName);
				}
			}
		}
	}
	else
	{
		// Now peer at the AmmoName variable, but only if the AmmoNames[] 
		// array is empty
		if ((AmmoName != class'HXAmmoNone') && (!bHandToHand) && (ReloadCount != 0))
		{	
			weaponAmmo = Ammo(P.FindInventoryType(AmmoName));

			if (weaponAmmo != None)
			{
				ammoAmount = weaponAmmo.AmmoAmount;
				bHasAmmo = (weaponAmmo.AmmoAmount > 0);
			}
			else
			{
				ammoAmount = 0;
				bHasAmmo = false;
			}

			winInfo.AddAmmo(AmmoName, bHasAmmo, ammoAmount);
			winInfo.SetLoaded(AmmoName);
			ammoClass = class<DeusExAmmo>(AmmoName);
			bAmmoAvailable = True;
		}
	}

	// Only draw another line if we actually displayed ammo.
	if (bAmmoAvailable)
		winInfo.AddLine();	

	// Ammo loaded
	if ((AmmoName != class'HXAmmoNone') && (!bHandToHand) && (ReloadCount != 0))
		winInfo.AddAmmoLoadedItem(msgInfoAmmoLoaded, AmmoType.itemName);

	// ammo info
	if ((AmmoName == class'HXAmmoNone') || bHandToHand || (ReloadCount == 0))
		str = msgInfoNA;
	else
		str = AmmoName.Default.ItemName;
	for (i=0; i<ArrayCount(AmmoNames); i++)
		if ((AmmoNames[i] != None) && (AmmoNames[i] != AmmoName))
			str = str $ "|n" $ AmmoNames[i].Default.ItemName;

	winInfo.AddAmmoTypesItem(msgInfoAmmo, str);

	// base damage
	if (AreaOfEffect == AOE_Cone)
	{
		if (bInstantHit)
		{
			//if (Level.NetMode != NM_Standalone)
				//dmg = Default.mpHitDamage * 5;
			//else
				dmg = Default.HitDamage * 5;
		}
		else
		{
			//if (Level.NetMode != NM_Standalone)
				//dmg = Default.mpHitDamage * 3;
			//else
				dmg = Default.HitDamage * 3;
		}
	}
	else
	{
		//if (Level.NetMode != NM_Standalone)
			//dmg = Default.mpHitDamage;
		//else
			dmg = Default.HitDamage;
	}

	str = String(dmg);
	mod = 1.0 - GetWeaponSkill();
	if (mod != 1.0)
	{
		str = str @ BuildPercentString(mod - 1.0);
		str = str @ "=" @ FormatFloatString(dmg * mod, 1.0);
	}

	winInfo.AddInfoItem(msgInfoDamage, str, (mod != 1.0));

	// clip size
	if ((Default.ReloadCount == 0) || bHandToHand)
		str = msgInfoNA;
	else
	{
		//if ( Level.NetMode != NM_Standalone )
			//str = Default.mpReloadCount @ msgInfoRounds;
		//else
			str = Default.ReloadCount @ msgInfoRounds;
	}

	if (HasClipMod())
	{
		str = str @ BuildPercentString(ModReloadCount);
		str = str @ "=" @ ReloadCount @ msgInfoRounds;
	}

	winInfo.AddInfoItem(msgInfoClip, str, HasClipMod());

	// rate of fire
	if ((Default.ReloadCount == 0) || bHandToHand)
	{
		str = msgInfoNA;
	}
	else
	{
		if (bAutomatic)
			str = msgInfoAuto;
		else
			str = msgInfoSingle;

		str = str $ "," @ FormatFloatString(1.0/Default.ShotTime, 0.1) @ msgInfoRoundsPerSec;
	}
	winInfo.AddInfoItem(msgInfoROF, str);

	// reload time
	if ((Default.ReloadCount == 0) || bHandToHand)
		str = msgInfoNA;
	else
	{
		//if (Level.NetMode != NM_Standalone )
			//str = FormatFloatString(Default.mpReloadTime, 0.1) @ msgTimeUnit;
		//else
			str = FormatFloatString(Default.ReloadTime, 0.1) @ msgTimeUnit;
	}

	if (HasReloadMod())
	{
		str = str @ BuildPercentString(ModReloadTime);
		str = str @ "=" @ FormatFloatString(ReloadTime, 0.1) @ msgTimeUnit;
	}

	winInfo.AddInfoItem(msgInfoReload, str, HasReloadMod());

	// recoil
	str = FormatFloatString(Default.recoilStrength, 0.01);
	if (HasRecoilMod())
	{
		str = str @ BuildPercentString(ModRecoilStrength);
		str = str @ "=" @ FormatFloatString(recoilStrength, 0.01);
	}

	winInfo.AddInfoItem(msgInfoRecoil, str, HasRecoilMod());

	// base accuracy (2.0 = 0%, 0.0 = 100%)
	//if ( Level.NetMode != NM_Standalone )
	//{
		//str = Int((2.0 - Default.mpBaseAccuracy)*50.0) $ "%";
		//mod = (Default.mpBaseAccuracy - (BaseAccuracy + GetWeaponSkill())) * 0.5;
		//if (mod != 0.0)
		//{
			//str = str @ BuildPercentString(mod);
			//str = str @ "=" @ Min(100, Int(100.0*mod+(2.0 - Default.mpBaseAccuracy)*50.0)) $ "%";
		//}
	//}
	//else
	//{
		str = Int((2.0 - Default.BaseAccuracy)*50.0) $ "%";
		mod = (Default.BaseAccuracy - (BaseAccuracy + GetWeaponSkill())) * 0.5;
		if (mod != 0.0)
		{
			str = str @ BuildPercentString(mod);
			str = str @ "=" @ Min(100, Int(100.0*mod+(2.0 - Default.BaseAccuracy)*50.0)) $ "%";
		}
	//}
	winInfo.AddInfoItem(msgInfoAccuracy, str, (mod != 0.0));

	// accurate range
	if (bHandToHand)
		str = msgInfoNA;
	else
	{
		//if ( Level.NetMode != NM_Standalone )
			//str = FormatFloatString(Default.mpAccurateRange/16.0, 1.0) @ msgRangeUnit;
		//else
			str = FormatFloatString(Default.AccurateRange/16.0, 1.0) @ msgRangeUnit;
	}

	if (HasRangeMod())
	{
		str = str @ BuildPercentString(ModAccurateRange);
		str = str @ "=" @ FormatFloatString(AccurateRange/16.0, 1.0) @ msgRangeUnit;
	}
	winInfo.AddInfoItem(msgInfoAccRange, str, HasRangeMod());

	// max range
	if (bHandToHand)
		str = msgInfoNA;
	else
	{
		//if ( Level.NetMode != NM_Standalone )
			//str = FormatFloatString(Default.mpMaxRange/16.0, 1.0) @ msgRangeUnit;
		//else
			str = FormatFloatString(Default.MaxRange/16.0, 1.0) @ msgRangeUnit;
	}
	winInfo.AddInfoItem(msgInfoMaxRange, str);

	// mass
	winInfo.AddInfoItem(msgInfoMass, FormatFloatString(Default.Mass, 1.0) @ msgMassUnit);

	// laser mod
	if (bCanHaveLaser)
	{
		if (bHasLaser)
			str = msgInfoYes;
		else
			str = msgInfoNo;
	}
	else
	{
		str = msgInfoNA;
	}
	winInfo.AddInfoItem(msgInfoLaser, str, bCanHaveLaser && bHasLaser && (Default.bHasLaser != bHasLaser));

	// scope mod
	if (bCanHaveScope)
	{
		if (bHasScope)
			str = msgInfoYes;
		else
			str = msgInfoNo;
	}
	else
	{
		str = msgInfoNA;
	}
	winInfo.AddInfoItem(msgInfoScope, str, bCanHaveScope && bHasScope && (Default.bHasScope != bHasScope));

	// silencer mod
	if (bCanHaveSilencer)
	{
		if (bHasSilencer)
			str = msgInfoYes;
		else
			str = msgInfoNo;
	}
	else
	{
		str = msgInfoNA;
	}
	winInfo.AddInfoItem(msgInfoSilencer, str, bCanHaveSilencer && bHasSilencer && (Default.bHasSilencer != bHasSilencer));

	// Governing Skill
	winInfo.AddInfoItem(msgInfoSkill, GoverningSkill.default.SkillName);

	winInfo.AddLine();
	winInfo.SetText(Description);

	// If this weapon has ammo info, display it here
	if (ammoClass != None)
	{
		winInfo.AddLine();
		winInfo.AddAmmoDescription(ammoClass.Default.ItemName $ "|n" $ ammoClass.Default.description);
	}

	return True;
}

// -----------------------------------------------------------------------------
// UpdateAmmoInfo()
// -----------------------------------------------------------------------------

simulated function UpdateAmmoInfo(Object winObject, Class<DeusExAmmo> ammoClass)
{
	local HXPersonaInventoryInfoWindow winInfo;
	local string str;
	local int i;

	winInfo = HXPersonaInventoryInfoWindow(winObject);
	if (winInfo == None)
		return;

	// Ammo loaded
	if ((AmmoName != class'HXAmmoNone') && (!bHandToHand) && (ReloadCount != 0))
		winInfo.UpdateAmmoLoaded(AmmoType.itemName);

	// ammo info
	if ((AmmoName == class'HXAmmoNone') || bHandToHand || (ReloadCount == 0))
		str = msgInfoNA;
	else
		str = AmmoName.Default.ItemName;
	for (i=0; i<ArrayCount(AmmoNames); i++)
		if ((AmmoNames[i] != None) && (AmmoNames[i] != AmmoName))
			str = str $ "|n" $ AmmoNames[i].Default.ItemName;

	winInfo.UpdateAmmoTypes(str);

	// If this weapon has ammo info, display it here
	if (ammoClass != None)
		winInfo.UpdateAmmoDescription(ammoClass.Default.ItemName $ "|n" $ ammoClass.Default.description);
}

// -----------------------------------------------------------------------------
// BuildPercentString()
// -----------------------------------------------------------------------------
/*
simulated final function String BuildPercentString(Float value)
{
	local string str;

	str = String(Int(Abs(value * 100.0)));
	if (value < 0.0)
		str = "-" $ str;
	else
		str = "+" $ str;

	return ("(" $ str $ "%)");
}
*/
// -----------------------------------------------------------------------------
// FormatFloatString()
// -----------------------------------------------------------------------------

simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

// -----------------------------------------------------------------------------
// CR()
// -----------------------------------------------------------------------------

simulated function String CR()
{
	return Chr(13) $ Chr(10);
}

// -----------------------------------------------------------------------------
// HasReloadMod()
// -----------------------------------------------------------------------------

simulated function bool HasReloadMod()
{
	return (ModReloadTime != 0.0);
}

// -----------------------------------------------------------------------------
// HasMaxReloadMod()
// -----------------------------------------------------------------------------

simulated function bool HasMaxReloadMod()
{
	return (ModReloadTime == -0.5);
}

// -----------------------------------------------------------------------------
// HasClipMod()
// -----------------------------------------------------------------------------

simulated function bool HasClipMod()
{
	return (ModReloadCount != 0.0);
}

// -----------------------------------------------------------------------------
// HasMaxClipMod()
// -----------------------------------------------------------------------------

simulated function bool HasMaxClipMod()
{
	return (ModReloadCount == 0.5);
}

// -----------------------------------------------------------------------------
// HasRangeMod()
// -----------------------------------------------------------------------------

simulated function bool HasRangeMod()
{
	return (ModAccurateRange != 0.0);
}

// -----------------------------------------------------------------------------
// HasMaxRangeMod()
// -----------------------------------------------------------------------------

simulated function bool HasMaxRangeMod()
{
	return (ModAccurateRange == 0.5);
}

// -----------------------------------------------------------------------------
// HasAccuracyMod()
// -----------------------------------------------------------------------------

simulated function bool HasAccuracyMod()
{
	return (ModBaseAccuracy != 0.0);
}

// -----------------------------------------------------------------------------
// HasMaxAccuracyMod()
// -----------------------------------------------------------------------------

simulated function bool HasMaxAccuracyMod()
{
	return (ModBaseAccuracy == 0.5);
}

// -----------------------------------------------------------------------------
// HasRecoilMod()
// -----------------------------------------------------------------------------

simulated function bool HasRecoilMod()
{
	return (ModRecoilStrength != 0.0);
}

// -----------------------------------------------------------------------------
// HasMaxRecoilMod()
// -----------------------------------------------------------------------------

simulated function bool HasMaxRecoilMod()
{
	return (ModRecoilStrength == -0.5);
}

// -----------------------------------------------------------------------------
// ClientDownWeapon()
// -----------------------------------------------------------------------------

simulated function ClientDownWeapon()
{
	bWasInFiring = IsInState('ClientFiring') || IsInState('SimFinishFire');
	bClientReadyToFire = false;
	GotoState('SimDownWeapon');
}

simulated function ClientActive()
{
	bWasInFiring = IsInState('ClientFiring') || IsInState('SimFinishFire');
	bClientReadyToFire = false;
	GotoState('SimActive');
}

simulated function ClientReload()
{
	bWasInFiring = IsInState('ClientFiring') || IsInState('SimFinishFire');
	bClientReadyToFire = false;
	GotoState('SimReload');
}

//
// weapon states
//

state NormalFire
{
	function AnimEnd()
	{
		if (bAutomatic)
		{
			if ((Pawn(Owner).bFire != 0) && (AmmoType.AmmoAmount > 0))
			{
				if (PlayerPawn(Owner) != None)
					Global.Fire(0);
				else 
					GotoState('FinishFire');
			}
			else 
				GotoState('FinishFire');
		}
		else
		{
			// if we are a thrown weapon and we run out of ammo, destroy the weapon
			if (bHandToHand && (ReloadCount > 0) && (AmmoType.AmmoAmount <= 0))
				Destroy();
		}
	}
	function float GetShotTime()
	{
		local float mult, sTime;

		if (HXScriptedPawn(Owner) != None)
			return ShotTime * (HXScriptedPawn(Owner).BaseAccuracy*2.0+1.0);
		else
		{
			// AugCombat decreases shot time
			mult = 1.0;
			if (bHandToHand && HXPlayerPawn(Owner) != None)
			{
				mult = 1.0 / HXPlayerPawn(Owner).AugmentationSystem.GetAugLevelValue(class'HXAugCombat');
				if (mult == -1.0)
					mult = 1.0;
			}
			sTime = ShotTime * mult;
			return (sTime);
		}
	}

Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = false;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('HXPlayerPawn'))
			{
				bFiring = false;

				// should we autoreload?
				if (HXPlayerPawn(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('HXScriptedPawn'))
			{
				bFiring = false;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	// This seems to have caused the "bullet hail" bug, which doesn't seem to  happen on listen server. Idle state will immediatly raiss bReadyToFire allowing the Pawn to shoot again.
	//if ( bAutomatic && ( Level.NetMode==NM_DedicatedServer || (Level.NetMode==NM_ListenServer && Owner.IsA('HXPlayerPawn') && !HXPlayerPawn(Owner).PlayerIsListenClient())))
	if ( bAutomatic && Owner.IsA('HXPlayerPawn') && !HXPlayerPawn(Owner).PlayerIsListenClient() )
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = false;
	FinishAnim();

	// if ReloadCount is 0 and we're not hand to hand, then this is a
	// single-use weapon so destroy it after firing once
	if ((ReloadCount == 0) && !bHandToHand)
	{
		if (HXPlayerPawn(Owner) != None)
			HXPlayerPawn(Owner).RemoveItemFromSlot(Self);   // remove it from the inventory grid
		Destroy();
	}
	ReadyToFire();
Done:
	bFiring = false;
	Finish();
}

state FinishFire
{
Begin:
	bFiring = false;
	if ( bDestroyOnFinish )
		Destroy();
	else
		Finish();
}


//=============================================================================
// state Pickup.
//
// This inventory item is sitting on the ground.
//=============================================================================

auto state Pickup
{
	function BeginState()
	{
		// HX_NOTE: strange
		// alert NPCs that I'm putting away my gun
		AIEndEvent('WeaponDrawn', EAITYPE_Visual);

		BecomePickup();
		bCollideWorld = true;

		//if ( Level.bStartup )
			//bAlwaysRelevant = true; // KILLS REPLICATION FOR ANYTHING BUT bHidden after bNetInitial. --han

		SpecialBeginStatePickup();
	}

	function EndState()
	{
		bCollideWorld = false;
		bSleepTouch = false;
	}

	singular function ZoneChange( ZoneInfo NewZone )
	{
		local float splashsize;
		local actor splash;

		if( NewZone.bWaterZone && !Region.Zone.bWaterZone ) 
		{
			splashSize = 0.000025 * Mass * (250 - 0.5 * Velocity.Z);
			if ( NewZone.EntrySound != None )
				PlaySound(NewZone.EntrySound, SLOT_Interact, splashSize);
			if ( NewZone.EntryActor != None )
			{
				splash = Spawn(NewZone.EntryActor); 
				if ( splash != None )
					splash.DrawScale = 2 * splashSize;
			}
		}
	}

	// Validate touch, and if valid trigger event.
	function bool ValidTouch( actor Other )
	{
		local Actor A;

		if( Other.bIsPawn && Pawn(Other).bIsPlayer && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					// Changed to using Self instead of Other, to be able to use this items Tag in triggered MissionScripts.
					//A.Trigger( Other, Other.Instigator );
					A.Trigger( Self, Pawn(Other) );

			return true;
		}
		return false;
	}
		
	// When touched by an actor.
	// Now, when frobbed by an actor - DEUS_EX CNN
	function Frob(Actor Other, Inventory frobWith)
	{
		// If touched by a player pawn, let him pick this up.
		if( ValidTouch(Other) )
		{
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
			SpawnCopy(Pawn(Other));
			if ( PickupMessageClass == None )
				Pawn(Other).ClientMessage(PickupMessage @ itemArticle @ itemName, 'Pickup');
			else
				Pawn(Other).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
			PlaySound (PickupSound);		
			if ( Level.Game.Difficulty > 1 )
				Other.MakeNoise(0.1 * Level.Game.Difficulty);
			if ( Pawn(Other).MoveTarget == self )
				Pawn(Other).MoveTimer = -1.0;		
		}
		else if ( bTossedOut && (Other.Class == Class)
				&& Inventory(Other).bTossedOut )
				Destroy();
	}

	// Landed on ground.
	function Landed(Vector HitNormal)
	{
		local rotator newRot;
		newRot = Rotation;
		newRot.pitch = 0;
		SetRotation(newRot);
		PlayLandingSound();  // DEUS_EX STM - added
	}

	// Make sure no pawn already touching (while touch was disabled in sleep).
	function CheckTouching()
	{
		local int i;

		bSleepTouch = false;
		for ( i=0; i<4; i++ )
			if ( (Touching[i] != None) && Touching[i].IsA('Pawn') )
				Touch(Touching[i]);
	}

Begin:
	BecomePickup();
	if ( bRotatingPickup && (Physics != PHYS_Falling) )
		SetPhysics(PHYS_Rotating);

Dropped:
	if( bAmbientGlow )
		AmbientGlow=255;
	if( bSleepTouch )
		CheckTouching();
}

state Reload
{
ignores Fire, AltFire;

	function float GetReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (HXScriptedPawn(Owner) != None)
		{
			val = ReloadTime * (HXScriptedPawn(Owner).BaseAccuracy*2+1);
		}
		else if (HXPlayerPawn(Owner) != None)
		{
			// check for skill use if we are the player
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
		}

		return val;
	}

	function NotifyOwner(bool bStart)
	{
		local HXPlayerPawn player;
		local HXScriptedPawn pawn;

		//Log( "NotifyOwner( " $ bStart $ " ), Owner = " $ Owner, 'Inventory' );

		player = HXPlayerPawn(Owner);
		pawn   = HXScriptedPawn(Owner);

		if (player != None)
		{
			if (bStart)
				player.Reloading(self, GetReloadTime()+(1.0/AnimRate));
			else
			{
				player.DoneReloading(self);
			}
		}
		else if (pawn != None)
		{
			if (bStart)
				pawn.Reloading(self, GetReloadTime()+(1.0/AnimRate));
			else
				pawn.DoneReloading(self);
		}
	}

	function EndState()
	{
		// HX_NOTE: e.g. Pauls Reloading gets disrupted by running to player or by sth different which prevents him from fire again
		// this makes things somewhat better, but doesn't really fix them
		if ( Owner.isA('HXScriptedPawn') )
		{
			// actually not reloaded, but resets reloadtimer
			HXScriptedPawn(Owner).DoneReloading( self );
		}
	}

Begin:
	FinishAnim();

	//Log( "state Reload -> Begin:" );

	// only reload if we have ammo left
	if (AmmoType.AmmoAmount > 0)
	{
		if (( Level.NetMode == NM_DedicatedServer && !Owner.IsA('HXScriptedPawn') ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('HXPlayerPawn') && !HXPlayerPawn(Owner).PlayerIsListenClient()))
		{
			ClientReload();
			Sleep(GetReloadTime());
			ReadyClientToFire( True );
		}
		else
		{
			bWasZoomed = bZoomed;
			if (bWasZoomed)
				ScopeOff();

			Owner.PlaySound(CockingSound, SLOT_None,,, 1024);		// CockingSound is reloadbegin
			PlayAnim('ReloadBegin');
			NotifyOwner(True);
			FinishAnim();
			LoopAnim('Reload');
			Sleep(GetReloadTime());
			Owner.PlaySound(AltFireSound, SLOT_None,,, 1024);		// AltFireSound is reloadend
			PlayAnim('ReloadEnd');
			FinishAnim();
			NotifyOwner(false);

			if (bWasZoomed)
				ScopeOn();

			ClipCount = 0;
		}
	}
	GotoState('Idle');
}

simulated state ClientFiring
{
	simulated function AnimEnd()
	{
		bInProcess = false;

		if (bAutomatic)
		{
			if ((Pawn(Owner).bFire != 0) && (AmmoType.AmmoAmount > 0))
			{
				if (PlayerPawn(Owner) != None)
					ClientReFire(0);
				else
					GotoState('SimFinishFire');
			}
			else 
				GotoState('SimFinishFire');
		}
	}
	simulated function float GetSimShotTime()
	{
		local float mult, sTime;

		if (HXScriptedPawn(Owner) != None)
			return ShotTime * (HXScriptedPawn(Owner).BaseAccuracy*2+1);
		else
		{
			// AugCombat decreases shot time
			mult = 1.0;
			if (bHandToHand && HXPlayerPawn(Owner) != None)
			{
				mult = 1.0 / HXPlayerPawn(Owner).AugmentationSystem.GetAugLevelValue(class'HXAugCombat');
				if (mult == -1.0)
					mult = 1.0;
			}
			sTime = ShotTime * mult;
			return (sTime);
		}
	}
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = false;
			FinishAnim();
		}
		if (Owner != None)
		{
			if (Owner.IsA('HXPlayerPawn'))
			{
				bFiring = false;
				if (HXPlayerPawn(Owner).bAutoReload)
				{
					bClientReadyToFire = false;
					bInProcess = false;
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
					GotoState('SimQuickFinish');
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					IdleFunction();
					GotoState('SimQuickFinish');
				}
			}
			else if (Owner.IsA('HXScriptedPawn'))
			{
				bFiring = false;
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			IdleFunction();
			GotoState('SimQuickFinish');
		}
	}
	Sleep(GetSimShotTime());
	if (bAutomatic)
	{
		SimGenerateBullet();
		Goto('Begin');
	}
	bFiring = false;
	FinishAnim();
	bInProcess = false;
Done:
	bInProcess = false;
	bFiring = false;
	SimFinish();
}

simulated state SimQuickFinish
{
Begin:
	if ( IsAnimating() && (AnimSequence == 'Shoot') )
		FinishAnim();

	if (bHasMuzzleFlash)
		EraseMuzzleFlashTexture();

	bInProcess = false;
	bFiring=false;
}

simulated state SimIdle
{
	function Timer()
	{
		PlayIdleAnim();
	}
Begin:
	bInProcess = false;
	bFiring = false;
	if (!bNearWall)
		PlayAnim('Idle1',,0.1);
	SetTimer(3.0, True);
}


simulated state SimFinishFire
{
Begin:
	FinishAnim();

	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).FinishAnim();

	if (bHasMuzzleFlash)
		EraseMuzzleFlashTexture();

	bInProcess = false;
	bFiring=false;
	SimFinish();
}

simulated state SimDownweapon
{
ignores Fire, AltFire, ClientFire, ClientReFire;

Begin:
	if ( bWasInFiring )
	{
		if (bHasMuzzleFlash)
			EraseMuzzleFlashTexture();
		FinishAnim();
	}
	bInProcess = false;
	bFiring=false;
	TweenDown();
	FinishAnim();
}

simulated state SimActive
{
Begin:
	if ( bWasInFiring )
	{
		if (bHasMuzzleFlash)
			EraseMuzzleFlashTexture();
		FinishAnim();
	}
	bInProcess = false;
	bFiring=false;
	PlayAnim('Select',1.0,0.0);
	FinishAnim();
	SimFinish();
}

simulated state SimReload
{
ignores Fire, AltFire, ClientFire, ClientReFire;

	simulated function float GetSimReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (HXScriptedPawn(Owner) != None)
		{
			val = ReloadTime * (HXScriptedPawn(Owner).BaseAccuracy*2+1);
		}
		else if (HXPlayerPawn(Owner) != None)
		{
			// check for skill use if we are the player
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
		}
		return val;
	}
Begin:
	if ( bWasInFiring )
	{
		if (bHasMuzzleFlash)
			EraseMuzzleFlashTexture();
		FinishAnim();
	}
	bInProcess = false;
	bFiring=false;

	bWasZoomed = bZoomed;
	if (bWasZoomed)
		ScopeOff();

	Owner.PlaySound(CockingSound, SLOT_None,,, 1024);		// CockingSound is reloadbegin
	PlayAnim('ReloadBegin');
	FinishAnim();
	LoopAnim('Reload');
	Sleep(GetSimReloadTime());
	Owner.PlaySound(AltFireSound, SLOT_None,,, 1024);		// AltFireSound is reloadend
	ServerDoneReloading();
	PlayAnim('ReloadEnd');
	FinishAnim();

	if (bWasZoomed)
		ScopeOn();

	GotoState('SimIdle');
}


state Idle
{
	function bool PutDown()
	{
		// alert NPCs that I'm putting away my gun
		AIEndEvent('WeaponDrawn', EAITYPE_Visual);

		return Super(Weapon).PutDown();
	}

	function AnimEnd()
	{
	}

	function Timer()
	{
		PlayIdleAnim();
	}

	function BeginState()
	{
		Super(Weapon).BeginState();

		SpecialBeginStateIdle();
	}

Begin:
	bFiring = false;
	ReadyToFire();

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('HXPlayerPawn') && !HXPlayerPawn(Owner).PlayerIsListenClient()))
	{
	}
	else
	{
		if (!bNearWall)
			PlayAnim('Idle1',,0.1);
		SetTimer(3.0, True);
	}
}

state FlameThrowerOn
{
	function float GetShotTime()
	{
		local float mult, sTime;

		if (HXScriptedPawn(Owner) != None)
			return ShotTime * (HXScriptedPawn(Owner).BaseAccuracy*2+1);
		else
		{
			// AugCombat decreases shot time
			mult = 1.0;
			if (bHandToHand && HXPlayerPawn(Owner) != None)
			{
				mult = 1.0 / HXPlayerPawn(Owner).AugmentationSystem.GetAugLevelValue(class'HXAugCombat');
				if (mult == -1.0)
					mult = 1.0;
			}
			sTime = ShotTime * mult;
			return (sTime);
		}
	}
Begin:
	if ( (HXPlayerPawn(Owner).Health > 0) && bFlameOn && (ClipCount < ReloadCount))
	{
		if (( flameShotCount == 0 ) && (Owner != None))
		{
			PlayerPawn(Owner).PlayFiring();
			PlaySelectiveFiring();
			PlayFiringSound();
			flameShotCount = 6;
		}
		else
			flameShotCount--;

		Sleep( GetShotTime() );
		GenerateBullet();
		goto('Begin');
	}
Done:
	bFlameOn = false;
	GotoState('FinishFire');
}

state Active
{
	function bool PutDown()
	{
		// alert NPCs that I'm putting away my gun
		AIEndEvent('WeaponDrawn', EAITYPE_Visual);
		return Super(Weapon).PutDown();
	}

Begin:
	// Rely on client to fire if we are a multiplayer client

	if ( (Level.NetMode==NM_Standalone) || (Owner.IsA('HXPlayerPawn') && HXPlayerPawn(Owner).PlayerIsListenClient()) )
		bClientReady = True;
	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('HXPlayerPawn') && !HXPlayerPawn(Owner).PlayerIsListenClient()))
	{
		ClientActive();
		bClientReady = false;
	}

	if (!Owner.IsA('HXScriptedPawn'))
		FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');

	bWeaponUp = True;
	PlayPostSelect();
	if (!Owner.IsA('HXScriptedPawn'))
		FinishAnim();
	// reload the weapon if it's empty and autoreload is true
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (Owner.IsA('HXScriptedPawn') || ((HXPlayerPawn(Owner) != None) && HXPlayerPawn(Owner).bAutoReload))
			ReloadAmmo();
	}
	Finish();
}

/*
ignores Fire, AltFire;

	function bool PutDown()
	{
		Pawn(Owner).ClientPutDown(self, Pawn(Owner).PendingWeapon);
		return true; //just keep putting it down
	}

	function BeginState()
	{
		bChangeWeapon = false;
		bMuzzleFlash = 0;
		Pawn(Owner).ClientPutDown(self, Pawn(Owner).PendingWeapon);
	}

Begin:
	TweenDown();
	FinishAnim();
	Pawn(Owner).ChangedWeapon();
*/
state DownWeapon
{
ignores Fire, AltFire;

	function bool PutDown()
	{
		// alert NPCs that I'm putting away my gun
		AIEndEvent('WeaponDrawn', EAITYPE_Visual);
		//return Super(Weapon).PutDown();

		Pawn(Owner).ClientPutDown(self, Pawn(Owner).PendingWeapon);
		return true; //just keep putting it down
	}

	function BeginState()
	{
		bChangeWeapon = false;
		bMuzzleFlash = 0;
		Pawn(Owner).ClientPutDown(self, Pawn(Owner).PendingWeapon);

		SpecialBeginStateDownWeapon();
	}

Begin:
	ScopeOff();
	LaserOff();

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('HXPlayerPawn') && !HXPlayerPawn(Owner).PlayerIsListenClient()))
		ClientDownWeapon();

	TweenDown();
	FinishAnim();

	//if ( Level.NetMode != NM_Standalone )
	//{
		//ClipCount = 0;	// Auto-reload in multiplayer (when putting away)
	//}
	bOnlyOwnerSee = false;
	if (Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
}

// -----------------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// -----------------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return ((BeltSpot <= 3) && (BeltSpot >= 1));
}

/*
// Become a pickup
function BecomePickup()
{
	Super.BecomePickup();
	SetDisplayProperties(Default.Style, Default.Texture, Default.bUnlit, Default.bMeshEnviromap );
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 5.0;
}
*/

// -----------------------------------------------------------------------------
// BecomePickup()
// -----------------------------------------------------------------------------

function BecomePickup()
{
	// Just do this for tossed out weapons.
	if ( bTossedOut )
		SetPhysics( PHYS_Falling );

	if ( Physics != PHYS_Falling )
		RemoteRole    = ROLE_SimulatedProxy;

	Mesh          = PickupViewMesh;
	DrawScale     = PickupViewScale;
	bOnlyOwnerSee = false;
	bHidden       = false;
	bCarriedItem  = false;
	NetPriority   = 1.4;
	SetCollision( true, true, false );		// make things block actors as well - DEUS_EX CNN

	SetDisplayProperties(Default.Style, Default.Texture, Default.bUnlit, Default.bMeshEnviromap );

	if (Level.NetMode != NM_Standalone)
		if (bTossedOut)
			Lifespan = 0.0;
}

// Either give this inventory to player Other, or spawn a copy
// and give it to the player Other, setting up original to be respawned.
// Also add Ammo to Other's inventory if it doesn't already exist
//
function Inventory SpawnCopy( Pawn Other )
{
	local HXWeapon Copy;

	if ( Level.Game.ShouldRespawn(Self) )
	{
		Copy = Spawn(Class,Other,,,rot(0,0,0));
		Copy.Tag           = Tag;
		Copy.Event         = Event;

		// HX_INV: Copy PickupAmmoCount and AmmoName
		Copy.AmmoName						= AmmoName;
		Copy.PickupAmmoCount		= PickupAmmoCount;

		// Copy mod settings
		Copy.ModBaseAccuracy		= ModBaseAccuracy;
		Copy.ModReloadCount			= ModReloadCount;
		Copy.ModAccurateRange		= ModAccurateRange;
		Copy.ModReloadTime			= ModReloadTime;
		Copy.ModRecoilStrength	= ModRecoilStrength;

		Copy.bHasLaser					= bHasLaser;
		Copy.bHasSilencer				= bHasSilencer;
		Copy.bHasScope					= bHasScope;

		Copy.ReloadCount				= ReloadCount;
		Copy.AccurateRange			= AccurateRange;
		Copy.BaseAccuracy				= BaseAccuracy;
		Copy.ReloadTime					= ReloadTime;
		Copy.RecoilStrength			= RecoilStrength;

		//if ( !bWeaponStay )
		//{
			GotoState('Sleeping');
			//Destroy();
		//}

	}
	else
		Copy = self;

	Copy.RespawnTime = 0.0;
	Copy.bHeldItem = true;
	Copy.bTossedOut = false;

	// DEUS_EX AJY
	// Give weapon ammo before giving to player	
	Copy.GiveAmmo(Other);
	Copy.GiveTo( Other );

	Copy.Instigator = Other;
	Copy.SetSwitchPriority( Other );
	// DEUS_EX CNN - Don't autoswitch weapons
//	if ( !Other.bNeverSwitchOnPickup )
//		newWeapon.WeaponSet(Other);
	Copy.AmbientGlow = 0;
	return Copy;
}

//
// Give this inventory item to a pawn.
//
function GiveTo( pawn Other )
{
	// HX_INV
	SetOwner(Other);

	Instigator = Other;
	BecomeItem();
	Other.AddInventory( Self );
	GotoState('Idle2');
}

// ----------------------------------------------------------------------------
// SpecialBeginState*()
//
// Used for WeaponNanoSword LightEffect
// ----------------------------------------------------------------------------

function SpecialBeginStateDownWeapon() {}
function SpecialBeginStateIdle() {}
function SpecialBeginStatePickup() {}

// ----------------------------------------------------------------------------
// CanBeDropped()
//
// Called by HXPlayerPawn.DropItem() to see if we cannot be dropped for some
// reason.
// ----------------------------------------------------------------------------

function bool CanBeDropped( optional bool bSilent )
{
	// Old Unreal style throwing thingy.
	if ( !bCanThrow )
	{
		if ( !bSilent )
			Pawn(Owner).ClientMessage( Sprintf(MsgCannotThrow,ItemName), 'StatusLine' );	
		return false;
	}
	if ( !bCanDrop )
	{
		if ( !bSilent )
			Pawn(Owner).ClientMessage( Sprintf(MsgDropNotAllowed,ItemName), 'StatusLine' );	
		return false;
	}

	// Megayuk?
	if ( IsInState('Idle') || IsInState('Idle2') || IsInState('DownWeapon') || IsInState('Reload') )
	{
		return true;
	}
	else
	{
		if ( !bSilent )
			Pawn(Owner).ClientMessage( Sprintf(MsgCannotBeDroppedInState,ItemName,GetStateName()), 'StatusLine' );

		return false;
	}	
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// String functions.
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

static final function String LF()
{
	return Chr(10);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpawning=True
	PickupMessageClass=None
	RespawnTime=3153600000.000000
	bReadyToFire=True
	LowAmmoWaterMark=10
	NoiseLevel=1.000000
	ShotTime=0.500000
	reloadTime=1.000000
	HitDamage=10
	maxRange=9600
	AccurateRange=4800
	BaseAccuracy=0.500000
	ScopeFOV=10
	MaintainLockTimer=1.000000
	bPenetrating=True
	bHasMuzzleFlash=True
	bEmitWeaponDrawn=True
	bUseWhileCrouched=True
	bUseAsDrawnWeapon=True
	MinSpreadAcc=0.250000
	MinProjSpreadAcc=1.000000
	msgCannotBeReloaded="This weapon can't be reloaded"
	MsgOutOf="Out of %s"
	MsgNowHas="%s now has %s loaded"
	msgAlreadyHas="%s already has %s loaded"
	msgNone="NONE"
	msgLockInvalid="INVALID"
	msgLockRange="RANGE"
	msgLockAcquire="ACQUIRE"
	msgLockLocked="LOCKED"
	msgRangeUnit="FT"
	msgTimeUnit="SEC"
	msgMassUnit="LBS"
	msgNotWorking="This weapon doesn't work underwater"
	msgInfoAmmoLoaded="Ammo loaded:"
	msgInfoAmmo="Ammo type(s):"
	msgInfoDamage="Base damage:"
	msgInfoClip="Clip size:"
	msgInfoROF="Rate of fire:"
	msgInfoReload="Reload time:"
	msgInfoRecoil="Recoil:"
	msgInfoAccuracy="Base Accuracy:"
	msgInfoAccRange="Acc. range:"
	msgInfoMaxRange="Max. range:"
	msgInfoMass="Mass:"
	msgInfoLaser="Laser sight:"
	msgInfoScope="Scope:"
	msgInfoSilencer="Silencer:"
	msgInfoNA="N/A"
	msgInfoYes="YES"
	msgInfoNo="NO"
	msgInfoAuto="AUTO"
	msgInfoSingle="SINGLE"
	msgInfoRounds="RDS"
	msgInfoRoundsPerSec="RDS/SEC"
	msgInfoSkill="Skill:"
	msgInfoWeaponStats="Weapon Stats:"
	ReloadCount=10
	shakevert=10.000000
	Misc1Sound=Sound'DeusExSounds.Generic.DryFire'
	AutoSwitchPriority=0
	bRotatingPickup=false
	PickupMessage="You found"
	ItemName="DEFAULT WEAPON NAME - REPORT THIS AS A BUG"
	LandSound=Sound'DeusExSounds.Generic.DropSmallWeapon'
	bNoSmooth=false
	Mass=10.000000
	Buoyancy=5.000000
	bIsGrenade=False
	bCanDrop=True
	MsgAmmoLoaded="%s loaded"
	MsgCannotBeDroppedInState="%s cannot be dropped in state %s"
	MsgCannotThrow="You are not allowed to throw your %"
	MsgDropNotAllowed="You are not allowed to drop your %s"
}
