//=============================================================================
// HXWeaponGEPGun.
//=============================================================================
class HXWeaponGEPGun extends HXWeapon;

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	if ( Role==ROLE_Authority )
	{
		// Don't let NPC GEPs lock on to targets.
		if ( Owner!=None && !Owner.IsA('HXPlayerPawn') )
			bCanTrack = false;
	}
}

// -----------------------------------------------------------------------------
// SpawnCopy()
// -----------------------------------------------------------------------------

function Inventory SpawnCopy( Pawn Other )
{
	// !! HACK HACK !! A somewhat nasty way to make sure players can track again.
	// Code using bCanTrack needs a major cleanup before this can correctly 
	// addressed. --han
	if ( HXPlayerPawn(Other)!=None )
		bCanTrack = true;

	return Super.SpawnCopy( Other );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	LowAmmoWaterMark=4
	GoverningSkill=HXSkillWeaponHeavy
	NoiseLevel=2.0
	EnviroEffective=ENVEFF_Air
	ShotTime=2.0
	ReloadTime=2.0
	HitDamage=300
	MaxRange=24000
	AccurateRange=14400
	bCanHaveScope=True
	bCanTrack=True
	LockTime=2.0
	LockedSound=GEPGunLock
	TrackingSound=GEPGunTrack
	AmmoNames(0)=HXAmmoRocket
	AmmoNames(1)=HXAmmoRocketWP
	AmmoNames(2)=
	ProjectileNames(0)=HXRocket
	ProjectileNames(1)=HXRocketWP
	ProjectileNames(2)=
	FireSounds(0)=GEPGunFire
	FireSounds(1)=GEPGunFireWP
	FireSounds(2)=
	bHasMuzzleFlash=False
	RecoilStrength=1.0
	bUseWhileCrouched=False
	bCanHaveModAccurateRange=True
	bCanHaveModReloadTime=True
	AmmoName=HXAmmoRocket
	ReloadCount=1
	PickupAmmoCount=4
	FireOffset=(X=-46.0,Y=22.0,Z=10.0)
	ProjectileClass=HXRocket
	ShakeMag=500.0
	FireSound=GEPGunFire
	CockingSound=GEPGunReload
	SelectSound=GEPGunSelect
	InventoryGroup=17
	ItemName="Guided Explosive Projectile (GEP) Gun"
	PlayerViewOffset=(X=46.0,Y=-22.0,Z=-10.0)
	PlayerViewMesh=GEPGun
	PickupViewMesh=GEPGunPickup
	ThirdPersonMesh=GEPGun3rd
	LandSound=DropLargeWeapon
	Icon=BeltIconGEPGun
	LargeIcon=LargeIconGEPGun
	LargeIconWidth=203
	LargeIconHeight=77
	InvSlotsX=4
	InvSlotsY=2
	Description="The GEP gun is a relatively recent invention in the field of armaments: a portable, shoulder-mounted launcher that can fire rockets and laser guide them to their target with pinpoint accuracy. While suitable for high-threat combat situations, it can be bulky for those agents who have not grown familiar with it."
	beltDescription="GEP GUN"
	Mesh=GEPGunPickup
	CollisionRadius=27.00
	//CollisionHeight=6.60
	CollisionHeight=5.85
	Mass=50.0
}
