//=============================================================================
// HXWeaponGrenade.
//
// Baseclass of HX Grenade Weapons.
//=============================================================================
class HXWeaponGrenade extends HXWeapon
	abstract;

var bool bPlayOpenAnim; // EMP and NanoVirusGrenade want to play an additional animation.

// ----------------------------------------------------------------------------
// Fire()
// ----------------------------------------------------------------------------

function Fire( float Value )
{
	// If facing a wall, affix the NanoVirusGrenade to the wall.
	if ( bNearWall && Pawn(Owner)!=None )
	{
		bReadyToFire = False;
		GotoState( 'NormalFire' );
		bPointing = True;
		PlayAnim( 'Place',, 0.1 );
		return;
	}

	// Otherwise, throw as usual.
	Super.Fire( Value );
}

// ----------------------------------------------------------------------------
// ProjectileFire() - EMP and NanoVirus want to play an additional animation.
//
// TODO:
//  - Check if this really works out in mp (on clients).
//  - Maybe out this in projectile class code.
// ----------------------------------------------------------------------------

simulated function Projectile ProjectileFire( Class<Projectile> ProjClass, float ProjSpeed, bool bWarn )
{
	local Projectile Proj;

	Proj = Super.ProjectileFire(ProjClass, ProjSpeed, bWarn);

	// HX_HAN: Does this really work in MP?
	if ( Proj!=None && bPlayOpenAnim )
		Proj.PlayAnim('Open');
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bIsGrenade=True
	bPlayOpenAnim=False
	GoverningSkill=HXSkillDemolition
	LowAmmoWaterMark=2
	ShotTime=0.3
	ReloadTime=0.1
	HitDamage=0
	MaxRange=4800
	AccurateRange=2400
	BaseAccuracy=1.0
	bPenetrating=False
	StunDuration=60.0
	bHasMuzzleFlash=False
	bHandToHand=True
	bUseAsDrawnWeapon=False
	AITimeLimit=3.5
	AIFireDelay=5.0
	ReloadCount=1
	PickupAmmoCount=1
	FireOffset=(X=0.0,Y=10.0,Z=20.0)
	ShakeMag=50.0
	Mass=5.0
	Buoyancy=2.0
}
