//=============================================================================
// HXWeaponMiniCrossbow.
//=============================================================================
class HXWeaponMiniCrossbow extends HXWeapon;

// ----------------------------------------------------------------------------
// state NormalFire.
// ----------------------------------------------------------------------------

state NormalFire
{
	function BeginState()
	{
		// Pinkmask out the arrow when we're out of ammo or the clip is empty.
		if (ClipCount >= ReloadCount)
			MultiSkins[3] = Texture'PinkMaskTex';

		if ((AmmoType != None) && (AmmoType.AmmoAmount <= 0))
			MultiSkins[3] = Texture'PinkMaskTex';
	
		Super.BeginState();
	}
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

function Tick( float DeltaTime )
{
	// Unpinkmask the arrow when we reload -- thats an ION comment. --han
	if (MultiSkins[3] != None)
		if ((AmmoType != None) && (AmmoType.AmmoAmount > 0) && (ClipCount < ReloadCount))
			MultiSkins[3] = None;

	Super.Tick(deltaTime);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	LowAmmoWaterMark=4
	GoverningSkill=HXSkillWeaponPistol
	NoiseLevel=0.05
	EnemyEffective=ENMEFF_Organic
	Concealability=CONC_All
	ShotTime=0.8
	ReloadTime=2.0
	HitDamage=25
	MaxRange=1600
	AccurateRange=800
	BaseAccuracy=0.8
	bCanHaveScope=True
	ScopeFOV=15
	bCanHaveLaser=True
	bHasSilencer=True
	AmmoNames(0)=HXAmmoDartPoison
	AmmoNames(1)=HXAmmoDart
	AmmoNames(2)=HXAmmoDartFlare
	ProjectileNames(0)=HXDartPoison
	ProjectileNames(1)=HXDart
	ProjectileNames(2)=HXDartFlare
	StunDuration=10.0
	bHasMuzzleFlash=False
	bCanHaveModBaseAccuracy=True
	bCanHaveModAccurateRange=True
	bCanHaveModReloadTime=True
	AmmoName=HXAmmoDartPoison
	ReloadCount=4
	PickupAmmoCount=4
	FireOffset=(X=-25.0,Y=8.0,Z=14.0)
	ProjectileClass=HXDartPoison
	ShakeMag=30.0
	FireSound=MiniCrossbowFire
	AltFireSound=MiniCrossbowReloadEnd
	CockingSound=MiniCrossbowReload
	SelectSound=MiniCrossbowSelect
	InventoryGroup=9
	ItemName="Mini-Crossbow"
	PlayerViewOffset=(X=25.0,Y=-8.0,Z=-14.0)
	PlayerViewMesh=MiniCrossbow
	PickupViewMesh=MiniCrossbowPickup
	ThirdPersonMesh=MiniCrossbow3rd
	Icon=BeltIconCrossbow
	LargeIcon=LargeIconCrossbow
	LargeIconWidth=47
	LargeIconHeight=46
	InvSlotsX=1
	InvSlotsY=1
	Description="The mini-crossbow was specifically developed for espionage work, and accepts a range of dart types (normal, tranquilizer, or flare) that can be changed depending upon the mission requirements."
	BeltDescription="CROSSBOW"
	Mesh=MiniCrossbowPickup
	CollisionRadius=8.00
	//CollisionHeight=1.00
	CollisionHeight=0.25
	Mass=15.0
}
