//=============================================================================
// HXWeaponMod.
//=============================================================================
class HXWeaponMod extends HXDeusExPickup
	abstract;

var() Float WeaponModifier;
var localized String DragToUpgrade;

// ----------------------------------------------------------------------------
// Network Replication.
// ----------------------------------------------------------------------------

replication
{
	// client to server function call
	reliable if (Role < ROLE_Authority)
		ApplyMod, DestroyMod;
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	Super.PostBeginPlay();

	LoopAnim('Cycle');
}

// ----------------------------------------------------------------------------
// ApplyMod()
//
// Applies the modification to the weapon.  Unique for each different 
// type of weapon mod class
// ----------------------------------------------------------------------------

function ApplyMod(HXWeapon weapon)
{
}

// ----------------------------------------------------------------------------
// CanUpgradeWeapon()
// ----------------------------------------------------------------------------

function bool CanUpgradeWeapon(HXWeapon weapon)
{
}

// ----------------------------------------------------------------------------
// DestroyMod()
// Destroys the mod.  Just placed here for propagation.
// ----------------------------------------------------------------------------

function DestroyMod()
{
   Destroy();
}

// ----------------------------------------------------------------------------
// InfoText()
//
// Description intended for the info window.
// ----------------------------------------------------------------------------

simulated function string InfoText()
{
	// Only show count if we have multiple copies.
	if ( bCanHaveMultipleCopies && NumCopies>1 )
		return Description $ "|n|n" $ DragToUpgrade $ "|n|n" $ CountLabel @ String(NumCopies);
	else
		return Description $ "|n|n" $ DragToUpgrade;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	DragToUpgrade="Drag over weapon to upgrade.  Weapons highlighted in GREEN can be upgraded with this mod."
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=WeaponMod
	PickupViewMesh=WeaponMod
	ThirdPersonMesh=WeaponMod
	LandSound=PlasticHit1
	LargeIconWidth=34
	LargeIconHeight=49
	InvSlotsX=1
	InvSlotsY=1
	Mesh=WeaponMod
	CollisionRadius=3.50
	//CollisionHeight=4.42
	CollisionHeight=3.67
	Mass=1.0
}
