//=============================================================================
// HXWeaponModClip
//
// Increases Clip Capacity
//=============================================================================
class HXWeaponModClip extends HXWeaponMod;

// ----------------------------------------------------------------------------
// ApplyMod()
// ----------------------------------------------------------------------------

function ApplyMod(HXWeapon weapon)
{
	local int diff;

	if (weapon != None)
	{
		diff = Float(weapon.Default.ReloadCount) * WeaponModifier;

		// make sure we add at least one
		if (diff < 1)
			diff = 1;

		weapon.ReloadCount += diff;
		weapon.ModReloadCount += WeaponModifier;
	}
}

// ----------------------------------------------------------------------------
// CanUpgradeWeapon()
// ----------------------------------------------------------------------------

simulated function bool CanUpgradeWeapon(HXWeapon weapon)
{
	if (weapon != None)
		return (weapon.bCanHaveModReloadCount && !weapon.HasMaxClipMod());
	else
		return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	WeaponModifier=0.1
	ItemName="Weapon Modification (Clip)"
	Icon=BeltIconWeaponModClip
	LargeIcon=LargeIconWeaponModClip
	Description="An extended magazine that increases clip capacity beyond the factory default."
	BeltDescription="MOD CLIP"
	Skin=WeaponModTex3
}
