//=============================================================================
// HXWeaponModLaser
//
// Adds a laser sight to a weapon
//=============================================================================
class HXWeaponModLaser extends HXWeaponMod;

// ----------------------------------------------------------------------------
// ApplyMod()
// ----------------------------------------------------------------------------

function ApplyMod(HXWeapon weapon)
{
	if (weapon != None)
		weapon.bHasLaser = True;
}

// ----------------------------------------------------------------------------
// CanUpgradeWeapon()
// ----------------------------------------------------------------------------

simulated function bool CanUpgradeWeapon(HXWeapon weapon)
{
	if (weapon != None)
		return (weapon.bCanHaveLaser && !weapon.bHasLaser);
	else
		return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Weapon Modification (Laser)"
	Icon=BeltIconWeaponModLaser
	LargeIcon=LargeIconWeaponModLaser
	Description="A laser targeting dot eliminates any inaccuracy resulting from the inability to visually gauge a projectile's point of impact."
	BeltDescription="MOD LASER"
	Skin=WeaponModTex4
}
