//=============================================================================
// HXWeaponModRecoil
//
// Decreases recoil amount
//=============================================================================
class HXWeaponModRecoil extends HXWeaponMod;

// ----------------------------------------------------------------------------
// ApplyMod()
// ----------------------------------------------------------------------------

function ApplyMod(HXWeapon weapon)
{
	if (weapon != None)
	{
		weapon.recoilStrength    += (weapon.Default.recoilStrength * WeaponModifier);
		if (weapon.recoilStrength < 0.0)
			weapon.recoilStrength = 0.0;
		weapon.ModRecoilStrength += WeaponModifier;
	}
}

// ----------------------------------------------------------------------------
// CanUpgradeWeapon()
// ----------------------------------------------------------------------------

simulated function bool CanUpgradeWeapon(HXWeapon weapon)
{
	if (weapon != None)
		return (weapon.bCanHaveModRecoilStrength && !weapon.HasMaxRecoilMod());
	else
		return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	WeaponModifier=-0.1
	ItemName="Weapon Modification (Recoil)"
	Icon=BeltIconWeaponModRecoil
	LargeIcon=LargeIconWeaponModRecoil
	Description="Grip and stock cushioned with polycellular shock absorbing material will significantly reduce perceived recoil."
	BeltDescription="MOD RECOL"
	Skin=WeaponModTex5
}
