//=============================================================================
// HXWeaponModReload
//
// Decreases reload time
//=============================================================================
class HXWeaponModReload extends HXWeaponMod;

// ----------------------------------------------------------------------------
// ApplyMod()
// ----------------------------------------------------------------------------

function ApplyMod(HXWeapon weapon)
{
	if (weapon != None)
	{
		weapon.ReloadTime    += (weapon.Default.ReloadTime * WeaponModifier);
		if (weapon.ReloadTime < 0.0)
			weapon.ReloadTime = 0.0;
		weapon.ModReloadTime += WeaponModifier;
	}
}

// ----------------------------------------------------------------------------
// CanUpgradeWeapon()
// ----------------------------------------------------------------------------

simulated function bool CanUpgradeWeapon(HXWeapon weapon)
{
	if (weapon != None)
		return (weapon.bCanHaveModReloadTime && !weapon.HasMaxReloadMod());
	else
		return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	WeaponModifier=-0.1
	ItemName="Weapon Modification (Reload)"
	Icon=BeltIconWeaponModReload
	LargeIcon=LargeIconWeaponModReload
	Description="A speed loader greatly decreases the time required to reload a weapon."
	BeltDescription="MOD RELOD"
	Skin=WeaponModTex6
}
