//=============================================================================
// HXWeaponModScope
//
// Adds a scope sight to a weapon
//=============================================================================
class HXWeaponModScope extends HXWeaponMod;

// ----------------------------------------------------------------------------
// ApplyMod()
// ----------------------------------------------------------------------------

function ApplyMod(HXWeapon weapon)
{
	if (weapon != None)
		weapon.bHasScope = True;
}

// ----------------------------------------------------------------------------
// CanUpgradeWeapon()
// ----------------------------------------------------------------------------

simulated function bool CanUpgradeWeapon(HXWeapon weapon)
{
	if (weapon != None)
		return (weapon.bCanHaveScope && !weapon.bHasScope);
	else
		return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Weapon Modification (Scope)"
	Icon=BeltIconWeaponModScope
	LargeIcon=LargeIconWeaponModScope
	Description="A telescopic scope attachment provides zoom capability and increases accuracy against distant targets."
	BeltDescription="MOD SCOPE"
	Skin=WeaponModTex8
}
