//=============================================================================
// HXWeaponModSilencer
//
// Adds a Silencer sight to a weapon
//=============================================================================
class HXWeaponModSilencer extends HXWeaponMod;

// ----------------------------------------------------------------------------
// ApplyMod()
// ----------------------------------------------------------------------------

function ApplyMod(HXWeapon weapon)
{
	if (weapon != None)
		weapon.bHasSilencer = True;
}

// ----------------------------------------------------------------------------
// CanUpgradeWeapon()
// ----------------------------------------------------------------------------

simulated function bool CanUpgradeWeapon(HXWeapon weapon)
{
	if (weapon != None)
		return (weapon.bCanHaveSilencer && !weapon.bHasSilencer);
	else
		return False;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Weapon Modification (Silencer)"
	Icon=BeltIconWeaponModSilencer
	LargeIcon=LargeIconWeaponModSilencer
	Description="A silencer will muffle the muzzle crack caused by rapidly expanding gases left in the wake of a bullet leaving the gun barrel.|n|n<UNATCO OPS FILE NOTE SC109-BLUE> Obviously, a silencer is only effective with firearms. -- Sam Carter <END NOTE>"
	BeltDescription="MOD SLNCR"
	Skin=WeaponModTex7
}
