//=============================================================================
// HXWeaponNanoSword.
//=============================================================================
class HXWeaponNanoSword extends HXWeaponMelee;

// ----------------------------------------------------------------------------
// SpecialBeginStateDownWeapon()
// ----------------------------------------------------------------------------

function SpecialBeginStateDownWeapon()
{
	LightType = LT_None;
}

// ----------------------------------------------------------------------------
// SpecialBeginStateIdle()
// ----------------------------------------------------------------------------

function SpecialBeginStateIdle()
{
	LightType = LT_Steady;
}

// ----------------------------------------------------------------------------
// SpecialBeginStatePickup()
// ----------------------------------------------------------------------------

function SpecialBeginStatePickup()
{
	LightType = LT_None;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	LowAmmoWaterMark=0
	GoverningSkill=HXSkillWeaponLowTech
	NoiseLevel=0.05
	ReloadTime=0.0
	HitDamage=20
	MaxRange=96
	AccurateRange=96
	BaseAccuracy=1.0
	AreaOfEffect=AOE_Cone
	bHasMuzzleFlash=False
	bHandToHand=True
	SwingOffset=(X=24.0,Y=0.0,Z=2.0)
	AmmoName=HXAmmoNone
	ReloadCount=0
	bInstantHit=True
	FireOffset=(X=-21.0,Y=16.0,Z=27.0)
	ShakeMag=20.0
	FireSound=NanoSwordFire
	SelectSound=NanoSwordSelect
	Misc1Sound=NanoSwordHitFlesh
	Misc2Sound=NanoSwordHitHard
	Misc3Sound=NanoSwordHitSoft
	InventoryGroup=14
	ItemName="Dragon's Tooth Sword"
	ItemArticle="the"
	PlayerViewOffset=(X=21.0,Y=-16.0,Z=-27.0)
	PlayerViewMesh=NanoSword
	PickupViewMesh=NanoSwordPickup
	ThirdPersonMesh=NanoSword3rd
	LandSound=DropLargeWeapon
	Icon=BeltIconDragonTooth
	LargeIcon=LargeIconDragonTooth
	LargeIconWidth=205
	LargeIconHeight=46
	InvSlotsX=4
	InvSlotsY=1
	Description="The true weapon of a modern warrior, the Dragon's Tooth is not a sword in the traditional sense, but a nanotechnologically constructed blade that is dynamically 'forged' on command into a non-eutectic solid. Nanoscale whetting devices insure that the blade is both unbreakable and lethally sharp."
	BeltDescription="DRAGON"
	Mesh=NanoSwordPickup
	CollisionRadius=32.00
	//CollisionHeight=2.40
	CollisionHeight=1.65
	LightType=LT_Steady
	LightEffect=LE_WateryShimmer
	LightBrightness=224
	LightHue=160
	LightSaturation=64
	LightRadius=4
	Mass=20.0
}
