//=============================================================================
// HXWindow.
//
// Whole idea is currently just to have the capability to query multiplier.
//=============================================================================
class HXWindow extends Window
	native;

// RootWindow and it's ParentPawn. Set by C++ code at Window initialization.
var const HXPlayerPawn PlayerPawn;
var const HXRootWindow RootWindow;

// Returns RootWindows hMultiplier.
native(3500) final function int WindowScale();

// ----------------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window.
// ----------------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	StyleChanged();
}

// ----------------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------------

event StyleChanged();

// ----------------------------------------------------------------------------
// MakeColor()
// ----------------------------------------------------------------------------

final static function Color MakeColor( float InR, float InG, float InB, float InA )
{
	local Color Color;

	Color.R = InR;
	Color.G = InG;
	Color.B = InB;
	Color.A = InA;

	return Color;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
