//=============================================================================
// HXZoneTrigger.
//=============================================================================
class HXZoneTrigger extends HXTrigger;

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	local ZoneInfo Z;

	if ( !IsRelevant(Other) )
		return;

	// Broadcast the Trigger message to all matching actors.
	if ( Event!='' )
		foreach AllActors( class'ZoneInfo', Z )
			if ( Z.ZoneTag==Event )
				Z.Trigger( Other, Other.Instigator );

	// Send a string message to the toucher.
	if ( Message != "" )
		Other.Instigator.ClientMessage( Message );

	// Ignore future touches.
	if ( bTriggerOnceOnly )
			SetCollision(False);
}

// ----------------------------------------------------------------------------
// UnTouch()
// ----------------------------------------------------------------------------

function UnTouch( Actor Other )
{
	local ZoneInfo Z;

	if ( !IsRelevant(Other) )
		return;

	// Untrigger all matching actors.
	if ( Event!='' )
		foreach AllActors( class'ZoneInfo', Z )
			if ( Z.ZoneTag==Event )
				Z.UnTrigger( Other, Other.Instigator );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
