//=============================================================================
// MPCConWinThirdController.
//=============================================================================
class MPCConWinThirdController extends MPCConWinController;

var MPCConWindowActive conWinThird;
var ConChoice choiceArray[10];

replication
{
	// Server to Client
	reliable if (Role == ROLE_Authority)
		ClientHudHide, ClientHudShow,
		ClientCreate, ClientSetWindowAlignments, ClientShow, ClientSetForcePlay,
		ClientDestroy, ClientClose, ClientAppendText,ClientClear, ClientDisplayName,
		ClientDisplayText, ClientRestrictInput, ClientDisplayChoiceByIndex,
		ClientDisplaySkillChoiceByIndex, AskClientForTerminateConversationResponse;

	// Client to Server
	reliable if (Role < ROLE_Authority)
		ServerPlayNextEvent, ServerPlayChoiceByIndex, ServerGotoStateWaitForConWin,
		ServerConWinFinished;

}


// ----------------------------------------------------------------------
// DisplayChoice()
// ----------------------------------------------------------------------

function DisplayChoice(ConChoice choice, int index)
{
	choiceArray[index] = choice;
	ClientDisplayChoiceByIndex(choice.choiceText, index);
}


// ----------------------------------------------------------------------
// DisplaySkillChoice()
// ----------------------------------------------------------------------

function DisplaySkillChoice(ConChoice choice, int index)
{
	choiceArray[index] = choice;
	ClientDisplaySkillChoiceByIndex(choice.choiceText, choice.skillNeeded, choice.skillLevelNeeded, index);
}



// ----------------------------------------------------------------------
// ClientHudHide()
// ----------------------------------------------------------------------
simulated function ClientHudHide()
{
	DeusExRootWindow(player.rootWindow).hud.Hide();

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientHudShow()
// ----------------------------------------------------------------------
simulated function ClientHudShow()
{
	DeusExRootWindow(player.rootWindow).hud.Show();

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}


// ----------------------------------------------------------------------
// ClientCreate()
// ----------------------------------------------------------------------

simulated function ClientCreate()
{
	if (player != None)
		conWinThird = MPCConWindowActive(player.rootWindow.NewChild(Class'MPCConWindowActive', False));
	else
		Warn("'player' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientSetWindowAlignments()
// ----------------------------------------------------------------------

simulated function ClientSetWindowAlignments()
{
	if (conWinThird != None)
		conWinThird.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientShow()
// ----------------------------------------------------------------------

simulated function ClientShow()
{
	if (conWinThird != None)
		conWinThird.Show();
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}
		

// ----------------------------------------------------------------------
// ClientSetForcePlay()
// ----------------------------------------------------------------------

simulated function ClientSetForcePlay(bool bForcePlay)
{
	if (conWinThird != None)
		conWinThird.SetForcePlay(bForcePlay);
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientDestroy()
// ----------------------------------------------------------------------

simulated function ClientDestroy()
{
	if (conWinThird != None)
		conWinThird.Destroy();
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientDestroy()
// ----------------------------------------------------------------------

simulated function ClientClose()
{
	if (conWinThird != None)
		conWinThird.Close();
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientAppendText()
// ----------------------------------------------------------------------

simulated function ClientAppendText(string text)
{
	if (conWinThird != None)
		conWinThird.AppendText(text);
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientClear()
// ----------------------------------------------------------------------

simulated function ClientClear()
{
	if (conWinThird != None)
		conWinThird.Clear();
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientDisplayName()
// ----------------------------------------------------------------------

simulated function ClientDisplayName(string text)
{
	if (conWinThird != None)
		conWinThird.DisplayName(text);
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientDisplayText()
// ----------------------------------------------------------------------

simulated function ClientDisplayText(string text, Actor speakingActor)
{
	if (conWinThird != None)
		conWinThird.DisplayText(text, speakingActor);
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientRestrictInput()
// ----------------------------------------------------------------------

simulated function ClientRestrictInput(bool bRestrictInput)
{
	if (conWinThird != None)
		conWinThird.RestrictInput(bRestrictInput);
	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientDisplayChoiceByIndex()
// ----------------------------------------------------------------------

simulated function ClientDisplayChoiceByIndex(string choiceText, int index)
{
	if (conWinThird != None)
		conWinThird.DisplayChoiceWithIndex(choiceText, index);

	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}

// ----------------------------------------------------------------------
// ClientDisplaySkillChoiceByIndex()
// ----------------------------------------------------------------------

simulated function ClientDisplaySkillChoiceByIndex(string choiceText, class skillNeeded, int skillLevelNeeded, int index)
{
	if (conWinThird != None)
		conWinThird.DisplaySkillChoiceWithIndex(choiceText, skillNeeded, skillLevelNeeded, index);

	else
		Warn("'conWinThird' is non existing.");

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}



// ----------------------------------------------------------------------
// ServerPlayNextEvent()
// ----------------------------------------------------------------------

function ServerPlayNextEvent()
{
	player.mpcConPlay.PlayNextEvent();
}

// ----------------------------------------------------------------------
// ServerPlayChoiceByIndex()
// ----------------------------------------------------------------------

function ServerPlayChoiceByIndex(int index)
{
	player.mpcConPlay.PlayChoice(choiceArray[index]);
}

// ----------------------------------------------------------------------
// ServerGotoStateWaitForConWin()
// ----------------------------------------------------------------------

function ServerGotoStateWaitForConWin()
{
	player.mpcConPlay.GotoState('WaitForConWin');
}

// ----------------------------------------------------------------------
// ServerConWinFinished()
// ----------------------------------------------------------------------

function ServerConWinFinished()
{
	player.mpcConPlay.ConWinFinished();
}



// ----------------------------------------------------------------------
// AskClientForTerminateConversationResponse()
// ----------------------------------------------------------------------

simulated function AskClientForTerminateConversationResponse()
{
	if (conWinThird != None)
		ServerGotoStateWaitForConWin();
	else
		ServerConWinFinished();

	if (Role == ROLE_Authority && Level.NetMode != NM_ListenServer)
		Warn("Role == ROLE_Authority && Level.NetMode != NM_ListenServer");
}



// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}