//=============================================================================
// MPCConWindowActive.
//=============================================================================
class MPCConWindowActive extends ConWindowActive;

// Conversation fonts for third-person convos
var Font ConversationSpeechFonts[2];
var Font ConversationNameFonts[2];

// ----------------------------------------------------------------------
// CreateSpeechWindow()
// ----------------------------------------------------------------------

function CreateSpeechWindow()
{
	if (winSpeech == None)
	{
		winSpeech = ConWindowSpeech(lowerConWindow.NewChild(Class'ConWindowSpeech'));
		winSpeech.SetSpeechFont(GetCurrentSpeechFont());
		winSpeech.SetNameFont(GetCurrentNameFont());
		winSpeech.SetForcePlay(bForcePlay);
	}
}

// ----------------------------------------------------------------------
// DisplayChoiceWithIndex()
// ----------------------------------------------------------------------

function DisplayChoiceWithIndex(string choiceText, int index)
{
	local ConChoiceWindow newButton;

	newButton = CreateConButton( HALIGN_Left, colConTextChoice, colConTextFocus );
	newButton.SetText("~ " $ choiceText);
	//newButton.SetUserObject(choice);

	// These next two calls handle highlighting of the choice
	newButton.SetButtonTextures(,Texture'Solid', Texture'Solid', Texture'Solid');
	newButton.SetButtonColors(,colConTextChoice, colConTextChoice, colConTextChoice);

	// Add the button
	AddButtonWithIndex(newButton, index);
}

// ----------------------------------------------------------------------
// DisplaySkillChoiceWithIndex()
// ----------------------------------------------------------------------

function DisplaySkillChoiceWithIndex(string choiceText, class skillNeeded, int skillLevelNeeded, int index)
{
	local ConChoiceWindow newButton;

	newButton = CreateConButton(HALIGN_Left, colConTextSkill, colConTextFocus);
	newButton.SetText("~  " $ choiceText $ "  (" $ skillNeeded $ ":" $ skillLevelNeeded $ ")");
	//newButton.SetUserObject(choice);

	// Add the button
	AddButtonWithIndex(newButton, index);
}

// ----------------------------------------------------------------------
// AddButtonWithIndex()
// ----------------------------------------------------------------------

function AddButtonWithIndex(ConChoiceWindow newButton, int index)
{
	// Turn the cursor on so the user can use the cursor to 
	// select a choice.
	root.ShowCursor(True);

	// Add to our button array
	conChoices[index] = newButton;

	numChoices++;
}

// ----------------------------------------------------------------------
// ButtonActivated()
//
// We received a button click, which we want to return to the ConPlay
// object so it can process it.
//
// We'll just return the index into our array of buttons and let
// ConPlay figure out what to do with it!
// ----------------------------------------------------------------------

function bool ButtonActivated(Window buttonPressed)
{
	local int buttonIndex;

	// Abort if we're restricting input
	if (bRestrictInput)
		return True;

	// Restrict input again until we've finished processing this choice
	bRestrictInput = True;

	// Abort if we're in the process of moving
	if ( moveMode != MM_None )
		return True;

	// Take a look to make sure it's one of our buttons before continuing.
	for (buttonIndex=0; buttonIndex<numChoices; buttonIndex++)
	{
		if (conChoices[buttonIndex] == buttonPressed)
		{
			// Turn the cursor back off
			root.ShowCursor(False);
			MPCHuman(player).ConWinThirdCtrl.ServerPlayChoiceByIndex(buttonIndex);

			// Clear the screen
			Clear();

			break;
		}
	}

	return True;
}

// ----------------------------------------------------------------------
// MouseButtonReleased
//
// If there are no choices visible, the user can click anywhere on the screen
// to continue.  Otherwise the user must click on one of the choices to 
// continue.
// ----------------------------------------------------------------------

event bool MouseButtonReleased(float pointX, float pointY, EInputKey button, int numClicks)
{
	// Abort if we're restricting input
	if (bRestrictInput)
		return True;

	// Ignore keys in bForcePlay mode
	if (bForcePlay)
	{
		AbortCinematicConvo();
		return True;
	}
	
	// Abort if we're in the process of moving
	if ( moveMode != MM_None )
		return True;

	if ( numChoices == 0 ) 
		MPCHuman(player).ConWinThirdCtrl.ServerPlayNextEvent();

	return True;
}

// ----------------------------------------------------------------------
// VirtualKeyPressed()
//
// If the user hits Return while just Speech is displayed, allow them 
// to continue
// ----------------------------------------------------------------------

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bHandled;
	bHandled = True;

	// Abort if we're restricting input
	if (bRestrictInput)
		return True;

	// Ignore keys in bForcePlay mode
	if (bForcePlay)
	{
		if (key == IK_Escape)
		{	
			AbortCinematicConvo();
			return True;
		}
		else
		{
			return False;
		}
	}
	
	// Check for Ctrl-F9, which is a hard-coded key to take a screenshot
	if ( IsKeyDown( IK_Ctrl ) && ( key == IK_F9 ))
	{
		player.ConsoleCommand("SHOT");			
		return True;
	}

	switch( key ) 
	{	
		case IK_Escape:
		case IK_Enter:	
		case IK_Space:
			if (numChoices == 0)
				MPCHuman(player).ConWinThirdCtrl.ServerPlayNextEvent();
			break;

		// Let Up and Down arrows through for choices
		case IK_Up:
		case IK_Down:
			bHandled = False;
			break;
	}

	return bHandled;
}

// ----------------------------------------------------------------------
// CreateConButton()
// ----------------------------------------------------------------------

function ConChoiceWindow CreateConButton(EHAlign hAlign, Color colTextNormal, Color colTextFocus)
{
	local ConChoiceWindow newButton;

	newButton = ConChoiceWindow(lowerConWindow.NewChild(Class'ConChoiceWindow'));
	newButton.SetTextAlignments(hAlign, VALIGN_Center);
	newButton.SetTextMargins(10, 2);
	newButton.SetFont(GetCurrentSpeechFont());
	newButton.SetTextColors(colTextNormal, colTextFocus, colTextFocus, colTextFocus);

	return newButton;
}

// ----------------------------------------------------------------------
// AbortCinematicConvo()
// ----------------------------------------------------------------------

function AbortCinematicConvo()
{
	local MissionEndgame script;
	local DeusExPlayer localPlayer;

	localPlayer = player;

	conPlay.TerminateConversation();

	foreach localPlayer.AllActors(class'MissionEndgame', script)	
		break;

	if (script != None)
		script.FinishCinematic();
}


// ----------------------------------------------------------------------
// GetCurrentSpeechFont() - moved here from ConPlay.uc
// ----------------------------------------------------------------------

function Font GetCurrentSpeechFont()
{
	local int resWidth;

	resWidth = GetCurrentResolutionWidth();

	if ((resWidth > 800) && (resWidth < 1280))
		return ConversationSpeechFonts[1];
	else
		return ConversationSpeechFonts[0];
}


// ----------------------------------------------------------------------
// GetCurrentNameFont() - moved here from ConPlay.uc
// ----------------------------------------------------------------------

function Font GetCurrentNameFont()
{
	local int resWidth;

	resWidth = GetCurrentResolutionWidth();

	if ((resWidth > 800) && (resWidth < 1280))
		return ConversationNameFonts[1];
	else
		return ConversationNameFonts[0];
}


// ----------------------------------------------------------------------
// GetCurrentResolutionWidth() - moved here from ConPlay.uc
// ----------------------------------------------------------------------

function int GetCurrentResolutionWidth()
{
	local int p;
	local int resX;
	local int resWidth;
	local string CurrentRes;

	CurrentRes   = player.ConsoleCommand("GetCurrentRes");

	resX      = InStr(CurrentRes,"x");
	resWidth  = int(Left(CurrentRes, resX));

	return resWidth;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	ConversationSpeechFonts(0)=Font'DeusExUI.FontConversation'
	ConversationSpeechFonts(1)=Font'DeusExUI.FontConversationLarge'
	ConversationNameFonts(0)=Font'DeusExUI.FontConversationBold'
	ConversationNameFonts(1)=Font'DeusExUI.FontConversationLargeBold'
}