//=============================================================================
// MPCScriptedPawn.
//=============================================================================
class MPCScriptedPawn expands ScriptedPawn
	abstract;

// ----------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------

simulated function Destroyed()
{
	local MPCHuman player;

	// Pass a message to mpcConPlay, if it exists in the player, that
	// this pawn has been destroyed.  This is used to prevent
	// bad things from happening in converseations.

	player = MPCHuman(GetPlayerPawn());

	if ((player != None) && (player.mpcConPlay != None))
		player.mpcConPlay.ActorDestroyed(Self);

	Super(Pawn).Destroyed();
}



// ----------------------------------------------------------------------
// PlayIdleSound()
// ----------------------------------------------------------------------

function PlayIdleSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if (dxPlayer != None)
		dxPlayer.StartAIBarkConversation(self, BM_Idle);
}


// ----------------------------------------------------------------------
// PlayScanningSound()
// ----------------------------------------------------------------------

function PlayScanningSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if (dxPlayer != None)
		dxPlayer.StartAIBarkConversation(self, BM_Scanning);
}


// ----------------------------------------------------------------------
// PlayPreAttackSearchingSound()
// ----------------------------------------------------------------------

function PlayPreAttackSearchingSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (SeekPawn == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_PreAttackSearching);
}


// ----------------------------------------------------------------------
// PlayPreAttackSightingSound()
// ----------------------------------------------------------------------

function PlayPreAttackSightingSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (SeekPawn == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_PreAttackSighting);
}


// ----------------------------------------------------------------------
// PlayPostAttackSearchingSound()
// ----------------------------------------------------------------------

function PlayPostAttackSearchingSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (SeekPawn == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_PostAttackSearching);
}


// ----------------------------------------------------------------------
// PlayTargetAcquiredSound()
// ----------------------------------------------------------------------

function PlayTargetAcquiredSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_TargetAcquired);
}


// ----------------------------------------------------------------------
// PlayTargetLostSound()
// ----------------------------------------------------------------------

function PlayTargetLostSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (SeekPawn == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_TargetLost);
}


// ----------------------------------------------------------------------
// PlaySearchGiveUpSound()
// ----------------------------------------------------------------------

function PlaySearchGiveUpSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (SeekPawn == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_SearchGiveUp);
}


// ----------------------------------------------------------------------
// PlayGoingForAlarmSound()
// ----------------------------------------------------------------------

function PlayGoingForAlarmSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_GoingForAlarm);
}


// ----------------------------------------------------------------------
// PlayOutOfAmmoSound()
// ----------------------------------------------------------------------

function PlayOutOfAmmoSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if (dxPlayer != None)
		dxPlayer.StartAIBarkConversation(self, BM_OutOfAmmo);
}


// ----------------------------------------------------------------------
// PlayCriticalDamageSound()
// ----------------------------------------------------------------------

function PlayCriticalDamageSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_CriticalDamage);
}


// ----------------------------------------------------------------------
// PlayAreaSecureSound()
// ----------------------------------------------------------------------

function PlayAreaSecureSound()
{
	local DeusExPlayer dxPlayer;

	// Should we do a player check here?

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_AreaSecure);
}


// ----------------------------------------------------------------------
// PlayFutzSound()
// ----------------------------------------------------------------------

function PlayFutzSound()
{
	local DeusExPlayer dxPlayer;
	local Name         conName;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if (dxPlayer != None)
	{
		if (dxPlayer.barkManager != None)
		{
			conName = dxPlayer.barkManager.BuildBarkName(self, BM_Futz);
			dxPlayer.StartConversationByName(conName, self, !bInterruptState);
		}
//		dxPlayer.StartAIBarkConversation(self, BM_Futz);
	}
}


// ----------------------------------------------------------------------
// PlayOnFireSound()
// ----------------------------------------------------------------------

function PlayOnFireSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if (dxPlayer != None)
		dxPlayer.StartAIBarkConversation(self, BM_OnFire);
}


// ----------------------------------------------------------------------
// PlayTearGasSound()
// ----------------------------------------------------------------------

function PlayTearGasSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if (dxPlayer != None)
		dxPlayer.StartAIBarkConversation(self, BM_TearGas);
}


// ----------------------------------------------------------------------
// PlayCarcassSound()
// ----------------------------------------------------------------------

function PlayCarcassSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (SeekPawn == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_Gore);
}


// ----------------------------------------------------------------------
// PlaySurpriseSound()
// ----------------------------------------------------------------------

function PlaySurpriseSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_Surprise);
}


// ----------------------------------------------------------------------
// PlayAllianceHostileSound()
// ----------------------------------------------------------------------

function PlayAllianceHostileSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_AllianceHostile);
}


// ----------------------------------------------------------------------
// PlayAllianceFriendlySound()
// ----------------------------------------------------------------------

function PlayAllianceFriendlySound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
		dxPlayer.StartAIBarkConversation(self, BM_AllianceFriendly);
}


// ----------------------------------------------------------------------
// state Conversation
//
// Just sit here until the conversation is over
// ----------------------------------------------------------------------

state Conversation
{

	function SetOrders(Name orderName, optional Name newOrderTag, optional bool bImmediate)
	{
		local MPCHuman dxPlayer;

		dxPlayer = MPCHuman(GetPlayerPawn());
		if (dxPlayer != None)
			if (dxPlayer.mpcConPlay != None)
				if (dxPlayer.mpcConPlay.GetForcePlay())
				{
					Global.SetOrders(orderName, newOrderTag, bImmediate);
					return;
				}

		ConvOrders   = orderName;
		ConvOrderTag = newOrderTag;
	}

	function BeginState()
	{
		local MPCHuman dxPlayer;
		local bool         bBlock;

		ResetConvOrders();
		EnableCheckDestLoc(false);

		bBlock = True;
		dxPlayer = MPCHuman(GetPlayerPawn());
		if (dxPlayer != None)
			if (dxPlayer.mpcConPlay != None)
				if (dxPlayer.mpcConPlay.CanInterrupt())
					bBlock = False;

		bInterruptState = True;
		if (bBlock)
		{
			bCanConverse = False;
			MakePawnIgnored(true);
			BlockReactions(true);
		}
		else
		{
			bCanConverse = True;
			MakePawnIgnored(true);
			BlockReactions(false);
		}

		// Check if the current state is "WaitingFor", "RunningTo" or "GoingTo", in which case
		// we want the orders to be 'Standing' after the conversation is over.  UNLESS the
		// ScriptedPawn was going somewhere else (OrderTag != '')

		if (((Orders == 'WaitingFor') || (Orders == 'RunningTo') || (Orders == 'GoingTo')) && (OrderTag == ''))
			SetOrders('Standing');

		bConversationEndedNormally = False;
		bInConversation = True;
		bStasis = False;
		SetDistress(false);
		SeekPawn = None;
	}

	function EndState()
	{
		local MPCHuman player;
		local bool         bForcePlay;

		bForcePlay = false;
		player = MPCHuman(GetPlayerPawn());
		if (player != None)
			if (player.mpcConPlay != None)
				bForcePlay = player.mpcConPlay.GetForcePlay();

		bConvEndState = true;
		if (!bForcePlay && (bConversationEndedNormally != True))
			player.AbortConversation();
		bConvEndState = false;
		ResetConvOrders();

		StopBlendAnims();
		bInterruptState = true;
		bCanConverse    = True;
		MakePawnIgnored(false);
		ResetReactions();
		bStasis = True;
		ConversationActor = None;
	}
}


// ----------------------------------------------------------------------
// state FirstPersonConversation
//
// Just sit here until the conversation is over
// ----------------------------------------------------------------------

state FirstPersonConversation
{


	function BeginState()
	{
		local MPCHuman dxPlayer;
		local bool         bBlock;

		ResetConvOrders();
		EnableCheckDestLoc(false);

		dxPlayer = MPCHuman(GetPlayerPawn());

		// 1st-person conversations will no longer block;
		// left old code in here in case people change their minds :)

		bBlock = false;

		bInterruptState = True;
		if (bBlock)
		{
			bCanConverse = False;
			MakePawnIgnored(true);
			BlockReactions(true);
		}
		else
		{
			bCanConverse = True;
			MakePawnIgnored(false);
			if ((dxPlayer != None) && (dxPlayer.mpcConPlay != None) &&
			    dxPlayer.mpcConPlay.con.IsSpeakingActor(dxPlayer))
				SetReactions(false, false, false, false, true, false, false, true, false, false, true, true);
			else
				ResetReactions();
		}

		bConversationEndedNormally = False;
		bInConversation = True;
		bStasis = False;
		SetDistress(false);
		SeekPawn = None;
	}

	function EndState()
	{
		local MPCHuman player;

		bConvEndState = true;
		if (bConversationEndedNormally != True)
		{
			player = MPCHuman(GetPlayerPawn());
			player.AbortConversation();
		}
		bConvEndState = false;
		ResetConvOrders();

		StopBlendAnims();
		bInterruptState = true;
		bCanConverse    = True;
		MakePawnIgnored(false);
		ResetReactions();
		bStasis = True;
		ConversationActor = None;
	}
}




// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
