//=============================================================================
// HXCoopGame
//=============================================================================
class HXCoopGame extends DeusExMPGame;

var travel HXGamePlayState GameState;

// for keeping track of level entry point
var Teleporter EntryPortal;
var bool bEntryViaPortal;

// ----------------------------------------------------------------------
// InitGame()
// ----------------------------------------------------------------------

event InitGame(string Options, out string Error)
{
	bEntryViaPortal = false;
	Super.InitGame(Options, Error);
}


// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------

function PreBeginPlay()
{
	if (GameState == none)
		GameState = spawn(class'HXGamePlayState');

	Super.PreBeginPlay();
}


// ----------------------------------------------------------------------
// Login()
// ----------------------------------------------------------------------

event PlayerPawn Login(string Portal, string Options, out string Error, class<playerpawn> SpawnClass)
{
	local Teleporter T;
	local NavigationPoint StartSpot;
	local byte InTeam;
	local DumpLocation dump;
	local HXHuman human;

	if (Portal != "")
	{
		foreach AllActors(class 'Teleporter', T)
		{
			if(string(T.Tag) ~= Portal)
			{
				EntryPortal = T;
				bEntryViaPortal = true;
				break;
			}
		}

		if (EntryPortal == none)
			Log("(WW) No Teleporter found for Tag:" $ Portal);
	}

	if ((MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
	{
		Error = TooManyPlayers;
		return None;
	}

	// enforce HXHuman players
	if (!ClassIsChildOf(SpawnClass, class'HXHuman'))
		SpawnClass = class'HXJCDentonMale';

	human = HXHuman(Super(GameInfo).Login(Portal, Options, Error, SpawnClass));

	human.ResetPlayerToDefaults();

	// If we're traveling across a map on the same mission, 
	// nuke the player's crap and 
/*
	if ((human != None) && (!HasOption(Options, "Loadgame")))
	{
		human.ResetPlayerToDefaults();

		dump = human.CreateDumpLocationObject();

		if ((dump != None) && (dump.HasLocationBeenSaved()))
		{
			dump.LoadLocation();

			human.Pause();
			human.SetLocation(dump.currentDumpLocation.Location);
			human.SetRotation(dump.currentDumpLocation.ViewRotation);
			human.ViewRotation = dump.currentDumpLocation.ViewRotation;
			human.ClientSetRotation(dump.currentDumpLocation.ViewRotation);

			CriticalDelete(dump);
		}
		else
		{
*/
			InTeam = GetIntOption(Options, "Team", 0); // Multiplayer now, defaults to Team_Unatco=0

			if (Level.NetMode == NM_Standalone)			
				StartSpot = FindPlayerStart(None, InTeam, Portal);
			else
				StartSpot = FindPlayerStart(human, InTeam, Portal);

			human.SetLocation(StartSpot.Location);
			human.SetRotation(StartSpot.Rotation);
			human.ViewRotation = StartSpot.Rotation;
			human.ClientSetRotation(human.Rotation);
/*
		}
	}
*/
	human.bAutoActivate = true;

	return human;
}


// ----------------------------------------------------------------------
// FindPlayerStart()
// ----------------------------------------------------------------------

function NavigationPoint FindPlayerStart(Pawn Player, optional byte InTeam, optional string incomingName)
{
	local PlayerStart Dest;
	local Teleporter Tel;

	if (bEntryViaPortal)
		return EntryPortal;
	else
		return Super.FindPlayerStart(Player, InTeam);
}


// ----------------------------------------------------------------------
// CheckPlayerWindow()
// allow our own root window
// ----------------------------------------------------------------------
function CheckPlayerWindow(PlayerPawn CheckPlayer)
{
	if (DeusExPlayer(CheckPlayer) != None)
		DeusExPlayer(CheckPlayer).VerifyRootWindow(Class'HXCoop.HXCoopRootWindow');
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	DefaultPlayerClass=Class'HXCoop.HXJCDentonMale'
}
