//=============================================================================
// HXAmmo10mm
//=============================================================================
class HXAmmo10mm extends HXCoopAmmo;

// ----------------------------------------------------------------------
// UseAmmo()
// ----------------------------------------------------------------------

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
    if ((Level.Game.isA('DeusExMPGame') && (!DeusExMPGame(Level.Game).bSpawnEffects)))
    {
       shell = None;
    }
    else
    {
       if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
          shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
       else
          shell = spawn(class'ShellCasing',,, Owner.Location + offset);
    }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bShowInfo=True
	AmmoAmount=6
	MaxAmmo=150
	ItemName="10mm Ammo"
	ItemArticle="some"
	PickupViewMesh=LodMesh'DeusExItems.Ammo10mm'
	Icon=Texture'DeusExUI.Icons.BeltIconAmmo10mm'
	largeIcon=Texture'DeusExUI.Icons.LargeIconAmmo10mm'
	largeIconWidth=44
	largeIconHeight=31
	Description="With their combination of high stopping power and low recoil, pistols chambered for the 10mm round have become the sidearms of choice for paramilitary forces around the world."
	beltDescription="10MM AMMO"
	Mesh=LodMesh'DeusExItems.Ammo10mm'
	CollisionRadius=8.500000
	CollisionHeight=3.770000
	bCollideActors=True
}
