//=============================================================================
// HXBaseMutator
//=============================================================================
class HXBaseMutator extends HXMutator;

var int counter;

// ----------------------------------------------------------------------
// IsRelevant()
// modified to skip long mutator chain for frequently spawned actors
// ----------------------------------------------------------------------

function bool IsRelevant(Actor Other, out byte bSuperRelevant)
{
	local bool bResult;

	if (Other.isA('Projectile') || Other.isA('Decal') || Other.isA('Effects'))
		return true;

	// allow mutators to remove actors
	bResult = CheckReplacement(Other, bSuperRelevant);
	if ( bResult && (NextMutator != None) )
		bResult = NextMutator.IsRelevant(Other, bSuperRelevant);

	if (!bResult)
	{
		Log("(NN) Spawned " $ Other.Class $ " Replacement");
		counter++;
	}

	return bResult;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	counter=0
}
