//=============================================================================
// HXCoopGame
//=============================================================================
class HXCoopGame extends DeusExMPGame;

var travel HXGamePlayState GameState;

// for keeping track of level entry point
var Teleporter EntryPortal;
var bool bEntryViaPortal;

var class<Mutator> Mutators[16];

var float CumulativeTime;
var float LastTimeLog;

// ----------------------------------------------------------------------
// InitGame()
// ----------------------------------------------------------------------

event InitGame(string Options, out string Error)
{
	local int i;

	Super.InitGame(Options, Error);

	// add my mutators here
	for (i = 0; i < ArrayCount(Mutators); i++)
	{
		if (Mutators[i] == None)
			continue;

		BaseMutator.AddMutator(Spawn(Mutators[i]));
		log("Add mutator " $ Mutators[i]);
	}
}



// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------

function PreBeginPlay()
{	
	if (GameState == none)
		GameState = spawn(class'HXGamePlayState');

	Super.PreBeginPlay();
}


// ----------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------

function PostBeginPlay()
{
	Super.PostBeginPlay();

	Log("(NN) Replaced " $ HXBaseMutator(BaseMutator).counter $ " actors");
}


// ----------------------------------------------------------------------
// Login()
// ----------------------------------------------------------------------

event PlayerPawn Login(string Portal, string Options, out string Error, class<playerpawn> SpawnClass)
{
	local NavigationPoint StartSpot;
	local byte InTeam;
	//local DumpLocation dump;
	local HXHuman human;

	if ((MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
	{
		Error = TooManyPlayers;
		return None;
	}

	// enforce HXHuman players
	if (!ClassIsChildOf(SpawnClass, class'HXHuman'))
		SpawnClass = class'HXJCDentonMale';

	human = HXHuman(Super(GameInfo).Login(Portal, Options, Error, SpawnClass));

	human.ResetPlayerToDefaults();

	// If we're traveling across a map on the same mission, 
	// nuke the player's crap and 
/*
	if ((human != None) && (!HasOption(Options, "Loadgame")))
	{
		human.ResetPlayerToDefaults();

		dump = human.CreateDumpLocationObject();

		if ((dump != None) && (dump.HasLocationBeenSaved()))
		{
			dump.LoadLocation();

			human.Pause();
			human.SetLocation(dump.currentDumpLocation.Location);
			human.SetRotation(dump.currentDumpLocation.ViewRotation);
			human.ViewRotation = dump.currentDumpLocation.ViewRotation;
			human.ClientSetRotation(dump.currentDumpLocation.ViewRotation);

			CriticalDelete(dump);
		}
		else
		{
*/
			InTeam = GetIntOption(Options, "Team", 0); // Multiplayer now, defaults to Team_Unatco=0

			if (Level.NetMode == NM_Standalone)			
				StartSpot = FindPlayerStart(None, InTeam, Portal);
			else
				StartSpot = FindPlayerStart(human, InTeam, Portal);

			human.SetLocation(StartSpot.Location);
			human.SetRotation(StartSpot.Rotation);
			human.ViewRotation = StartSpot.Rotation;
			human.ClientSetRotation(human.Rotation);
/*
		}
	}
*/
	human.bAutoActivate = true;

	return human;
}


// ----------------------------------------------------------------------
// CheckPlayerWindow()
// allow our own root window
// ----------------------------------------------------------------------

function CheckPlayerWindow(PlayerPawn CheckPlayer)
{
	if (DeusExPlayer(CheckPlayer) != None)
		DeusExPlayer(CheckPlayer).VerifyRootWindow(Class'HXCoop.HXCoopRootWindow');
}



// ----------------------------------------------------------------------
// ShouldRespawn()
// ----------------------------------------------------------------------

function bool ShouldRespawn( actor Other )
{
	// hack for ChargedPickup... *for now*
	if (Other.isA('ChargedPickup'))
		return true;

	return false;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	DefaultPlayerClass=Class'HXCoop.HXJCDentonMale'
	MutatorClass=Class'HXCoop.HXBaseMutator'
	Mutators(0)=HXCoop.HXTriggerMutator
	Mutators(1)=HXCoop.HXTeleporterMutator
	Mutators(2)=HXCoop.HXMissionScriptMutator
	Mutators(3)=HXCoop.HXDeusExMoverMutator
	Mutators(4)=HXCoop.HXElectronicDevicesMutator
	Mutators(5)=HXCoop.HXDeusExCarcassMutator
	Mutators(6)=HXCoop.HXHumanCivilianMutator
	Mutators(7)=HXCoop.HXHumanMilitaryMutator
	Mutators(8)=HXCoop.HXHumanThugMutator
	Mutators(9)=//HXCoop.HXAnimalMutator
	Mutators(11)=HXCoop.HXRobotMutator
	Mutators(12)=HXCoop.HXMissionHackMutator
	Mutators(13)=HXCoop.HXInventoryMutator
	Mutators(14)=
	Mutators(15)=
}
