//=============================================================================
// HXDataLinkPlayer
//=============================================================================
class HXDataLinkPlayer extends Actor;

var HXDataLinkEventDisposer disposer;
var HXDataLinkTrack tracklist;
var HXHuman human;

var bool bPlaying;


// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------

event PreBeginPlay()
{
	Super.PreBeginPlay();

	disposer = spawn(class'HXDataLinkEventDisposer');
	disposer.dataLinkPlayer = self;

	bPlaying = false;
}


// ----------------------------------------------------------------------
// Play()
// ----------------------------------------------------------------------

function Play()
{
	local HXDataLinkTrack track;

	if (bPlaying || tracklist == none)
		return;

	bPlaying = true;

	track = tracklist;

	disposer.con					= track.con;
	disposer.current			= track.con.eventList;
	disposer.invokerName	= track.invokerName;

	disposer.GotoState('Starting');
}


// ----------------------------------------------------------------------
// DisposeFinished()
// ----------------------------------------------------------------------

function DisposeFinished()
{
	local HXDataLinkTrack track;

	track = tracklist;

	// remove first track from list and destroy it
	tracklist = track.next;
	track.Destroy();

	bPlaying = false;

	if (tracklist != none)
		Play();

}


// ----------------------------------------------------------------------
// QueueTrack()
// ----------------------------------------------------------------------

function QueueTrack(HXDataLinkTrack track)
{
	if (tracklist != none)
		tracklist.QueueTrack(track);
	else
		tracklist = track;

	if (!bPlaying)
		Play(); // play track instantly if idle
	else
		human.ClientDataLinkWinMessageQueued();
}


// ----------------------------------------------------------------------
// IsConQueued()
// ----------------------------------------------------------------------

function bool IsConQueued(Conversation con)
{
	local HXDataLinkTrack track;
	
	if (con == none)
		return false;

	track = tracklist;

	while (track != none)
	{
		if (track.con == con)
			return true;

		track = track.next;
	}

	return false;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bHidden=true
}
