//=============================================================================
// HXElectronicDevicesMutator
//=============================================================================
class HXElectronicDevicesMutator extends HXMutator;


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Actor A;

	if (!Other.isA('ElectronicDevices') || Other.isA('HXHackableDevices'))
		return true;

	if (Other.isA('HackableDevices'))
	{
		if (Other.isA('Keypad'))
		{
			if (Other.isA('Keypad1'))
				A = spawn(class'HXKeypad1', Other.Owner, Other.tag, Other.Location, Other.Rotation);
			else if (Other.isA('Keypad2'))
				A = spawn(class'HXKeypad2', Other.Owner, Other.tag, Other.Location, Other.Rotation);
			else //Keypad3
				A = spawn(class'HXKeypad3', Other.Owner, Other.tag, Other.Location, Other.Rotation);

			if (A == none)
			{
				Log("(EE) Spawning Keypad Replacement failed");
				return false;
			}

			CopyKeypadVars(Keypad(Other), HXKeypad(A));
		}
	
	}

	return true;
}



// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
