//=============================================================================
// HXGoalCompleteTrigger
//=============================================================================
class HXGoalCompleteTrigger extends Trigger;

// Sets a goal as completed when touched or triggered
// Set bCollideActors to False to make it triggered

var() name goalName;


// ----------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------

function Trigger(Actor Other, Pawn Instigator)
{
	Super.Trigger(Other, Instigator);

	HXCoopGame(Level.Game).GameState.GoalCompleted(goalName,
		HXHuman(Instigator).PlayerReplicationInfo.PlayerName);
}


// ----------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------

function Touch(Actor Other)
{
	local DeusExGoal goal;
	local DeusExPlayer player;

	Super.Touch(Other);

	if (IsRelevant(Other))
		HXCoopGame(Level.Game).GameState.GoalCompleted(goalName,
			HXHuman(Other).PlayerReplicationInfo.PlayerName);
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bTriggerOnceOnly=True
}
