//=============================================================================
// HXHUDKeypadWindow
//=============================================================================
class HXHUDKeypadWindow extends HUDKeypadWindow;

var HXKeypad hxKeypadOwner;


// ----------------------------------------------------------------------
// DestroyWindow()
// ----------------------------------------------------------------------

event DestroyWindow()
{
	Super.DestroyWindow();

	//keypadOwner.keypadwindow = None;
}


// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{
	if (!bFirstFrameDone)
	{
		SetCursorPos(width, height);
		bFirstFrameDone = True;

		if (bInstantSuccess)
		{
			inputCode = hxkeypadOwner.validCode;
			ValidateCode();
		}
	}
}


// ----------------------------------------------------------------------
// PressButton()
// ----------------------------------------------------------------------

function PressButton(int num)
{
	local sound tone;

	if (bWait)
		return;

	if (Len(inputCode) < 16)
	{
		inputCode = inputCode $ IndexToString(num);
		switch (num)
		{
			case 0:		tone = sound'Touchtone1'; break;
			case 1:		tone = sound'Touchtone2'; break;
			case 2:		tone = sound'Touchtone3'; break;
			case 3:		tone = sound'Touchtone4'; break;
			case 4:		tone = sound'Touchtone5'; break;
			case 5:		tone = sound'Touchtone6'; break;
			case 6:		tone = sound'Touchtone7'; break;
			case 7:		tone = sound'Touchtone8'; break;
			case 8:		tone = sound'Touchtone9'; break;
			case 9:		tone = sound'Touchtone10'; break;
			case 10:	tone = sound'Touchtone0'; break;
			case 11:	tone = sound'Touchtone11'; break;
		}

		player.PlaySound(tone, SLOT_None);
	}

	GenerateKeypadDisplay();
	winText.SetTextColor(colHeaderText);
	winText.SetText(msgEnterCode);

	if (Len(inputCode) == Len(hxkeypadOwner.validCode))
		ValidateCode();
}


// ----------------------------------------------------------------------
// ValidateCode()
// ----------------------------------------------------------------------

function ValidateCode()
{
	local Actor A;
	local int i;

	if (inputCode == hxkeypadOwner.validCode)
	{
		if (hxkeypadOwner.Event != '')
		{
			if (hxkeypadOwner.bToggleLock)
			{
				// Toggle the locked/unlocked state of the DeusExMover
            HXHuman(player).HXKeypadToggleLocks(hxkeypadOwner);
			}
			else
			{
				// Trigger the successEvent
            HXHuman(player).HXKeypadRunEvents(hxkeypadOwner, True);
			}
		}

		// UnTrigger event (if used)
      // DEUS_EX AMSD Export to player(and then to keypad), for multiplayer.
      HXHuman(player).HXKeypadRunUntriggers(hxkeypadOwner);

		player.PlaySound(hxkeypadOwner.successSound, SLOT_None);
		winText.SetTextColor(colGreen);
		winText.SetText(msgAccessGranted);
	}
	else
	{
		//Trigger failure event
      if (hxkeypadOwner.FailEvent != '')      
         HXHuman(player).HXKeypadRunEvents(hxkeypadOwner, False);

		player.PlaySound(hxkeypadOwner.failureSound, SLOT_None);
		winText.SetTextColor(colRed);
		winText.SetText(msgAccessDenied);
	}

	bWait = True;
	AddTimer(1.0, False, 0, 'KeypadDelay');
}


// ----------------------------------------------------------------------
// KeypadDelay()
// ----------------------------------------------------------------------

function KeypadDelay(int timerID, int invocations, int clientData)
{
	bWait = False;

	// if we entered a valid code, get out
	if (inputCode == hxkeypadOwner.validCode)
		root.PopWindow();
	else
	{
		inputCode = "";
		GenerateKeypadDisplay();
		winText.SetTextColor(colHeaderText);
		winText.SetText(msgEnterCode);
	}
}


// ----------------------------------------------------------------------
// GenerateKeypadDisplay()
//
// Generate the keypad's display
// ----------------------------------------------------------------------

function GenerateKeypadDisplay()
{
	local int i;

	msgEnterCode = "";

	for (i=0; i<Len(hxkeypadOwner.validCode); i++)
	{
		if (i == Len(inputCode))
			msgEnterCode = msgEnterCode $ "|p5";
		msgEnterCode = msgEnterCode $ "~";
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
