//=============================================================================
// HXHuman
//=============================================================================
class HXHuman extends Human
	abstract;

struct SGoalCache
{
	var DeusExGoal FirstGoal;	
	var DeusExGoal LastGoal;
};

var SGoalCache GoalCache;
var HXDataLinkPlayer dataLinkPlayer;

var localized String EndTransmission;

// ----------------------------------------------------------------------
// network replication
// ----------------------------------------------------------------------

replication
{
	// server to client
	reliable if (Role == ROLE_Authority)

		// GoalCache
		GoalCacheAddGoal, GoalCacheFindGoal, GoalCacheGoalCompleted,
		GoalCacheResetGoals, GoalCacheDeleteGoal, GoalCacheDeleteAllGoals,

		// DataLink UI
		ClientDataLinkWinCreate, ClientDataLinkWinDisplayText,
		ClientDataLinkWinShowDatalinkIcon, ClientDataLinkWinReset,
		ClientDataLinkWinMessageQueued, ClientDataLinkWinSetEndText,
		ClientDataLinkWinShowWinName, ClientDataLinkWinDestroy;

  reliable if ((Role == ROLE_Authority) && (bNetOwner))
		ActivateHXKeyPadWindow;

	// client to server
	reliable if (Role < ROLE_Authority)
		HXKeypadRunUntriggers, HXKeypadRunEvents, HXKeypadToggleLocks;

}


// ----------------------------------------------------------------------
// ResetPlayerToDefaults()
//
// Resets all travel variables to their defaults
// ----------------------------------------------------------------------

function ResetPlayerToDefaults()
{
	local inventory anItem;
	local inventory nextItem;

	// reset the image linked list
	//FirstImage = None;

	//if (DeusExRootWindow(rootWindow) != None)
		//DeusExRootWindow(rootWindow).ResetFlags();

	// Remove all the keys from the keyring before
	// it gets destroyed

	if (KeyRing != None)
	{
		KeyRing.RemoveAllKeys();
    if ((Role == ROLE_Authority) && (Level.NetMode != NM_Standalone))
    {
       KeyRing.ClientRemoveAllKeys();
    }
		KeyRing = None;
	}

	while (Inventory != None)
	{
		anItem = Inventory;
		DeleteInventory(anItem);
		anItem.Destroy();
	}

	// Clear object belt
	if (DeusExRootWindow(rootWindow) != None)
		DeusExRootWindow(rootWindow).hud.belt.ClearBelt();

	// clear the notes and the goals
	//DeleteAllNotes();
	//DeleteAllGoals();

	// Nuke the history
	//ResetConversationHistory();

	// Other defaults
	//Credits = Default.Credits;
	//Energy  = Default.Energy;
	//SkillPointsTotal = Default.SkillPointsTotal;
	//SkillPointsAvail = Default.SkillPointsAvail;

	SetInHandPending(None);
	SetInHand(None);

	bInHandTransition = False;

	RestoreAllHealth();
	//ClearLog();

	// Reset save count/time
	//saveCount = 0;
	//saveTime  = 0.0;

	// Reinitialize all subsystems we've just nuked
	InitializeSubSystems();

	// Give starting inventory.
  GiveInitialInventory();

	// get all keys found
	HXCoopGame(Level.Game).GameState.GetAllKeys(self);

	NintendoImmunityEffect(true);
}


// ------------------------------------------------------------------------
// GiveInitialInventory()
// defaults now to sp initial inventory
// ------------------------------------------------------------------------

function GiveInitialInventory()
{
	local DeusExLevelInfo Info;
	local Inventory anItem;
	local bool bTraining;

	foreach AllActors(class'DeusExLevelInfo', Info)
		bTraining = (Info.missionNumber == 0);

	// Give the player a pistol and a prod
	if (!bTraining)
	{
		anItem = Spawn(class'HXWeaponPistol');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem.Destroy();

		anItem = Spawn(class'HXWeaponProd');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem.Destroy();

		anItem = Spawn(class'MedKit');
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
		anItem.Destroy();
	}
}


// ----------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------

event PreBeginPlay()
{
	Super.PreBeginPlay();

	if (dataLinkPlayer == none)
	{
		dataLinkPlayer = spawn(class'HXDataLinkPlayer');
		dataLinkPlayer.human = self;
	}
}


// ----------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------

function PostPostBeginPlay()
{
	Super(PlayerPawnExt).PostPostBeginPlay();

	// do not bind datalinks any more to player
	//ConBindEvents();

	// Restore colors that the user selected (as opposed to those
	// stored in the savegame)
	ThemeManager.SetMenuThemeByName(MenuThemeName);
	ThemeManager.SetHUDThemeByName(HUDThemeName);

	if ((Level.NetMode != NM_Standalone) && ( killProfile == None ))
		killProfile = Spawn(class'KillerProfile', Self);
}


// ----------------------------------------------------------------------
// QueueDataLink()
//
// Locates and starts the DataLink passed in (the new se'hx'y way)
// ----------------------------------------------------------------------

function bool QueueDataLink
(
	string datalinkName,
	string invokerName,
	optional HXDataLinkTrigger datalinkTrigger
)
{
	local ConListItem conListItem;
	local Conversation con;
	local HXDataLinkTrack track;

	// find conversation
	conListItem = ConListItem(HXCoopGame(Level.Game).GameState.bindDeco.conListItems);

	while (conListItem != none)
	{
		if (Caps(datalinkName) == Caps(conListItem.con.conName))
		{
			// ok this is the conversation we are searching for
			con = conListItem.con;
			break;
		}
		conListItem = conListItem.next;	
	}

	if (con == none || dataLinkPlayer.IsConQueued(con))
		return false;

	track = spawn(class'HXDataLinkTrack');
	track.con = con;
	track.invokerName = invokerName;
	
	dataLinkPlayer.QueueTrack(track);

	return true;
}


// ----------------------------------------------------------------------
// StartFrobConversation()
// ----------------------------------------------------------------------

function StartFrobConversation()
{
	
}


// ----------------------------------------------------------------------
// ClientDataLinkWinCreate()
// ----------------------------------------------------------------------

function ClientDataLinkWinCreate()
{
	HXCoopRootWindow(rootWindow).hud.CreateInfoLinkWindow();
	HXCoopRootWindow(rootWindow).hud.infoLink.ShowTextCursor(false);
	HXCoopRootWindow(rootWindow).hud.infoLink.ShowDatalinkIcon(false);
}


// ----------------------------------------------------------------------
// ClientDataLinkWinDisplayText()
// ----------------------------------------------------------------------

function ClientDataLinkWinDisplayText(string text)
{
	HXCoopRootWindow(rootWindow).hud.infoLink.DisplayText(text);
}


// ----------------------------------------------------------------------
// ClientDataLinkWinShowDatalinkIcon()
// ----------------------------------------------------------------------

function ClientDataLinkWinShowDatalinkIcon(bool bShow)
{
	HXCoopRootWindow(rootWindow).hud.infoLink.ShowDatalinkIcon(bShow);
}


// ----------------------------------------------------------------------
// ClientDataLinkWinReset()
// ----------------------------------------------------------------------

function ClientDataLinkWinReset(string dname, string portrait, string speech)
{
	local HXHUDInfoLinkDisplay infolink;

	infolink = HXHUDInfoLinkDisplay(HXCoopRootWindow(rootWindow).hud.infoLink);
	infolink.ClearScreen();
	infolink.SetSpeakerNameAndPortrait(dname, portrait);
	infolink.ShowPortrait();
	infoLink.ShowTextCursor(true);
	infolink.DisplayText(speech);
}


// ----------------------------------------------------------------------
// ClientDataLinkWinMessageQueued()
// ----------------------------------------------------------------------

function ClientDataLinkWinMessageQueued()
{
	HXCoopRootWindow(rootWindow).hud.infoLink.MessageQueued(true);
}


// ----------------------------------------------------------------------
// ClientDataLinkWinSetEndText()
// ----------------------------------------------------------------------

function ClientDataLinkWinSetEndText()
{
	HXCoopRootWindow(rootWindow).hud.infoLink.winName.SetText(EndTransmission);
}


// ----------------------------------------------------------------------
// ClientDataLinkWinShowWinName()
// ----------------------------------------------------------------------

function ClientDataLinkWinShowWinName(bool bShow)
{
	HXCoopRootWindow(rootWindow).hud.infoLink.winName.Show(bShow);
}


// ----------------------------------------------------------------------
// ClientDataLinkWinDestroy()
// ----------------------------------------------------------------------

function ClientDataLinkWinDestroy()
{
	HXCoopRootWindow(rootWindow).hud.DestroyInfoLinkWindow();
}




// ----------------------------------------------------------------------
// PickupNanoKey()
// ----------------------------------------------------------------------

function PickupNanoKey(NanoKey newKey)
{
	HXCoopGame(Level.Game).GameState.AddNanoKey(newKey.KeyID, newKey.Description, self);
}




// ----------------------------------------------------------------------
// ActivateHXKeypadWindow()
// ----------------------------------------------------------------------

function ActivateHXKeypadWindow(HXKeypad KPad, bool bHacked)
{
   KPad.ActivateKeypadWindow(Self, bHacked);
}

// ----------------------------------------------------------------------
// HXKeypadRunUntriggers()
// ----------------------------------------------------------------------

function HXKeypadRunUntriggers(HXKeypad KPad)
{
   KPad.RunUntriggers(Self);
}

// ----------------------------------------------------------------------
// HXKeypadRunEvents()
// ----------------------------------------------------------------------

function HXKeypadRunEvents(HXKeypad KPad, bool bSuccess)
{
   KPad.RunEvents(Self, bSuccess);
}

// ----------------------------------------------------------------------
// HXKeypadToggleLocks()
// ----------------------------------------------------------------------

function HXKeypadToggleLocks(HXKeypad KPad)
{
   KPad.ToggleLocks(Self);
}



// ----------------------------------------------------------------------
// GoalCacheAddGoal()
// ----------------------------------------------------------------------

function GoalCacheAddGoal(name goalName, bool bPrimaryGoal, string goalText)
{
	local DeusExGoal newGoal;

	// First check to see if this goal already exists.  If so, we'll just
	// return it.  Otherwise create a new goal

	newGoal = GoalCacheFindGoal(goalName);

	if (newGoal == none)
	{
		newGoal = new(self) class'DeusExGoal';
		newGoal.SetName(goalName);
		newGoal.SetText(goalText);
		newGoal.SetPrimaryGoal(bPrimaryGoal);

		// Insert goal at the Top so goals are displayed in 
		// Newest order first.
		if (GoalCache.FirstGoal == None)
			GoalCache.LastGoal  = newGoal;
		else
			newGoal.next = GoalCache.FirstGoal;

		GoalCache.FirstGoal    = newGoal;
	}	
}


// ----------------------------------------------------------------------
// GoalCacheFindGoal()
// ----------------------------------------------------------------------

function DeusExGoal GoalCacheFindGoal(Name goalName)
{
	local DeusExGoal goal;

	goal = GoalCache.FirstGoal;

	while(goal != None)
	{
		if (goalName == goal.goalName)
			break;

		goal = goal.next;
	}

	return goal;
}


// ----------------------------------------------------------------------
// GoalCacheGoalCompleted()
// ----------------------------------------------------------------------

function GoalCacheGoalCompleted(Name goalName)
{
	local DeusExGoal goal;

	// Loop through all the goals until we hit the one we're 
	// looking for.
	goal = GoalCacheFindGoal(goalName);

	if ( goal != None )
	{
		// Only mark a goal as completed once!
		if (!goal.IsCompleted())
			goal.SetCompleted();
	}
}


// ----------------------------------------------------------------------
// GoalCacheDeleteGoal()
// ----------------------------------------------------------------------

function GoalCacheDeleteGoal(DeusExGoal goalToDelete)
{
	local DeusExGoal goal;
	local DeusExGoal previousGoal;

	goal = GoalCache.FirstGoal;
	previousGoal = None;

	while(goal != None)
	{
		if (goal == goalToDelete)
		{
			if (goal == FirstGoal)
				GoalCache.FirstGoal = goal.next;

			if (goal == LastGoal)
				GoalCache.LastGoal = previousGoal;

			if (previousGoal != None)
				previousGoal.next = goal.next;

			goal = None;
			break;
		}
		previousGoal = goal;
		goal = goal.next;
	}
}


// ----------------------------------------------------------------------
// GoalCacheDeleteAllGoals()
// ----------------------------------------------------------------------

function GoalCacheDeleteAllGoals()
{
	local DeusExGoal goal;
	local DeusExGoal goalNext;

	goal = GoalCache.FirstGoal;

	while(goal != None)
	{
		goalNext = goal.next;
		DeleteGoal(goal);
		goal = goalNext;
	}

	GoalCache.FirstGoal = None;
	GoalCache.LastGoal = None;
}


// ----------------------------------------------------------------------
// GoalCacheResetGoals()
// ----------------------------------------------------------------------

function GoalCacheResetGoals()
{
	local DeusExGoal goal;
	local DeusExGoal goalNext;

	goal = GoalCache.FirstGoal;

	while(goal != None)
	{
		goalNext = goal.next;
		if ((!goal.IsPrimaryGoal()) || (goal.IsPrimaryGoal() && goal.IsCompleted()))
			DeleteGoal(goal);
		goal = goalNext;
	}
}


// ----------------------------------------------------------------------
// ShowInventoryWindow()
// ----------------------------------------------------------------------

exec function ShowInventoryWindow()
{
	if (RestrictInput())
		return;

	InvokeUIScreen(Class'HXPersonaScreenInventory');
}

// ----------------------------------------------------------------------
// ShowSkillsWindow()
// ----------------------------------------------------------------------

exec function ShowSkillsWindow()
{
	if (RestrictInput())
		return;

	InvokeUIScreen(Class'HXPersonaScreenSkills');
}

// ----------------------------------------------------------------------
// ShowHealthWindow()
// ----------------------------------------------------------------------

exec function ShowHealthWindow()
{
	if (RestrictInput())
		return;

	InvokeUIScreen(Class'HXPersonaScreenHealth');
}

// ----------------------------------------------------------------------
// ShowImagesWindow()
// ----------------------------------------------------------------------

exec function ShowImagesWindow()
{
	if (RestrictInput())
		return;

	InvokeUIScreen(Class'HXPersonaScreenImages');
}

// ----------------------------------------------------------------------
// ShowConversationsWindow()
// ----------------------------------------------------------------------

exec function ShowConversationsWindow()
{
	if (RestrictInput())
		return;
   
	InvokeUIScreen(Class'HXPersonaScreenConversations');
}

// ----------------------------------------------------------------------
// ShowAugmentationsWindow()
// ----------------------------------------------------------------------

exec function ShowAugmentationsWindow()
{
	if (RestrictInput())
		return;

	InvokeUIScreen(Class'HXPersonaScreenAugmentations');
}

// ----------------------------------------------------------------------
// ShowGoalsWindow()
// ----------------------------------------------------------------------

exec function ShowGoalsWindow()
{
	if (RestrictInput())
		return;
   
	InvokeUIScreen(Class'HXPersonaScreenGoals');
}

// ----------------------------------------------------------------------
// ShowLogsWindow()
// ----------------------------------------------------------------------

exec function ShowLogsWindow()
{
	if (RestrictInput())
		return;

	InvokeUIScreen(Class'HXPersonaScreenLogs');
}




// ----------------------------------------------------------------------
// ShowMainMenu()
// ----------------------------------------------------------------------

exec function ShowMainMenu()
{
	local DeusExRootWindow root;
	local DeusExLevelInfo info;
	local MissionEndgame Script;

	if (bIgnoreNextShowMenu)
	{
		bIgnoreNextShowMenu = False;
		return;
	}

	info = GetLevelInfo();

	// Special case baby!
	// 
	// If the Intro map is loaded and we get here, that means the player
	// pressed Escape and we want to either A) start a new game 
	// or B) return to the dx.dx screen.  Either way we're going to 
	// abort the Intro by doing this. 
	//
	// If this is one of the Endgames (which have a mission # of 99)
	// then we also want to call the Endgame's "FinishCinematic" 
	// function

	// force the texture caches to flush
	ConsoleCommand("FLUSH");

	if ((info != None) && (info.MissionNumber == 98)) 
	{
		bIgnoreNextShowMenu = True;
		PostIntro();
	}
	else if ((info != None) && (info.MissionNumber == 99))
	{
		foreach AllActors(class'MissionEndgame', Script)
			break;

		if (Script != None)
			Script.FinishCinematic();
	}
	else
	{
		root = DeusExRootWindow(rootWindow);
		if (root != None)
			root.InvokeMenu(Class'HXMenuMain');
	}
}



// ----------------------------------------------------------------------
// MultiplayerTick()
// Not the greatest name, handles single player ticks as well.  Basically
// anything tick style stuff that should be propagated to the server gets
// propagated as this one function call.
// ----------------------------------------------------------------------

function MultiplayerTick(float DeltaTime)
{
	local int burnTime;
	local float augLevel;

	Super(PlayerPawn).MultiplayerTick(DeltaTime);

	//If we've just put away items, reset this.
	if ((LastInHand != InHand) && (Level.Netmode == NM_Client) && (inHand == None))
	{
		ClientInHandPending = None;
	}

	LastInHand = InHand;
   
	if ((PlayerIsClient()) || (Level.NetMode == NM_ListenServer))
	{
		if ((ShieldStatus != SS_Off) && (DamageShield == None))
			DrawShield();
		if ((NintendoImmunityTimeLeft > 0.0) && ( InvulnSph == None ))
			DrawInvulnShield();

		// i *really* don't like this
		if (Style != STY_Translucent)
			CreateShadow();
		else
			KillShadow();
	}

	if (Role < ROLE_Authority)
		return;

	UpdateInHand();

	UpdatePoison(DeltaTime);

	if (lastRefreshTime < 0)
		lastRefreshTime = 0;

	lastRefreshTime = lastRefreshTime + DeltaTime;

	if (bOnFire)
	{
		burnTime = Class'HXWeaponFlamethrower'.Default.BurnTime;
		burnTimer += deltaTime;
		if (burnTimer >= burnTime)
			ExtinguishFire();
	}
  
	if (lastRefreshTime < 0.25)
		return;

	if (ShieldTimer > 0)
		ShieldTimer = ShieldTimer - lastRefreshTime;

	if (ShieldStatus == SS_Fade)
		ShieldStatus = SS_Off;

	if (ShieldTimer <= 0)
	{
		if (ShieldStatus == SS_Strong)
			ShieldStatus = SS_Fade;
	}

	// for *now* check if we have an AugSystem

	if (AugmentationSystem != none)
	{
		// If we have a drone active (post-death etc) and we're not using the aug, kill it off
		augLevel = AugmentationSystem.GetAugLevelValue(class'AugDrone');
		if (( aDrone != None ) && (augLevel == -1.0))
			aDrone.TakeDamage(100, None, aDrone.Location, vect(0,0,0), 'EMP');
	}

	if (Level.Timeseconds > ServerTimeLastRefresh)
	{
		SetServerTimeDiff( Level.Timeseconds);
		ServerTimeLastRefresh = Level.Timeseconds + 10.0;
	}
	
	MaintainEnergy(lastRefreshTime);

	//UpdateTranslucency(lastRefreshTime); *disabled*
	if ( bNintendoImmunity )
	{
		NintendoImmunityTimeLeft = NintendoImmunityTime - Level.Timeseconds;
		if ( Level.Timeseconds > NintendoImmunityTime )
			NintendoImmunityEffect( False );
	}
	RepairInventory();
	lastRefreshTime = 0;
}


// ----------------------------------------------------------------------
// MaintainEnergy()
// ----------------------------------------------------------------------

function MaintainEnergy(float deltaTime)
{
	local Float energyUse;
	local Float energyRegen;

	// make sure we can't continue to go negative if we take damage
	// after we're already out of energy
	if (Energy <= 0)
	{
		Energy = 0;
		EnergyDrain = 0;
		EnergyDrainTotal = 0;
	}

	energyUse = 0;

	// Don't waste time doing this if the player is dead or paralyzed
	if ((!IsInState('Dying')) && (!IsInState('Paralyzed')))
	{
		if (Energy > 0)
		{
			if (AugmentationSystem != none)
			{
				// Decrement energy used for augmentations
				energyUse = AugmentationSystem.CalcEnergyUse(deltaTime);
				Energy -= EnergyUse;
			}
			
			// Calculate the energy drain due to EMP attacks
			if (EnergyDrain > 0)
			{
				energyUse = EnergyDrainTotal * deltaTime;
				Energy -= EnergyUse;
				EnergyDrain -= EnergyUse;
				if (EnergyDrain <= 0)
				{
					EnergyDrain = 0;
					EnergyDrainTotal = 0;
				}
			}
		}

		//Do check if energy is 0.  
		// If the player's energy drops to zero, deactivate 
		// all augmentations
		if (Energy <= 0)
		{
			//If we were using energy, then tell the client we're out.
			//Otherwise just make sure things are off.  If energy was
			//already 0, then energy use will still be 0, so we won't
			//spam.  DEUS_EX AMSD
			if (energyUse > 0)         
				ClientMessage(EnergyDepleted);
			Energy = 0;
			EnergyDrain = 0;
			EnergyDrainTotal = 0;

			if (AugmentationSystem != none)
				AugmentationSystem.DeactivateAll();
		}
	}
}


// ----------------------------------------------------------------------
// GetWeaponName()
// ----------------------------------------------------------------------

function GetWeaponName(DeusExWeapon w, out string name)
{
	if (w != none)
	{
		if (w.isA('HXWeaponGEPGun'))
			name = HXWeaponGEPGun(w).shortName;
		else if (w.isA('HXWeaponLAM'))
			name = HXWeaponLAM(w).shortName;
		else if (w.isA('WeaponGEPGun'))
			name = WeaponGEPGun(w).shortName;
		else if (w.isA('WeaponLAM'))
			name = WeaponLAM(w).shortName;
		else
			name = w.itemName;
	}
	else
		name = NoneString;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bBeltIsMPInventory=False
	EndTransmission="END TRANSMISSION..."
}
