//=============================================================================
// HXInventoryMutator
//=============================================================================
class HXInventoryMutator extends HXMutator;

// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local class<Inventory> InvClass;
	local Inventory Inv;

	if (!Other.isA('Inventory') || Other.isA('HXCoopWeapon') || Other.isA('HXCoopAmmo'))
		return true;

	InvClass = GetInventoryReplacementClass(class<Inventory>(Other.Class));

	if (InvClass == Other.Class)
		// we can keep this inventory
		return true;

	if (Other.Owner != none)
		// bad idea to try to replace inventory. which has an owner...
		return true;

	Inv = spawn(InvClass, Other.Owner, Other.tag, Other.Location, Other.Rotation);

	if (Inv == none)
	{
		Log("(EE) Spawning " $ Other.Class $ " replacement failed");
		return false;
	}

	return false;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
