//=============================================================================
// HXMIB
//=============================================================================
class HXMIB extends HXHumanMilitary;

// ----------------------------------------------------------------------
// SpawnCarcass()
//
// Blow up instead of spawning a carcass
// ----------------------------------------------------------------------

function Carcass SpawnCarcass()
{
	if (bStunned)
		return Super.SpawnCarcass();

	Explode();

	return None;
}


// ----------------------------------------------------------------------
// Explode()
// ----------------------------------------------------------------------

function Explode()
{
	local SphereEffect sphere;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local float explosionDamage;
	local float explosionRadius;

	explosionDamage = 100;
	explosionRadius = 256;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'LargeExplosion1', SLOT_None,,, explosionRadius*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionLarge',,, Location + 2*VRand()*CollisionRadius);

	sphere = Spawn(class'SphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks and flesh fragments
	for (i=0; i<explosionDamage/6; i++)
	{
		if (FRand() < 0.3)
			spawn(class'Rockchip',,,Location);
		else
			spawn(class'FleshFragment',,,Location);
	}

	HurtRadius(explosionDamage, explosionRadius, 'Exploded', explosionDamage*100, Location);
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	MinHealth=0.000000
	CarcassType=Class'DeusEx.MIBCarcass'
	WalkingSpeed=0.213333
	CloseCombatMult=0.500000
	GroundSpeed=180.000000
	Health=350
	HealthHead=350
	HealthTorso=350
	HealthLegLeft=350
	HealthLegRight=350
	HealthArmLeft=350
	HealthArmRight=350
	Mesh=LodMesh'DeusExCharacters.GM_Suit'
	DrawScale=1.100000
	MultiSkins(0)=Texture'DeusExCharacters.Skins.MIBTex0'
	MultiSkins(1)=Texture'DeusExCharacters.Skins.PantsTex5'
	MultiSkins(2)=Texture'DeusExCharacters.Skins.MIBTex0'
	MultiSkins(3)=Texture'DeusExCharacters.Skins.MIBTex1'
	MultiSkins(4)=Texture'DeusExCharacters.Skins.MIBTex1'
	MultiSkins(5)=Texture'DeusExCharacters.Skins.FramesTex2'
	MultiSkins(6)=Texture'DeusExCharacters.Skins.LensesTex3'
	MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
	CollisionHeight=52.250000
	BindName="MIB"
	FamiliarName="Man In Black"
	UnfamiliarName="Man In Black"
}
