//=============================================================================
// HXMenuScreenJoinLan
//=============================================================================
class HXMenuScreenJoinLan extends HXMenuScreenJoinGame;

var DeusExLocalLink Link;
var string					BeaconProduct;
var int							ServerBeaconPort;

// ----------------------------------------------------------------------
// Query()
// ----------------------------------------------------------------------

function Query()
{
	Link = GetPlayerPawn().GetEntryLevel().Spawn(class'DeusExLocalLink');

	Link.OwnerWindow = Self;
	Link.Start();
	Link.SetTimer(1.0,False);
}

// ---------------------------------------------------------------------
// QueryFinished()
// ---------------------------------------------------------------------

function QueryFinished(bool bSuccess, optional string ErrorMsg)
{
	Link.Destroy();
	Link = None;

	PingUnpingedServers();
}

// ---------------------------------------------------------------------
// ShutdownLink()
// ---------------------------------------------------------------------

function ShutdownLink()
{
	if(Link != None)
		Link.Destroy();
	Link = None;
}

// ----------------------------------------------------------------------
// GetExtraJoinOptions()
// ----------------------------------------------------------------------

function string GetExtraJoinOptions()
{
	return Super.GetExtraJoinOptions() $ "?lan";
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	Title="Start HXCoop LAN Game"
	HostMenu=Class'HXMenuScreenHostLan'
}
