//=============================================================================
// HXMenuScreenJoinNet
//=============================================================================
class HXMenuScreenJoinNet extends HXMenuScreenJoinGame;

var DeusExGSpyLink Link;

// ----------------------------------------------------------------------
// Query()
// ----------------------------------------------------------------------

function Query()
{
	Link = GetPlayerPawn().GetEntryLevel().Spawn(class'DeusExGSpyLink');

	Link.MasterServerAddress = MasterServerAddress;
	Link.MasterServerTCPPort = MasterServerTCPPort;
	Link.Region = Region;
	Link.MasterServerTimeout = MasterServerTimeout;
	Link.GameName = GameName;
	Link.OwnerWindow = Self;

	Link.Start();
}

// ---------------------------------------------------------------------
// QueryFinished()
// ---------------------------------------------------------------------

function QueryFinished(bool bSuccess, optional string ErrorMsg)
{
	Link.Destroy();
	Link = None;

	PingUnpingedServers();
}

// ---------------------------------------------------------------------
// ShutdownLink()
// ---------------------------------------------------------------------

function ShutdownLink()
{
	if(Link != None)
		Link.Destroy();
	Link = None;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	Title="Start HXCoop Net Game"
	HostMenu=Class'HXMenuScreenHostNet'
}
