//=============================================================================
// HXMissionHackMutator
// ugly way of determining which mission, but running strcmp's would be
// painfully slow, and this check runs for *every* actor...
// once i have the switching complete, i will use this in mission scripts
//=============================================================================
class HXMissionHackMutator extends HXMutator;

var bool bMissionSet;
var bool bDisabled;

var int NumberMajor;

var enum ENumberMinor
{
	M00_Intro,
	M00_Training,
	M00_TrainingCombat,
	M00_TrainingFinal,

	M01_NYC_UNATCOHQ,
	M01_NYC_UNATCOIsland,

	M02_NYC_Bar,
	M02_NYC_BatteryPark,
	M02_NYC_FreeClinic,
	M02_NYC_Hotel,
	M02_NYC_Smug,
	M02_NYC_Street,
	M02_NYC_Underground,
	M02_NYC_Warehouse,

	M03_NYC_747,
	M03_NYC_Airfield,
	M03_NYC_AirfieldHeliBase,
	M03_NYC_BatteryPark,
	M03_NYC_BrooklynBridgeStation,
	M03_NYC_Hangar,
	M03_NYC_MolePeople,
	M03_NYC_UNATCOHQ,
	M03_NYC_UNATCOIsland,

	M04_NYC_Bar,
	M04_NYC_BatteryPark,
	M04_NYC_Hotel,
	M04_NYC_NSFHQ,
	M04_NYC_Smug,
	M04_NYC_Street,
	M04_NYC_UNATCOHQ,
	M04_NYC_UNATCOIsland,
	M04_NYC_Underground,

	M05_NYC_UNATCOHQ,
	M05_NYC_UNATCOIsland,
	M05_NYC_UNATCOMJ12lab,

	M06_HongKong_Helibase,
	M06_HongKong_MJ12lab,
	M06_HongKong_Storage,
	M06_HongKong_TongBase,
	M06_HongKong_VersaLife,
	M06_HongKong_WanChai_Canal,
	M06_HongKong_WanChai_Garage,
	M06_HongKong_WanChai_Market,
	M06_HongKong_WanChai_Street,
	M06_HongKong_WanChai_Underworld,

	M08_NYC_Bar,
	M08_NYC_FreeClinic,
	M08_NYC_Hotel,
	M08_NYC_Smug,
	M08_NYC_Street,
	M08_NYC_Underground,
	M09_NYC_Dockyard,
	M09_NYC_Graveyard,
	M09_NYC_Ship,
	M09_NYC_ShipBelow,
	M09_NYC_ShipFan,

	M10_Paris_Catacombs,
	M10_Paris_Catacombs_Tunnels,
	M10_Paris_Chateau,
	M10_Paris_Club,
	M10_Paris_Metro,

	M11_Paris_Cathedral,
	M11_Paris_Everett,
	M11_Paris_Underground,

	M12_Vandenberg_Cmd,
	M12_Vandenberg_Computer,
	M12_Vandenberg_Gas,
	M12_Vandenberg_Tunnels,

	M14_OceanLab_Lab,
	M14_Oceanlab_Silo,
	M14_OceanLab_UC,
	M14_Vandenberg_Sub,

	M15_Area51_Bunker,
	M15_Area51_Entrance,
	M15_Area51_Final,
	M15_Area51_Page,

	M_NONE

} NumberMinor;


// ----------------------------------------------------------------------
// SetMission()
// ----------------------------------------------------------------------

function SetMission()
{
	local DeusExLevelInfo Info;
	local string URL;

	foreach AllActors(class'DeusExLevelInfo', Info)
	{
		URL = Caps(Info.mapName);
		NumberMajor = Info.missionNumber;
	}

	NumberMinor = M_NONE;

	// set NumberMinor depending on URL
	switch (NumberMajor)
	{
		// training / intro
		case 0:
			if			(URL == "00_INTRO")
				NumberMinor = M00_Intro;
			else if (URL == "00_TRAINING")
				NumberMinor = M00_Training;
			else if (URL == "00_TRAININGCOMBAT")
				NumberMinor = M00_TrainingCombat;
			else if (URL == "00_TRAININGFINAL")
				NumberMinor = M00_TrainingFinal;
			break;
		case 1:
			break;
		case 2:
			break;
		case 3:
			break;
		case 4:
			break;
		case 5:
			break;
		case 6:
			break;
		// no mission 07
		case 8:
			break;
		case 9:
			break;
		case 10:
			break;
		case 11:
			break;
		case 12:
			break;
		// no mission 13
		case 14:
			break;
		case 15:
			break;
		default:
			break;
	
	}
	
	if (NumberMinor == M_NONE)
	{
		bDisabled = true;
		Log("(NN) Not using mission hacks");
	}
	else
	{
		Log("(NN) Using mission hacks");	
	}

	bMissionSet = true;
}


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if (!bMissionSet)
		SetMission();

	if (bDisabled)
		return true;

	// call functions depending on level
	switch (NumberMajor)
	{
		case 0:
			return HandleMission00(Other, bSuperRelevant);
			break;
		case 1:
			return HandleMission01(Other, bSuperRelevant);
			break;
		case 2:
			return HandleMission02(Other, bSuperRelevant);
			break;
		case 3:
			return HandleMission03(Other, bSuperRelevant);
			break;
		case 4:
			return HandleMission04(Other, bSuperRelevant);
			break;
		case 5:
			return HandleMission05(Other, bSuperRelevant);
			break;
		case 6:
			return HandleMission06(Other, bSuperRelevant);
			break;
		// no mission 07
		case 8:
			return HandleMission08(Other, bSuperRelevant);
			break;
		case 9:
			return HandleMission09(Other, bSuperRelevant);
			break;
		case 10:
			return HandleMission10(Other, bSuperRelevant);
			break;
		case 11:
			return HandleMission11(Other, bSuperRelevant);
			break;
		case 12:
			return HandleMission12(Other, bSuperRelevant);
			break;
		// no mission 13
		case 14:
			return HandleMission14(Other, bSuperRelevant);
			break;
		case 15:
			return HandleMission15(Other, bSuperRelevant);
			break;

		default:
			break;
	
	}

	return true;
}


// ----------------------------------------------------------------------
// HandleMission00()
// ----------------------------------------------------------------------

function bool HandleMission00(Actor Other, out byte bSuperRelevant)
{
	switch (NumberMinor)
	{
		case M00_Intro:
			break;

		case M00_Training:
			break;

		case M00_TrainingCombat:
			break;

		case M00_TrainingFinal:
			break;
	}

	return true;
}


// ----------------------------------------------------------------------
// HandleMission01()
// ----------------------------------------------------------------------

function bool HandleMission01(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission02()
// ----------------------------------------------------------------------

function bool HandleMission02(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission03()
// ----------------------------------------------------------------------

function bool HandleMission03(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission04()
// ----------------------------------------------------------------------

function bool HandleMission04(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission05()
// ----------------------------------------------------------------------

function bool HandleMission05(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission06()
// ----------------------------------------------------------------------

function bool HandleMission06(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission08()
// ----------------------------------------------------------------------

function bool HandleMission08(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission09()
// ----------------------------------------------------------------------

function bool HandleMission09(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission10()
// ----------------------------------------------------------------------

function bool HandleMission10(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission11()
// ----------------------------------------------------------------------

function bool HandleMission11(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission12()
// ----------------------------------------------------------------------

function bool HandleMission12(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission14()
// ----------------------------------------------------------------------

function bool HandleMission14(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// HandleMission15()
// ----------------------------------------------------------------------

function bool HandleMission15(Actor Other, out byte bSuperRelevant)
{
	return true;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bDisabled=false
	bMissionSet=false
}
