//=============================================================================
// HXMissionScript
//=============================================================================
class HXMissionScript extends MissionScript
	abstract;


// ----------------------------------------------------------------------
// BroadcastDataLink()
// ----------------------------------------------------------------------

function BroadcastDataLink
(
	string datalinkName,
	string invokerName,
	optional HXDataLinkTrigger datalinkTrigger
)
{
	HXCoopGame(Level.Game).GameState.BroadcastDataLink(datalinkName, invokerName, datalinkTrigger);
}


// ----------------------------------------------------------------------
// GoalCompleted()
// ----------------------------------------------------------------------

function GoalCompleted(name goalName)
{
	HXCoopGame(Level.Game).GameState.GoalCompleted(goalName, "");
}


// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	// make sure our flags are initialized correctly
	if (flags == None)
	{
		InitStateMachine();
		FirstFrame();
	}
}



// ----------------------------------------------------------------------
// InitStateMachine()
// ----------------------------------------------------------------------

function InitStateMachine()
{
	local DeusExLevelInfo Info;

	foreach AllActors(class'DeusExLevelInfo', Info)
		dxInfo = Info;

	flags = HXCoopGame(Level.Game).GameState.flags;

	if (flags == none)
	{
		Log("(EE) FlagBase not available for MissionScript");
		return;
	}

	if (flags.GetBool('PlayerTraveling'))
		flags.DeleteExpiredFlags(dxInfo.MissionNumber);

	flags.SetDefaultExpiration(dxInfo.MissionNumber + 1);

	localURL = Caps(dxInfo.mapName);

	Log("(NN) StateMachine starter for " $ localURL);
}


// ----------------------------------------------------------------------
// FirstFrame()
// ----------------------------------------------------------------------

function FirstFrame()
{
	local name flagName;
	local ScriptedPawn P;
	local int i;

	flags.DeleteFlag('PlayerTraveling', FLAG_Bool);

	// Check to see which NPCs should be dead from prevous missions
	foreach AllActors(class'ScriptedPawn', P)
	{
		if (P.bImportant)
		{
			flagName = flags.StringToName(P.BindName$"_Dead");
			if (flags.GetBool(flagName))
				P.Destroy();
		}
	}

	// TODO: move this to HXHuman
/*
	// print the mission startup text only once per map
	flagName = flags.StringToName("M"$Caps(dxInfo.mapName)$"_StartupText");
	if (!flags.GetBool(flagName) && (dxInfo.startupMessage[0] != ""))
	{
		for (i=0; i<ArrayCount(dxInfo.startupMessage); i++)
			DeusExRootWindow(Player.rootWindow).hud.startDisplay.AddMessage(dxInfo.startupMessage[i]);
		DeusExRootWindow(Player.rootWindow).hud.startDisplay.StartMessage();
		flags.SetBool(flagName, True);
	}
*/

	flagName = flags.StringToName("M"$dxInfo.MissionNumber$"MissionStart");
	if (!flags.GetBool(flagName))
	{
		// Remove completed Primary goals and all Secondary goals
		HXCoopGame(Level.Game).GameState.ResetGoals();

		// TODO: make history work again
		// Remove any Conversation History.
		//Player.ResetConversationHistory();

		// Set this flag so we only get in here once per mission.
		flags.SetBool(flagName, true);
	}

}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
