//=============================================================================
// HXMutator
//=============================================================================
class HXMutator extends Mutator	abstract;

var bool bCopyActorMovement;
var bool bCopyActorMovementConst;
var bool bCopyActorLighting;
var bool bCopyActorLightColor;
var bool bCopyActorDisplay;
var bool bCopyActorNetwork;
var bool bCopyActorFilter;
var bool bCopyActorSound;


// ----------------------------------------------------------------------
// GetInventoryReplacementClass()
// can also be called via
// class'HXMutator'.static.GetInventoryReplacementClass();
// ----------------------------------------------------------------------

static function class<Inventory> GetInventoryReplacementClass(class<Inventory> Inv)
{
	if (Inv == none)
		return none;

	// return instantly on hx inventory
	if (ClassIsChildOf(Inv, class'HXCoopWeapon') || ClassIsChildOf(Inv, class'HXCoopAmmo'))
		return Inv;

	// weapons
	if (ClassIsChildOf(Inv, class'DeusExWeapon'))
	{
		// weapons for MJ12Commando
		if (ClassIsChildOf(Inv, class'WeaponNPCRanged'))
		{
			if (ClassIsChildOf(Inv, class'WeaponMJ12Commando'))
				return class'HXWeaponMJ12Commando';
			else if (ClassIsChildOf(Inv, class'WeaponMJ12Rocket'))
				return class'HXWeaponMJ12Rocket';
		}

		// shared weapons
		else if (ClassIsChildOf(Inv, class'WeaponAssaultGun'))
			return class'HXWeaponAssaultGun';
		else if (ClassIsChildOf(Inv, class'WeaponAssaultShotgun'))
			return class'HXWeaponAssaultShotgun';
		else if (ClassIsChildOf(Inv, class'WeaponBaton'))
			return class'HXWeaponBaton';
		else if (ClassIsChildOf(Inv, class'WeaponCombatKnife'))
			return class'HXWeaponCombatKnife';
		else if (ClassIsChildOf(Inv, class'WeaponCrowbar'))
			return class'HXWeaponCrowbar';
		else if (ClassIsChildOf(Inv, class'WeaponEMPGrenade'))
			return class'HXWeaponEMPGrenade';
		else if (ClassIsChildOf(Inv, class'WeaponFlamethrower'))
			return class'HXWeaponFlamethrower';
		else if (ClassIsChildOf(Inv, class'WeaponGasGrenade'))
			return class'HXWeaponGasGrenade';
		else if (ClassIsChildOf(Inv, class'WeaponGEPGun'))
			return class'HXWeaponGEPGun';
		else if (ClassIsChildOf(Inv, class'WeaponHideAGun'))
			return class'HXWeaponHideAGun';
		else if (ClassIsChildOf(Inv, class'WeaponLAM'))
			return class'HXWeaponLAM';
		else if (ClassIsChildOf(Inv, class'WeaponLAW'))
			return class'HXWeaponLAW';
		else if (ClassIsChildOf(Inv, class'WeaponMiniCrossbow'))
			return class'HXWeaponMiniCrossbow';
		else if (ClassIsChildOf(Inv, class'WeaponNanoSword'))
			return class'HXWeaponNanoSword';
		else if (ClassIsChildOf(Inv, class'WeaponNanoVirusGrenade'))
			return class'HXWeaponNanoVirusGrenade';
		else if (ClassIsChildOf(Inv, class'WeaponPepperGun'))
			return class'HXWeaponPepperGun';
		else if (ClassIsChildOf(Inv, class'WeaponPistol'))
			return class'HXWeaponPistol';
		else if (ClassIsChildOf(Inv, class'WeaponPlasmaRifle'))
			return class'HXWeaponPlasmaRifle';
		else if (ClassIsChildOf(Inv, class'WeaponProd'))
			return class'HXWeaponProd';
		else if (ClassIsChildOf(Inv, class'WeaponRifle'))
			return class'HXWeaponRifle';
		else if (ClassIsChildOf(Inv, class'WeaponSawedOffShotgun'))
			return class'HXWeaponSawedOffShotgun';
		else if (ClassIsChildOf(Inv, class'WeaponShuriken'))
			return class'HXWeaponShuriken';
		else if (ClassIsChildOf(Inv, class'WeaponStealthPistol'))
			return class'HXWeaponStealthPistol';
		else if (ClassIsChildOf(Inv, class'WeaponSword'))
			return class'HXWeaponSword';
	}

	// ammo
	else if (ClassIsChildOf(Inv, class'DeusExAmmo'))
	{
		if (ClassIsChildOf(Inv, class'Ammo10mm'))
			return class'HXAmmo10mm';
		else if (ClassIsChildOf(Inv, class'Ammo20mm'))
			return class'HXAmmo20mm';
		else if (ClassIsChildOf(Inv, class'Ammo3006'))
			return class'HXAmmo3006';
		else if (ClassIsChildOf(Inv, class'Ammo762mm'))
			return class'HXAmmo762mm';
		else if (ClassIsChildOf(Inv, class'AmmoBattery'))
			return class'HXAmmoBattery';

		// darts
		else if (ClassIsChildOf(Inv, class'AmmoDart'))
		{
			if (ClassIsChildOf(Inv, class'AmmoDartFlare'))
				return class'HXAmmoDartFlare';
			else if (ClassIsChildOf(Inv, class'AmmoDartPoison'))
				return class'HXAmmoDartPoison';
			else
				return class'HXAmmoDart';
		}

		else if (ClassIsChildOf(Inv, class'AmmoEMPGrenade'))
			return class'HXAmmoEMPGrenade';
		else if (ClassIsChildOf(Inv, class'AmmoGasGrenade'))
			return class'HXAmmoGasGrenade';
		else if (ClassIsChildOf(Inv, class'AmmoGraySpit'))
			return class'HXAmmoGraySpit';
		else if (ClassIsChildOf(Inv, class'AmmoGreaselSpit'))
			return class'HXAmmoGreaselSpit';
		else if (ClassIsChildOf(Inv, class'AmmoLAM'))
			return class'HXAmmoLAM';
		else if (ClassIsChildOf(Inv, class'AmmoNanoVirusGrenade'))
			return class'HXAmmoNanoVirusGrenade';
		else if (ClassIsChildOf(Inv, class'AmmoNapalm'))
			return class'HXAmmoNapalm';

		// handle AmmoNone here
		else if (ClassIsChildOf(Inv, class'AmmoNone'))
			return class'AmmoNone';

		else if (ClassIsChildOf(Inv, class'AmmoPepper'))
			return class'HXAmmoPepper';
		else if (ClassIsChildOf(Inv, class'AmmoPlasma'))
			return class'HXAmmoPlasma';
		else if (ClassIsChildOf(Inv, class'AmmoRocketWP'))
			return class'HXAmmoRocketWP';
		else if (ClassIsChildOf(Inv, class'AmmoRocket'))
			return class'HXAmmoRocket';
		else if (ClassIsChildOf(Inv, class'AmmoRocketMini'))
			return class'HXAmmoRocketMini';
		else if (ClassIsChildOf(Inv, class'AmmoRocketRobot'))
			return class'HXAmmoRocketRobot';
		else if (ClassIsChildOf(Inv, class'AmmoSabot'))
			return class'HXAmmoSabot';
		else if (ClassIsChildOf(Inv, class'AmmoShell'))
			return class'HXAmmoShell';
		else if (ClassIsChildOf(Inv, class'AmmoShuriken'))
			return class'HXAmmoShuriken';
	}

	// no replacement found, so return param
	return Inv;
}


// ----------------------------------------------------------------------
// CopyKeypadVars()
// ----------------------------------------------------------------------

function CopyKeypadVars(Keypad OtherK, HXKeypad K)
{
	CopyHackableDevicesVars(OtherK, K);

	K.validCode			= OtherK.validCode;
	K.successSound	= OtherK.successSound;
	K.failureSound	= OtherK.failureSound;
	K.FailEvent			= OtherK.FailEvent;
	K.bToggleLock		= OtherK.bToggleLock;
}


// ----------------------------------------------------------------------
// CopyHackAbleDevicesVars()
// ----------------------------------------------------------------------

function CopyHackableDevicesVars(HackAbleDevices OtherH, HXHackAbleDevices H)
{
	CopyDeusExDecorationVars(OtherH, H);

	H.bHackable						= OtherH.bHackable;
	H.hackStrength				= OtherH.hackStrength;
	H.initialhackStrength	= OtherH.initialhackStrength;
	H.UnTriggerEvent[0]		= OtherH.UnTriggerEvent[0];
	H.UnTriggerEvent[1]		= OtherH.UnTriggerEvent[1];
	H.UnTriggerEvent[2]		= OtherH.UnTriggerEvent[2];
	H.UnTriggerEvent[3]		= OtherH.UnTriggerEvent[3];
}


// ----------------------------------------------------------------------
// CopyDecorationVars()
// ----------------------------------------------------------------------

function CopyDecorationVars(Decoration OtherD, Decoration D)
{
	CopyActorVars(OtherD, D);

	D.EffectWhenDestroyed	= OtherD.EffectWhenDestroyed;
	D.bPushable						= OtherD.bPushable;
	D.bOnlyTriggerable		= OtherD.bOnlyTriggerable;
	D.PushSound						= OtherD.PushSound;
	D.contents						= OtherD.contents;
	D.content2						= OtherD.content2;
	D.content3						= OtherD.content3;
	D.EndPushSound				= OtherD.EndPushSound;
}


// ----------------------------------------------------------------------
// CopyDeusExDecorationVars()
// ----------------------------------------------------------------------

function CopyDeusExDecorationVars(DeusExDecoration OtherD, DeusExDecoration D)
{
	CopyDecorationVars(OtherD, D);

	D.HitPoints						= OtherD.HitPoints;
	D.minDamageThreshold	= OtherD.minDamageThreshold;
	D.bInvincible					= OtherD.bInvincible;
	D.fragType						= OtherD.fragType;
	D.bFloating						= OtherD.bFloating;
	D.moverTag						= OtherD.moverTag;
	D.bFlammable					= OtherD.bFlammable;
	D.Flammability				= OtherD.Flammability;
	D.bExplosive					= OtherD.bExplosive;
	D.explosionDamage			= OtherD.explosionDamage;
	D.explosionRadius			= OtherD.explosionRadius;
	D.bHighlight					= OtherD.bHighlight;
	D.bCanBeBase					= OtherD.bCanBeBase;
	D.bGenerateFlies			= OtherD.bGenerateFlies;
}


// ----------------------------------------------------------------------
// CopyDeusExCarcassVars()
// ----------------------------------------------------------------------

function CopyDeusExCarcassVars(DeusExCarcass OtherC, DeusExCarcass C)
{
	local int i;

	CopyCarcassVars(OtherC, C);

	C.Mesh2					= OtherC.Mesh2;
	C.Mesh3					= OtherC.Mesh3;
	C.bHighlight		= OtherC.bHighlight;
	C.bEmitCarcass	= OtherC.bEmitCarcass;
	C.bInvincible		= OtherC.bInvincible;

	for (i = 0; i < 8; i++)
	{
		C.InitialInventory[i].Inventory	= GetInventoryReplacementClass(OtherC.InitialInventory[i].Inventory);
		C.InitialInventory[i].Count			= OtherC.InitialInventory[i].Count;
	}

}


// ----------------------------------------------------------------------
// CopyDeusExCarcassVars()
// ----------------------------------------------------------------------

function CopyCarcassVars(Carcass OtherC, Carcass C)
{
	CopyDecorationVars(OtherC, C);

	C.flies						= OtherC.flies;
	C.rats						= OtherC.rats;
	C.bReducedHeight	= OtherC.bReducedHeight;
}


// ----------------------------------------------------------------------
// CopyActorVars()
// ----------------------------------------------------------------------

function CopyActorVars(Actor OtherA, Actor A)
{
	A.bHidden = OtherA.bHidden;
	A.bCanTeleport = OtherA.bCanTeleport;
	A.bIsSecretGoal = OtherA.bIsSecretGoal;
	A.bIsKillGoal = OtherA.bIsKillGoal;
	A.bIsItemGoal = OtherA.bIsItemGoal;
//	A.bCollideWhenPlacing = OtherA.bCollideWhenPlacing;
//	A.bTravel = OtherA.bTravel;
	A.bMovable = OtherA.bMovable;
	A.bHighDetail = OtherA.bHighDetail;
//	A.bStasis = OtherA.bStasis;
//	A.bForceStasis = OtherA.bForceStasis;
	A.bBlockSight = OtherA.bBlockSight;
	A.bDetectable = OtherA.bDetectable;
//	A.bTransient = OtherA.bTransient;
//	A.InitialState = OtherA.InitialState;
	A.Group = OtherA.Group;
//	A.LifeSpan = OtherA.LifeSpan;
	A.Tag = OtherA.Tag;
	A.Event = OtherA.Event;
	A.bOwnerNoSee = OtherA.bOwnerNoSee;
//	A.bOnlyOwnerSee = OtherA.bOnlyOwnerSee;
//	A.bAlwaysRelevant = OtherA.bAlwaysRelevant;
//	A.bGameRelevant = OtherA.bGameRelevant;
//	A.bCollideWorld = OtherA.bCollideWorld;
//	A.bBlockActors = OtherA.bBlockActors;
//	A.bBlockPlayers = OtherA.bBlockPlayers;
//	A.bProjTarget = OtherA.bProjTarget;
	A.BindName = OtherA.BindName;
	A.BarkBindName = OtherA.BarkBindName;
	A.FamiliarName = OtherA.FamiliarName;
	A.UnfamiliarName = OtherA.UnfamiliarName;
	A.ConStartInterval = OtherA.ConStartInterval;
	A.bOwned = OtherA.bOwned;


	// const
	// bStatic, bNoDelete, bNetTemporary, bNetOptional, Physics, Location,
	// Rotation, CollisionRadius, CollisionHeight, bCollideActors


	// var(Movement)
	if (bCopyActorMovement)
	{
		A.AttachTag							= OtherA.AttachTag;
		A.Velocity							= OtherA.Velocity;
		A.bBounce								= OtherA.bBounce;
		A.bFixedRotationDir			= OtherA.bFixedRotationDir;
		A.bRotateToDesired			= OtherA.bRotateToDesired;
		A.Mass									= OtherA.Mass;
		A.Buoyancy							= OtherA.Buoyancy;
		A.RotationRate					= OtherA.RotationRate;
		A.DesiredRotation				= OtherA.DesiredRotation;
	}
	if (bCopyActorMovementConst)
	{
		// Location, Rotation
	}

	// var(Lighting)
	if (bCopyActorLighting)
	{
		A.LightType							= OtherA.LightType;
		A.LightEffect						= OtherA.LightEffect;
		A.LightRadius						= OtherA.LightRadius;
		A.LightPeriod						= OtherA.LightPeriod;
		A.LightPhase						= OtherA.LightPhase;
		A.LightCone							= OtherA.LightCone;
		A.VolumeBrightness			= OtherA.VolumeBrightness;
		A.VolumeRadius					= OtherA.VolumeRadius;
		A.VolumeFog							= OtherA.VolumeFog;
		A.bSpecialLit						= OtherA.bSpecialLit;
		A.bActorShadows					= OtherA.bActorShadows;
		A.bCorona								= OtherA.bCorona;
		A.bLensFlare						= OtherA.bLensFlare;
	}

	// var(LightColor)
	if (bCopyActorLightColor)
	{
		A.LightBrightness				= OtherA.LightBrightness;
		A.LightHue							= OtherA.LightHue;
		A.LightSaturation				= OtherA.LightSaturation;
	}

	// var(Display)
	if (bCopyActorDisplay)
	{
		A.AnimSequence					= OtherA.AnimSequence;
		A.AnimFrame							= OtherA.AnimFrame;
		A.AnimRate							= OtherA.AnimRate;
		A.LODBias								= OtherA.LODBias;
		A.DrawType							= OtherA.DrawType;
		A.Style									= OtherA.Style;
		A.Sprite								= OtherA.Sprite;
		A.Texture								= OtherA.Texture;
		A.Skin									= OtherA.Skin;
		A.Mesh									= OtherA.Mesh;
		A.DrawScale							= OtherA.DrawScale;
		A.ScaleGlow							= OtherA.ScaleGlow;
		A.AmbientGlow						= OtherA.AmbientGlow;
		A.Fatness								= OtherA.Fatness;
		A.bUnlit								= OtherA.bUnlit;
		A.bNoSmooth							= OtherA.bNoSmooth;
		A.bParticles						= OtherA.bParticles;
		A.bRandomFrame					= OtherA.bRandomFrame;
		A.bMeshEnviroMap				= OtherA.bMeshEnviroMap;
		A.bMeshCurvy						= OtherA.bMeshCurvy;
		A.VisibilityRadius			= OtherA.VisibilityRadius;
		A.VisibilityHeight			= OtherA.VisibilityHeight;
		A.bShadowCast						= OtherA.bShadowCast;
		A.MultiSkins[0]					= OtherA.MultiSkins[0];
		A.MultiSkins[1]					= OtherA.MultiSkins[1];
		A.MultiSkins[2]					= OtherA.MultiSkins[2];
		A.MultiSkins[3]					= OtherA.MultiSkins[3];
		A.MultiSkins[4]					= OtherA.MultiSkins[4];
		A.MultiSkins[5]					= OtherA.MultiSkins[5];
		A.MultiSkins[6]					= OtherA.MultiSkins[6];
		A.MultiSkins[7]					= OtherA.MultiSkins[7];
		// skip RenderIteratorClass
	}

	// var(Network)
	if (bCopyActorNetwork)
	{
		A.NetPriority						= OtherA.NetPriority;
		A.NetUpdateFrequency		= OtherA.NetUpdateFrequency;
		A.RemoteRole						= OtherA.RemoteRole;
		A.RelevantRadius				= OtherA.RelevantRadius;

	}

	// var(Filter)
	if (bCopyActorFilter)
	{
		A.bDifficulty0					= OtherA.bDifficulty0;
		A.bDifficulty1					= OtherA.bDifficulty1;
		A.bDifficulty2					= OtherA.bDifficulty2;
		A.bDifficulty3					= OtherA.bDifficulty3;
		A.bSinglePlayer					= OtherA.bSinglePlayer;
		A.bNet									= OtherA.bNet;
		A.bNetSpecial						= OtherA.bNetSpecial;
		A.OddsOfAppearing				= OtherA.OddsOfAppearing;
	}

	// var(Sound)
	if (bCopyActorSound)
	{
		A.SoundRadius						= OtherA.SoundRadius;
		A.SoundVolume						= OtherA.SoundVolume;
		A.SoundPitch						= OtherA.SoundPitch;
		A.AmbientSound					= OtherA.AmbientSound;
		A.TransientSoundVolume	= OtherA.TransientSoundVolume;
		A.TransientSoundRadius	= OtherA.TransientSoundRadius;
	}

	// these vars are never needed
	// editor:
	// bHiddenEd, bDirectional, bEdShouldSnap
	// unimplemented:
	// SmellClass
}


// ----------------------------------------------------------------------
// CopyScriptedPawnVars()
// ----------------------------------------------------------------------

function CopyScriptedPawnVars(ScriptedPawn OtherP, ScriptedPawn P)
{
	local int i;

	CopyPawnVars(OtherP, P);

	P.BaseAccuracy				= OtherP.BaseAccuracy;
	P.MaxRange						= OtherP.MaxRange;
	P.MinRange						= OtherP.MinRange;
	P.MinHealth						= OtherP.MinHealth;
	P.RandomWandering			= OtherP.RandomWandering;
	P.CarcassType					= OtherP.CarcassType;
	P.Orders							= OtherP.Orders;
	P.OrderTag						= OtherP.OrderTag;
	P.HomeTag							= OtherP.HomeTag;
	P.HomeExtent					= OtherP.HomeExtent;
	P.ProjectileSpeed			= OtherP.ProjectileSpeed;
	P.ClotPeriod					= OtherP.ClotPeriod;
	P.bKeepWeaponDrawn		= OtherP.bKeepWeaponDrawn;
	P.bShowPain						= OtherP.bShowPain;
	P.bCanSit							= OtherP.bCanSit;
	P.bAlwaysPatrol				= OtherP.bAlwaysPatrol;
	P.bPlayIdle						= OtherP.bPlayIdle;
	P.bLeaveAfterFleeing	= OtherP.bLeaveAfterFleeing;
	P.bLikesNeutral				= OtherP.bLikesNeutral;
	P.bUseFirstSeatOnly		= OtherP.bUseFirstSeatOnly;
	P.bCower							= OtherP.bCower;
	P.bImportant					= OtherP.bImportant;
	P.bInvincible					= OtherP.bInvincible;
	P.bAvoidAim						= OtherP.bAvoidAim;
	P.bAimForHead					= OtherP.bAimForHead;
	P.bDefendHome					= OtherP.bDefendHome;
	P.bUseFallbackWeapons	= OtherP.bUseFallbackWeapons;
	P.bHateHacking				= OtherP.bHateHacking;
	P.bHateWeapon					= OtherP.bHateWeapon;
	P.bHateShot						= OtherP.bHateShot;
	P.bHateInjury					= OtherP.bHateInjury;
	P.bHateIndirectInjury	= OtherP.bHateIndirectInjury;
	P.bHateCarcass				= OtherP.bHateCarcass;
	P.bHateDistress				= OtherP.bHateDistress;
	P.bReactFutz					= OtherP.bReactFutz;
	P.bReactPresence			= OtherP.bReactPresence;
	P.bReactLoudNoise			= OtherP.bReactLoudNoise;
	P.bReactAlarm					= OtherP.bReactAlarm;
	P.bReactShot					= OtherP.bReactShot;
	P.bReactCarcass				= OtherP.bReactCarcass;
	P.bReactDistress			= OtherP.bReactDistress;
	P.bReactProjectiles		= OtherP.bReactProjectiles;
	P.bFearHacking				= OtherP.bFearHacking;
	P.bFearWeapon					= OtherP.bFearWeapon;
	P.bFearShot						= OtherP.bFearShot;
	P.bFearInjury					= OtherP.bFearInjury;
	P.bFearIndirectInjury	= OtherP.bFearIndirectInjury;
	P.bFearCarcass				= OtherP.bFearCarcass;
	P.bFearDistress				= OtherP.bFearDistress;
	P.bFearAlarm					= OtherP.bFearAlarm;
	P.bFearProjectiles		= OtherP.bFearProjectiles;
	P.bEmitDistress				= OtherP.bEmitDistress;
	P.RaiseAlarm					= OtherP.RaiseAlarm;
	P.bMustFaceTarget			= OtherP.bMustFaceTarget;
	P.FireAngle						= OtherP.FireAngle;
	P.FireElevation				= OtherP.FireElevation;
	P.MaxProvocations			= OtherP.MaxProvocations;
	P.InitialAlliances[0]	= OtherP.InitialAlliances[0];
	P.InitialAlliances[1]	= OtherP.InitialAlliances[1];
	P.InitialAlliances[2]	= OtherP.InitialAlliances[2];
	P.InitialAlliances[3]	= OtherP.InitialAlliances[3];
	P.InitialAlliances[4]	= OtherP.InitialAlliances[4];
	P.InitialAlliances[5]	= OtherP.InitialAlliances[5];
	P.InitialAlliances[6]	= OtherP.InitialAlliances[6];
	P.InitialAlliances[7]	= OtherP.InitialAlliances[7];
	P.BaseAssHeight				= OtherP.BaseAssHeight;
	P.EnemyTimeout				= OtherP.EnemyTimeout;
	P.bTickVisibleOnly		= OtherP.bTickVisibleOnly;
	P.bInWorld						= OtherP.bInWorld;
	P.bHighlight					= OtherP.bHighlight;
	P.bHokeyPokey					= OtherP.bHokeyPokey;
	P.WalkSound						= OtherP.WalkSound;

	// don't copy InitialInventory of animals
	if (!OtherP.isA('Animal') && !OtherP.isA('Robot'))
	{
		for (i = 0; i < 8; i++)
		{
			P.InitialInventory[i].Inventory	= GetInventoryReplacementClass(OtherP.InitialInventory[i].Inventory);
			P.InitialInventory[i].Count			= OtherP.InitialInventory[i].Count;
		}
	}
}


// ----------------------------------------------------------------------
// CopyPawnVars()
// ----------------------------------------------------------------------

function CopyPawnVars(Pawn OtherP, Pawn P)
{
	CopyActorVars(OtherP, P);

	P.bCanStrafe					= OtherP.bCanStrafe;
	P.bFixedStart					= OtherP.bFixedStart;
	P.MeleeRange					= OtherP.MeleeRange;
	P.GroundSpeed					= OtherP.GroundSpeed;
	P.WaterSpeed					= OtherP.WaterSpeed;
	P.AirSpeed						= OtherP.AirSpeed;
	P.AccelRate						= OtherP.AccelRate;
	P.JumpZ								= OtherP.JumpZ;
	P.MaxStepHeight				= OtherP.MaxStepHeight;
	P.AirControl					= OtherP.AirControl;
	P.Visibility					= OtherP.Visibility;
	P.SightRadius					= OtherP.SightRadius;
	P.PeripheralVision		= OtherP.PeripheralVision;
	P.HearingThreshold		= OtherP.HearingThreshold;
	P.BaseEyeHeight				= OtherP.BaseEyeHeight;
	P.FovAngle						= OtherP.FovAngle;
	P.Health							= OtherP.Health;
	P.SelectionMesh				= OtherP.SelectionMesh;
	P.SpecialMesh					= OtherP.SpecialMesh;
	P.ReducedDamageType		= OtherP.ReducedDamageType;
	P.ReducedDamagePct		= OtherP.ReducedDamagePct;
	P.DropWhenKilled			= OtherP.DropWhenKilled;
	P.UnderWaterTime			= OtherP.UnderWaterTime;
	P.AttitudeToPlayer		= OtherP.AttitudeToPlayer;
	P.Intelligence				= OtherP.Intelligence;
	P.Skill								= OtherP.Skill;
	P.HitSound1						= OtherP.HitSound1;
	P.HitSound2						= OtherP.HitSound2;
	P.Land								= OtherP.Land;
	P.Die									= OtherP.Die;
	P.WaterStep						= OtherP.WaterStep;
	P.CombatStyle					= OtherP.CombatStyle;
	P.AlarmTag						= OtherP.AlarmTag;
	P.SharedAlarmTag			= OtherP.SharedAlarmTag;
	P.MenuName						= OtherP.MenuName;
	P.NameArticle					= OtherP.NameArticle;
	P.VoicePitch					= OtherP.VoicePitch;
	P.VoiceType						= OtherP.VoiceType;
	P.HealthHead					= OtherP.HealthHead;
	P.HealthTorso					= OtherP.HealthTorso;
	P.HealthLegLeft				= OtherP.HealthLegLeft;
	P.HealthLegRight			= OtherP.HealthLegRight;
	P.HealthArmLeft				= OtherP.HealthArmLeft;
	P.HealthArmRight			= OtherP.HealthArmRight;
	P.AIHorizontalFov			= OtherP.AIHorizontalFov;
	P.AspectRatio					= OtherP.AspectRatio;
	P.AngularResolution		= OtherP.AngularResolution;
	P.VisibilityThreshold	= OtherP.VisibilityThreshold;
	P.SmellThreshold			= OtherP.SmellThreshold;
	P.Alliance						= OtherP.Alliance;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bCopyActorMovement=False
	bCopyActorMovementConst=False
	bCopyActorLighting=False
	bCopyActorLightColor=False
	bCopyActorDisplay=False
	bCopyActorNetwork=False
	bCopyActorFilter=False
	bCopyActorSound=False
}
