//=============================================================================
// HXPersonaNavBarWindow
//=============================================================================
class HXPersonaNavBarWindow extends PersonaNavBarWindow;

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local Class<PersonaScreenBaseWindow> winClass;

	bHandled = True;

	switch(buttonPressed)
	{
		case btnInventory:
			winClass = Class'HXPersonaScreenInventory';
			break;

		case btnHealth:
			winClass = Class'HXPersonaScreenHealth';
			break;

		case btnAugs:
			winClass = Class'HXPersonaScreenAugmentations';
			break;

		case btnSkills:
			winClass = Class'HXPersonaScreenSkills';
			break;

		case btnGoals:
			winClass = Class'HXPersonaScreenGoals';
			break;

		case btnCons:
			winClass = Class'HXPersonaScreenConversations';
			break;

		case btnImages:
			winClass = Class'HXPersonaScreenImages';
			break;

		case btnLogs:
			winClass = Class'HXPersonaScreenLogs';
			break;

		default:
			bHandled = False;
			break;
	}

	if (bHandled)
	{
		PersonaScreenBaseWindow(GetParent()).SaveSettings();
		root.InvokeUIScreen(winClass);
		return bHandled;
	}
	else
	{
		return Super.ButtonActivated(buttonPressed);
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
