//=============================================================================
// HXPersonaScreenGoals
//=============================================================================
class HXPersonaScreenGoals extends PersonaScreenGoals;

// ----------------------------------------------------------------------
// CreateNavBarWindow()
// ----------------------------------------------------------------------

function CreateNavBarWindow()
{
	winNavBar = PersonaNavBarBaseWindow(NewChild(Class'HXPersonaNavBarWindow'));
	winNavBar.SetPos(0, 0);
}

// ----------------------------------------------------------------------
// PopulateGoalsByType()
// ----------------------------------------------------------------------

function PopulateGoalsByType(Bool bPrimaryGoals, String goalHeaderText)
{
	local DeusExGoal goal;
	local bool bGoalsFound;
	local PersonaGoalItemWindow goalWindow;
	local PersonaHeaderTextWindow goalHeader;

	// Create Goals Header
	goalHeader = PersonaHeaderTextWindow(winGoals.NewChild(Class'PersonaHeaderTextWindow'));
	goalHeader.SetTextAlignments(HALIGN_Left, VALIGN_Center);
	goalHeader.SetText(goalHeaderText);

	// Loop through all the Goals
	goal = HXHuman(player).GoalCache.FirstGoal;

	while( goal != None )
	{
		// Check if this is a primary or secondary goal as specified
		// in the bPrimaryGoals parameter above.

		if (bPrimaryGoals == goal.bPrimaryGoal)
		{
			// Check to see if this goal has already been marked as Completed,
			// and if so, only display if the chkShowCompletedGoals is true.

			if ((!goal.bCompleted) || ((goal.bCompleted) && (chkShowCompletedGoals.GetToggle())))
			{
				bGoalsFound = True;

				// Now create a window for the text
				goalWindow = PersonaGoalItemWindow(winGoals.NewChild(Class'PersonaGoalItemWindow'));

				// Set goal properties
				if (goal.bCompleted)
					goalWindow.SetGoalProperties(goal.bPrimaryGoal, goal.bCompleted, goal.text @ GoalCompletedText);
				else
					goalWindow.SetGoalProperties(goal.bPrimaryGoal, goal.bCompleted, goal.text);
			}
		}

		// Continue on to the next goal
		goal = goal.next;
	}

	// If there are no goals of this type, then print "None"
	if (!bGoalsFound)
	{
		// Now create a window for the text
		goalWindow = PersonaGoalItemWindow(winGoals.NewChild(Class'PersonaGoalItemWindow'));
		goalWindow.SetGoalProperties(bPrimaryGoals, True, NoGoalsLabel, True);
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
