//=============================================================================
// HXRobotMutator
//=============================================================================
class HXRobotMutator extends HXScriptedPawnMutator;

// ----------------------------------------------------------------------
// PostCustomize()
// ----------------------------------------------------------------------

function PostCustomize(ScriptedPawn OtherP, HXScriptedPawn P)
{
	HXRobot(P).EMPHitPoints = Robot(OtherP).EMPHitPoints;

	if (OtherP.isA('MilitaryBot') && MilitaryBot(OtherP).SkinColor == SC_Chinese)
		HXMilitaryBot(P).SkinColor = SC_Chinese;
	else 	if (OtherP.isA('SecurityBot2') && SecurityBot2(OtherP).SkinColor == SC_Chinese)
		HXSecurityBot2(P).SkinColor = SC_Chinese;
	else 	if (OtherP.isA('SecurityBot3') && SecurityBot3(OtherP).SkinColor == SC_Chinese)
		HXSecurityBot3(P).SkinColor = SC_Chinese;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	OldBaseClass=Class'Robot'
	Replacements(0)=(Old=Class'DeusEx.CleanerBot',New=Class'HXCoop.HXCleanerBot')
	Replacements(1)=(Old=Class'DeusEx.MedicalBot',New=Class'HXCoop.HXMedicalBot')
	Replacements(2)=(Old=Class'DeusEx.MilitaryBot',New=Class'HXCoop.HXMilitaryBot')
	Replacements(3)=(Old=Class'DeusEx.RepairBot',New=Class'HXCoop.HXRepairBot')
	Replacements(4)=(Old=Class'DeusEx.SecurityBot2',New=Class'HXCoop.HXSecurityBot2')
	Replacements(5)=(Old=Class'DeusEx.SecurityBot3',New=Class'HXCoop.HXSecurityBot3')
	Replacements(6)=(Old=Class'DeusEx.SecurityBot4',New=Class'HXCoop.HXSecurityBot4')
	Replacements(7)=(Old=Class'DeusEx.SpiderBot',New=Class'HXCoop.HXSpiderBot')
	Replacements(8)=(Old=Class'DeusEx.SpiderBot2',New=Class'HXCoop.HXSpiderBot2')
}
