//=============================================================================
// HXScriptedPawnMutator
//=============================================================================
class HXScriptedPawnMutator extends HXMutator
	abstract;

struct ScriptedPawnReplacement
{
	var class<ScriptedPawn> Old;
	var class<HXScriptedPawn> New;
};

var class<ScriptedPawn> OldBaseClass;
var ScriptedPawnReplacement Replacements[64];


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local class<HXScriptedPawn> RepClass;
	local HXScriptedPawn P;
	local int i;

	if (!ClassIsChildOf(Other.Class, OldBaseClass) || Other.isA('HXScriptedPawn'))
		return true;

	// find replacement class
	for (i = 0; i < ArrayCount(Replacements); i++)
	{
		if (Replacements[i].Old == none)
		{
			Log("(NN) Previous before empty slot was " $ Replacements[Max(0, i-1)].Old);
			break;
		}

		if (ClassIsChildOf(Other.Class, Replacements[i].Old))
		{
			RepClass = Replacements[i].New;
			break;
		}
	}

	if (RepClass == none)
	{
		Log("(EE) Failed to find " $ Other.Class $ " replacement");
	}

	// disable collision of old pawn, so new pawn can spawn
	Other.SetCollision(false, false, false);

	P = spawn(RepClass, Other.Owner, Other.tag, Other.Location, Other.Rotation);

	if (P == none)
	{
		Log("(EE) Spawning " $ Other.Class $ " Replacement failed");
		return false;
	}

	PostCustomize(ScriptedPawn(Other), P);
	CopyScriptedPawnVars(ScriptedPawn(Other), P);

	return false;
}


// ----------------------------------------------------------------------
// PostCustomize()
// implemented in subclass, to give a fine grain control, 
// for e.g. different robot skins...
// ----------------------------------------------------------------------

function PostCustomize(ScriptedPawn OtherP, HXScriptedPawn P)
{
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bCopyActorMovement=False
	bCopyActorMovementConst=False
	bCopyActorLighting=False
	bCopyActorLightColor=False
	bCopyActorDisplay=False
	bCopyActorNetwork=False
	bCopyActorFilter=False
	bCopyActorSound=False
}
