//=============================================================================
// HXTeleporterMutator
//
// this mutator is used to replace DX NavigationPoint based Teleporters
// with Trigger based, because subclasses of Teleporter somehow won't
// spawn or Teleporters can be deleted;
// also Trigger based Teleports make more sence
//
// the process is a bit tricky, because we need to disable the teleporter
// completely, e.g. set bEnabled to false and change tag and group, so it
// won't get triggered
//
// it is also just needed to spawn a HXTeleporterTrigger if the Teleporter
// has a non empty URL
//=============================================================================
class HXTeleporterMutator extends HXMutator;


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Teleporter					OtherT;
	local HXTeleporterTrigger	T;

	if (!Other.isA('Teleporter'))
		return true;

	OtherT = Teleporter(Other);

	// ok, now check if this Teleporter needs to be replaced
	if (OtherT.URL == "")
	{
		Log("(NN) Keeping Teleporter with empty URL");
		return true;
	}

	T = spawn(class'HXTeleporterTrigger', OtherT.Owner, OtherT.Tag, OtherT.Location, OtherT.Rotation);

	if (T == none)
	{
		Log("(EE) Spawning Teleporter Replacement failed");
		return true;
	}

	Log("(NN) Spawned Teleporter Replacement");

	// relevant Teleporter var()
	T.URL								= OtherT.URL;
	T.bEnabled					= OtherT.bEnabled;

	// relevant Actor var()
	T.Group								= OtherT.Group;
	T.Event								= OtherT.Event;

	T.SetCollisionSize(OtherT.CollisionRadius, OtherT.CollisionHeight);

	// now disable old Teleporter
	OtherT.bEnabled	= false;
	OtherT.Event		= '';//String(OtherT.Event) $ "_OLDEVENT";
	OtherT.Tag			= '';//name(OtherT.Tag $ "_OLDTAG");
	OtherT.SetCollision(false, false, false);
	OtherT.SetCollisionSize(1.0, 1.0);

	// Teleporters can not be deleted (Urgh!)
	return true;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
