//=============================================================================
// HXTeleporterTrigger
//
// used instead of Teleporter, which is a NavigationPoint subclass
// and could not be spawned (somehow) as a replacement
// making the teleporter makes somehow more sence
// (it maybe was a NavigationPoint for Navigation Code in Unreal/UT
// where Teleporters were gameplay relevant
//=============================================================================
class HXTeleporterTrigger extends Trigger;

var() string	URL;
var() bool		bEnabled;			// Teleporter is turned on;

// ----------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------

function Trigger(actor Other, pawn EventInstigator)
{
	local int i;

	bEnabled = !bEnabled;
	if (bEnabled) //teleport any pawns already in my radius
		for (i=0;i<4;i++)
			if (Touching[i] != None)
				Touch(Touching[i]);
}


// ----------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------

function Touch(Actor Other)
{	
	local HXHuman human;

	if (!bEnabled || !Other.isA('HXHuman'))
		return;

	if (Role != ROLE_Authority)
		return;

	Log("(NN) HXTeleportationTrigger activated URL=" $ URL);

	if (Level.NetMode == NM_ListenServer)
	{
		// find local player
		foreach AllActors(class'HXHuman', human)
			if (NetConnection(human.Player) == None)
				//Level.Game.SendPlayer(human, URL);
				human.ClientTravel(URL, TRAVEL_Partial, true);

	}
	else if (Level.NetMode == NM_DedicatedServer)
	{
		Level.ServerTravel(URL, False);
	}
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bEnabled=True
	Texture=Texture'Engine.S_Teleport'
	CollisionRadius=18.000000
	CollisionHeight=40.000000
	bCollideActors=True
}
