//=============================================================================
// HXTriggerMutator
//=============================================================================
class HXTriggerMutator extends HXMutator;


// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Trigger T;
	local Trigger OtherT;

	if (!Other.isA('Trigger'))
		return true;

	OtherT = Trigger(Other);

	// DataLinkTrigger
	if (Other.isA('DataLinkTrigger'))
	{
		T = spawn(class'HXDataLinkTrigger', Other.Owner, Other.tag, Other.Location, Other.Rotation);

		if (T == none)
		{
			Log("(EE) Spawning DataLinkTrigger Replacement failed");
			return false;
		}

		// DataLinkTrigger var()
		HXDataLinkTrigger(T).datalinkTag	= DataLinkTrigger(OtherT).datalinkTag;
		HXDataLinkTrigger(T).checkFlag		= DataLinkTrigger(OtherT).checkFlag;
		HXDataLinkTrigger(T).bCheckFalse	= DataLinkTrigger(OtherT).bCheckFalse;
	}
	// GoalCompleteTrigger
	else if (Other.isA('GoalCompleteTrigger'))
	{
		T = spawn(class'HXGoalCompleteTrigger', Other.Owner, Other.tag, Other.Location, Other.Rotation);

		if (T == none)
		{
			Log("(EE) Spawning GoalCompleteTrigger Replacement failed");
			return false;
		}

		// GoalCompleteTrigger var()
		HXGoalCompleteTrigger(T).goalName = GoalCompleteTrigger(OtherT).goalName;
	}
	// Keep other Triggers
	else
	{
		return true;
	}

	// Trigger var()
	T.TriggerType					= OtherT.TriggerType;
	T.Message							= OtherT.Message;
	T.bTriggerOnceOnly		= OtherT.bTriggerOnceOnly;
	T.bInitiallyActive		= OtherT.bInitiallyActive;
	T.ClassProximityType	= OtherT.ClassProximityType;
	T.RepeatTriggerTime		= OtherT.RepeatTriggerTime;
	T.ReTriggerDelay			= OtherT.ReTriggerDelay;
	T.DamageThreshold			= OtherT.DamageThreshold;

	// relevant Actor var()
	T.bHidden							= OtherT.bHidden;
	T.InitialState				= OtherT.InitialState;
	T.Group								= OtherT.Group;
	T.Event								= OtherT.Event;
	T.AttachTag						= OtherT.AttachTag;

	T.SetCollision(OtherT.bCollideActors);
	T.SetCollisionSize(OtherT.CollisionRadius, OtherT.CollisionHeight);

	return false;
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
