//=============================================================================
// HXWIB
//=============================================================================
class HXWIB extends HXHumanMilitary;

// ----------------------------------------------------------------------
// SpawnCarcass()
//
// Blow up instead of spawning a carcass
// ----------------------------------------------------------------------

function Carcass SpawnCarcass()
{
	if (bStunned)
		return Super.SpawnCarcass();

	Explode();

	return None;
}


// ----------------------------------------------------------------------
// Explode()
// ----------------------------------------------------------------------

function Explode()
{
	local SphereEffect sphere;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local float explosionDamage;
	local float explosionRadius;

	explosionDamage = 100;
	explosionRadius = 256;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'LargeExplosion1', SLOT_None,,, explosionRadius*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionLarge',,, Location + 2*VRand()*CollisionRadius);

	sphere = Spawn(class'SphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks and flesh fragments
	for (i=0; i<explosionDamage/6; i++)
	{
		if (FRand() < 0.3)
			spawn(class'Rockchip',,,Location);
		else
			spawn(class'FleshFragment',,,Location);
	}


	HurtRadius(explosionDamage, explosionRadius, 'Exploded', explosionDamage*100, Location);
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	MinHealth=0.000000
	CarcassType=Class'DeusEx.WIBCarcass'
	WalkingSpeed=0.296000
	CloseCombatMult=0.500000
	BaseAssHeight=-18.000000
	walkAnimMult=0.870000
	bIsFemale=True
	GroundSpeed=200.000000
	Health=300
	HealthHead=300
	HealthTorso=300
	HealthLegLeft=300
	HealthLegRight=300
	HealthArmLeft=300
	HealthArmRight=300
	Mesh=LodMesh'DeusExCharacters.GFM_SuitSkirt'
	DrawScale=1.100000
	MultiSkins(0)=Texture'DeusExCharacters.Skins.WIBTex0'
	MultiSkins(1)=Texture'DeusExItems.Skins.PinkMaskTex'
	MultiSkins(2)=Texture'DeusExCharacters.Skins.WIBTex0'
	MultiSkins(3)=Texture'DeusExCharacters.Skins.LegsTex2'
	MultiSkins(4)=Texture'DeusExCharacters.Skins.WIBTex1'
	MultiSkins(5)=Texture'DeusExCharacters.Skins.WIBTex1'
	MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex2'
	MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex3'
	CollisionHeight=47.299999
	BindName="WIB"
	FamiliarName="Woman In Black"
	UnfamiliarName="Woman In Black"
}
