//=============================================================================
// HXCoopGame
//=============================================================================
class HXCoopGame expands HXExtDeusExMPGame;

/***
	this is where the change magic should start
***/
function PostBeginPlay()
{
	ChangePawnCarcassType();
	ChangeComputersTerminalType();

	Super.PostBeginPlay();
}


/***
	give player a 9mm, prod and medkit
***/
function AddDefaultInventory(pawn PlayerPawn)
{
	local inventory anItem;

	PlayerPawn.JumpZ = PlayerPawn.Default.JumpZ * PlayerJumpZScaling();

	if (PlayerPawn.IsA('Spectator'))
		return;

	anItem = Spawn(class'WeaponPistol');
	anItem.Frob(PlayerPawn, None);
	anItem.bInObjectBelt = True;
	anItem = Spawn(class'WeaponProd');
	anItem.Frob(PlayerPawn, None);
	anItem.bInObjectBelt = True;
	anItem = Spawn(class'MedKit');
	anItem.Frob(PlayerPawn, None);
	anItem.bInObjectBelt = True;

	// add lockpick for MedBot replace test
	anItem = Spawn(class'LockPick');
	anItem.Frob(PlayerPawn, None);
	anItem.bInObjectBelt = True;

}


/***
	accept our new player, note: change this all elsewhere and make HXJC default
***/
function bool ApproveClass(class<playerpawn> SpawnClass)
{
	return True;
}


/***
	disable item respawning
***/
function bool ShouldRespawn(actor Other)
{
	return False;
}


/***
	change the terminal windows
***/
function ChangeComputersTerminalType()
{
	local Computers c;

	foreach AllActors(class'Computers', c)
	{
		if			(c.isA('ComputerSecurity'))
			c.terminalType = Class'HXCoop.HXNetworkTerminalSecurity';
		else if (c.isA('ComputerPersonal'))
			c.terminalType = Class'HXCoop.HXNetworkTerminalPersonal';
	
	}
}


/***
	change the CarcassType var of existing pawns
***/
function ChangePawnCarcassType()
{
	local ScriptedPawn p;

	// COMPLETE this for all characters with carcasses / weapons
	foreach AllActors(class'ScriptedPawn', p)
	{
		/*** 
			HumanMilitary Carcasses START
		***/
		if (p.isA('HumanMilitary'))
		{
			if			(p.isA('AnnaNavarre'))
				p.CarcassType = Class'HXCoop.HXAnnaNavarreCarcass';
			else if (p.isA('BobPage'))
				p.CarcassType = Class'HXCoop.HXBobPageCarcass';
			else if (p.isA('Cop'))
				p.CarcassType = Class'HXCoop.HXCopCarcass';
			else if (p.isA('GordonQuick'))
				p.CarcassType = Class'HXCoop.HXGordonQuickCarcass';
			else if (p.isA('GuntherHermann'))
				p.CarcassType = Class'HXCoop.HXGuntherHermannCarcass';
			else if (p.isA('HKMilitary'))
				p.CarcassType = Class'HXCoop.HXHKMilitaryCarcass';
			else if (p.isA('Jock'))
				p.CarcassType = Class'HXCoop.HXJockCarcass';
			else if (p.isA('JosephManderley'))
				p.CarcassType = Class'HXCoop.HXJosephManderleyCarcass';
			else if (p.isA('JuanLebedev'))
				p.CarcassType = Class'HXCoop.HXJuanLebedevCarcass';
			else if (p.isA('MaxChen'))
				p.CarcassType = Class'HXCoop.HXMaxChenCarcass';
			else if (p.isA('MIB'))
				p.CarcassType = Class'HXCoop.HXMIBCarcass';
			else if (p.isA('MJ12Commando'))
				p.CarcassType = Class'HXCoop.HXMJ12CommandoCarcass';
			else if (p.isA('MJ12Troop'))
				p.CarcassType = Class'HXCoop.HXMJ12TroopCarcass';
			else if (p.isA('PaulDenton'))
				p.CarcassType = Class'HXCoop.HXPaulDentonCarcass';
			else if (p.isA('RiotCop'))
				p.CarcassType = Class'HXCoop.HXRiotCopCarcass';
			else if (p.isA('SamCarter'))
				p.CarcassType = Class'HXCoop.HXSamCarterCarcass';
			else if (p.isA('Soldier'))
				p.CarcassType = Class'HXCoop.HXSoldierCarcass';
			else if (p.isA('Terrorist'))
				p.CarcassType = Class'HXCoop.HXTerroristCarcass';
			else if (p.isA('UNATCOTroop'))
				p.CarcassType = Class'HXCoop.HXUNATCOTroopCarcass';
			else if (p.isA('WaltonSimons'))
				p.CarcassType = Class'HXCoop.HXWaltonSimonsCarcass';
			else if (p.isA('WIB'))
				p.CarcassType = Class'HXCoop.HXWIBCarcass';
		}
		/*** 
			HumanMilitary Carcasses END
		***/


		/***
			Animal Carcasses START
		***/
		if (p.isA('Animal'))
		{
			if			(p.isA('Cat'))
				p.CarcassType = Class'HXCoop.HXCatCarcass';
			else if (p.isA('Doberman'))
				p.CarcassType = Class'HXCoop.HXDobermanCarcass';
			else if (p.isA('Gray'))
				p.CarcassType = Class'HXCoop.HXGrayCarcass';
			else if (p.isA('Greasel'))
				p.CarcassType = Class'HXCoop.HXGreaselCarcass';
			else if (p.isA('Karkian'))
			{
				// KarkianBaby is a subclass of Karkian
				if (p.isA('KarkianBaby'))
					p.CarcassType = Class'HXCoop.HXKarkianBabyCarcass';
				else 
					p.CarcassType = Class'HXCoop.HXKarkianCarcass';
			}
			else if (p.isA('Mutt'))
				p.CarcassType = Class'HXCoop.HXMuttCarcass';
			else if (p.isA('Pigeon'))
				p.CarcassType = Class'HXCoop.HXPigeonCarcass';
			else if (p.isA('Rat'))
				p.CarcassType = Class'HXCoop.HXRatCarcass';
			else if (p.isA('Seagull'))
				p.CarcassType = Class'HXCoop.HXSeagullCarcass';
		}
		/***
			Animal Carcasses END
		***/

	}
}

defaultproperties
{
	MPSkillStartLevel=0
	DefaultPlayerClass=Class'HXCoop.HXJCDentonMale'
	MutatorClass=Class'HXCoop.HXCoopMutator'
}
