//=============================================================================
// HXCoopMutator
//=============================================================================
class HXCoopMutator expands HXExtMutator;
5tzh0q80078

// ----------------------------------------------------------------------
// CheckReplacement()
// ----------------------------------------------------------------------
function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	bSuperRelevant = 0;

	/***
		replace DeusExMovers
	***/
	if (Other.isA('DeusExMover'))
	{
		if (Other.isA('HXDeusExMover') || Other.isA('HXBreakableGlass') || Other.isA('HXBreakableWall'))
			return true;

		if (Other.isA('BreakableGlass'))
			ReplaceWith(Other, "HXCoop.HXBreakableGlass");
		else if (Other.isA('BreakableWall'))
			ReplaceWith(Other, "HXCoop.HXBreakableWall");
		else // plain DeusExMover
			ReplaceWith(Other, "HXCoop.HXDeusExMover");

		return false;
	}

	/***
		replace DeusExCarcasses
		TODO - replace all carcasses
	***/
	else if (Other.isA('DeusExCarcass'))
	{
		if (Other.isA('HXDeusExCarcass'))
			return true;

		return CheckDeusExCarcassReplacement(Other, bSuperRelevant);
	}

	/***
		replace HackableDevices
	***/
	else if (Other.isA('HackableDevices'))
	{
		/*** Keypad ***/
		if (Other.isA('Keypad'))
		{
			if (Other.isA('HXKeypad'))
				return true;

			if (Other.isA('Keypad1'))
			{
				ReplaceWith(Other, "HXCoop.HXKeypad1");
				return false;
			}
			else if (Other.isA('Keypad2'))
			{
				ReplaceWith(Other, "HXCoop.HXKeypad2");
				return false;
			}
			else if (Other.isA('Keypad3'))
			{
				ReplaceWith(Other, "HXCoop.HXKeypad3");
				return false;
			}
		}

		/*** SecurityCamera ***/
		else if (Other.isA('SecurityCamera'))
		{
			if (Other.isA('HXSecurityCamera'))
				return true;
			
			ReplaceWith(Other, "HXCoop.HXSecurityCamera");
			return false;
		}
	}


	/***
		replace ScriptedPawns
	***/
	else if (Other.isA('ScriptedPawn'))
	{
		if (Other.isA('Robot'))
		{
			if (Other.isA('HXRobot'))
				return true;

			else if (Other.isA('CleanerBot'))
			{
				ReplaceWith(Other, "HXCoop.HXCleanerBot");
				return false;
			}
			else if (Other.isA('MilitaryBot'))
			{
				ReplaceWith(Other, "HXCoop.HXMilitaryBot");
				return false;
			}
			else if (Other.isA('SecurityBot2'))
			{
				ReplaceWith(Other, "HXCoop.HXSecurityBot2");
				return false;
			}
			else if (Other.isA('SecurityBot3'))
			{
				ReplaceWith(Other, "HXCoop.HXSecurityBot3");
				return false;
			}
			else if (Other.isA('SecurityBot4'))
			{
				ReplaceWith(Other, "HXCoop.HXSecurityBot4");
				return false;
			}
			else if (Other.isA('SpiderBot'))
			{
				ReplaceWith(Other, "HXCoop.HXSpiderBot");
				return false;
			}
			else if (Other.isA('SpiderBot2'))
			{
				ReplaceWith(Other, "HXCoop.HXSpiderBot2");
				return false;
			}


			if (Other.isA('MedicalBot'))
			{
				// HXMedicalBot is already a replacement
				if (Other.isA('HXMedicalBot'))
					return true;

				ReplaceWith(Other, "HXCoop.HXMedicalBot");
				return false;
			}

		}

		else if (Other.isA('HumanMilitary'))
		{
			if (Other.isA('HXHumanMilitary'))
				return true;
		
			else if (Other.isA('Terrorist'))
			{
				ReplaceWith(Other, "HXCoop.HXTerrorist");
				return false;
			}
		}
	}
/*
	if (Other.isA('DeusExWeapon'))
	{
		if (Other.isA('HXDeusExWeapon'))
			return true;

		if (Other.isA('WeaponAssaultGun'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponAssaultGun");
			return false;
		}
		else if (Other.isA('WeaponAssaultShotgun'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponAssaultShotgun");
			return false;
		}
		else if (Other.isA('WeaponBaton'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponBaton");
			return false;
		}
		else if (Other.isA('WeaponCombatKnife'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponCombatKnife");
			return false;
		}
		else if (Other.isA('WeaponCrowbar'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponCrowbar");
			return false;
		}
		else if (Other.isA('WeaponEMPGrenade'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponEMPGrenade");
			return false;
		}
		else if (Other.isA('WeaponFlamethrower'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponFlamethrower");
			return false;
		}
		else if (Other.isA('WeaponGasGrenade'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponGasGrenade");
			return false;
		}
		else if (Other.isA('WeaponGEPGun'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponGEPGun");
			return false;
		}
		else if (Other.isA('WeaponHideAGun'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponHideAGun");
			return false;
		}
		else if (Other.isA('WeaponLAM'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponLAM");
			return false;
		}
		else if (Other.isA('WeaponLAW'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponLAW");
			return false;
		}
		else if (Other.isA('WeaponMiniCrossbow'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponMiniCrossbow");
			return false;
		}
		else if (Other.isA('WeaponNanoSword'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponNanoSword");
			return false;
		}
		else if (Other.isA('WeaponNanoVirusGrenade'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponNanoVirusGrenade");
			return false;
		}
		else if (Other.isA('WeaponPepperGun'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponPepperGun");
			return false;
		}
		else if (Other.isA('WeaponPistol'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponPistol");
			return false;
		}
		else if (Other.isA('WeaponPlasmaRifle'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponPlasmaRifle");
			return false;
		}
		else if (Other.isA('WeaponProd'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponProd");
			return false;
		}
		else if (Other.isA('WeaponRifle'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponRifle");
			return false;
		}
		else if (Other.isA('WeaponSawedOffShotgun'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponSawedOffShotgun");
			return false;
		}
		else if (Other.isA('WeaponShuriken'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponShuriken");
			return false;
		}
		else if (Other.isA('WeaponStealthPistol'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponStealthPistol");
			return false;
		}
		else if (Other.isA('WeaponSword'))
		{
			ReplaceWith(Other, "HXCoop.HXWeaponSword");
			return false;
		}

		return true;
	}
*/

	return true;
}

// ----------------------------------------------------------------------
// CheckDeusExCarcassReplacement()
// ----------------------------------------------------------------------
function bool CheckDeusExCarcassReplacement(Actor Other, out byte bSuperRelevant)
{
	bSuperRelevant = 0;

	if (CheckHumanMilitaryCarcassReplacement(Other, bSuperRelevant) &&
			CheckAnimalCarcassReplacement(Other, bSuperRelevant))
		return true;
	else
		return false;
}


// ----------------------------------------------------------------------
// CheckHumanMilitaryCarcassReplacement()
// ----------------------------------------------------------------------
function bool CheckHumanMilitaryCarcassReplacement(Actor Other, out byte bSuperRelevant)
{
	bSuperRelevant = 0;

	if (Other.isA('AnnaNavarreCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXAnnaNavarreCarcass");
		return false;
	}
	else if (Other.isA('BobPageCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXBobPageCarcass");
		return false;
	}
	else if (Other.isA('CopCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXCopCarcass");
		return false;
	}
	else if (Other.isA('GordonQuickCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXGordonQuickCarcass");
		return false;
	}
	else if (Other.isA('GuntherHermannCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXGuntherHermannCarcass");
		return false;
	}
	else if (Other.isA('HKMilitaryCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXHKMilitaryCarcass");
		return false;
	}
	else if (Other.isA('JockCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXJockCarcass");
		return false;
	}
	else if (Other.isA('JosephManderleyCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXJosephManderleyCarcass");
		return false;
	}
	else if (Other.isA('JuanLebedevCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXJuanLebedevCarcass");
		return false;
	}
	else if (Other.isA('MaxChenCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXMaxChenCarcass");
		return false;
	}
	else if (Other.isA('MIBCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXMIBCarcass");
		return false;
	}
	else if (Other.isA('MJ12CommandoCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXMJ12CommandoCarcass");
		return false;
	}
	else if (Other.isA('MJ12TroopCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXCarcass");
		return false;
	}
	else if (Other.isA('PaulDentonCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXPaulDentonCarcass");
		return false;
	}
	else if (Other.isA('RiotCopCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXRiotCopCarcass");
		return false;
	}
	else if (Other.isA('SamCarterCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.SamCarterCarcass");
		return false;
	}
	else if (Other.isA('SoldierCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXSoldierCarcass");
		return false;
	}
	else if (Other.isA('TerroristCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXTerroristCarcass");
		return false;
	}
	else if (Other.isA('UNATCOTroopCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXUNATCOTroopCarcass");
		return false;
	}
	else if (Other.isA('WaltonSimonsCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXWaltonSimonsCarcass");
		return false;
	}
	else if (Other.isA('WIBCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXWIBCarcass");
		return false;
	}

	return true;
}


// ----------------------------------------------------------------------
// CheckAnimalCarcassReplacement()
// ----------------------------------------------------------------------
function bool CheckAnimalCarcassReplacement(Actor Other, out byte bSuperRelevant)
{
	bSuperRelevant = 0;

	if (Other.isA('CatCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXCatCarcass");
		return false;
	}
	else if (Other.isA('DobermanCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXDobermanCarcass");
		return false;
	}
	else if (Other.isA('GrayCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXGrayCarcass");
		return false;
	}
	else if (Other.isA('GreaselCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXGreaselCarcass");
		return false;
	}
	else if (Other.isA('KarkianCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXKarkianCarcass");
		return false;
	}
	else if (Other.isA('KarkianBabyCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXKarkianBabyCarcass");
		return false;
	}
	else if (Other.isA('MuttCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXCarcass");
		return false;
	}
	else if (Other.isA('PigeonCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXPigeonCarcass");
		return false;
	}
	else if (Other.isA('RatCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXRatCarcass");
		return false;
	}
	else if (Other.isA('SeagullCarcass')) 
	{
		ReplaceWith(Other, "HXCoop.HXSeagullCarcass");
		return false;
	}

	return true;
}


// ----------------------------------------------------------------------
// CheckInventoryReplacement()
// ----------------------------------------------------------------------
function class<Inventory> CheckInventoryReplacement(class<Inventory> AClass)
{
	if (AClass == class'WeaponAssaultGun')
		return class'HXWeaponAssaultGun';
	else if (AClass == class'WeaponCombatKnife')
		return class'HXWeaponCombatKnife';
	else if (AClass == class'WeaponCrowbar')
		return class'HXWeaponCrowbar';
	else if (AClass == class'WeaponMiniCrossbow')
		return class'HXWeaponMiniCrossbow';
	else if (AClass == class'WeaponPistol')
		return class'HXWeaponPistol';
	else
		return AClass;
}


// ----------------------------------------------------------------------
// defaultproperties
// ----------------------------------------------------------------------
defaultproperties
{
}
