//=============================================================================
// HXDeusExMover.
//=============================================================================
class HXDeusExMover extends DeusExMover;

//
// Called to deal with resetting the device
//
function Tick(float deltaTime)
{
	Super(Mover).Tick(deltaTime);
}

//
// The main logic function for doors
//
function Frob(Actor Frobber, Inventory frobWith)
{
	local Pawn P;
	local DeusExPlayer Player;
	local bool bOpenIt, bDone;
	local string msg;
	local Vector X, Y, Z;
	local float dotp;
	local DeusExMover M;

	// if we shouldn't be frobbed, get out
	if (!bFrobbable)
		return;

	// if we are destroyed, don't do anything
	if (bDestroyed)
		return;

	// make sure we frob our leader if we are a slave
	if (bSlave)
		if (Leader != None)
			Leader.Frob(Frobber, frobWith);

	P = Pawn(Frobber);
	Player = DeusExPlayer(P);
	bOpenIt = False;
	bDone = False;
	msg = msgLocked;

	// make sure someone is trying to open the door
	if (P == None)
		return;

	// ugly hack, so animals can't open doors
	if (P.IsA('Animal'))
		return;

	// Let any non-player pawn open any door for now
	if (Player == None)
	{
		bOpenIt = True;
		msg = "";
		bDone = True;
	}

	// If we are already trying to pick it, print a message
	if (bPicking)
	{
		msg = msgPicking;
		bDone = True;
	}

	// If the door is not closed, it can always be closed no matter what
	if ((KeyNum != 0) || (PrevKeyNum != 0))
	{
		bOpenIt = True;
		msg = "";
		bDone = True;
	}

	// check to see if this is a one-way door
	if (!bDone && bOneWay)
	{
		GetAxes(Rotation, X, Y, Z);
		dotp = (Location - Frobber.Location) dot X;

		// if we're on the wrong side of the door, then don't open
		if (dotp > 0.0)
		{
			bOpenIt = False;
			msg = msgOneWayFail;
			bDone = True;
		}
	}

	//
	// If the door is locked, the player must do one of the following to open it
	// without triggers or explosions:
	// 1. Use the KeyIDNeeded 
	// 2. Use the Lockpick and SkillLockpicking
	//
	if (!bDone)
	{
		// Get what's in the player's hand
		if (frobWith != None)
		{
			// check for the use of lockpicks
			if (bPickable && frobWith.IsA('Lockpick') && (Player.SkillSystem != None))
			{
				if (bLocked)
				{
					// alert NPCs that I'm messing with stuff
					AIStartEvent('MegaFutz', EAITYPE_Visual);

					pickValue = Player.SkillSystem.GetSkillLevelValue(class'SkillLockpicking');
					pickPlayer = Player;
					curPick = LockPick(frobWith);
					curPick.bBeingUsed = True;
					curPick.PlayUseAnim();
					bPicking = True;
					numPicks = PickValue * 100;
					TicksPerPick = (PickTime * 10.0) / numPicks;
					LastTickTime = Level.TimeSeconds;
					TicksSinceLastPick = 0;
					SetTimer(0.1, True);
					msg = msgPicking;
				}
				else
				{
					msg = msgAlreadyUnlocked;
				}
			}
			else if ((KeyIDNeeded != '') && frobWith.IsA('NanoKeyRing') && (lockStrength > 0.0))
			{
				// check for the correct key use
				NanoKeyRing(frobWith).PlayUseAnim();
				if (NanoKeyRing(frobWith).HasKey(KeyIDNeeded))
				{
					bLocked = !bLocked;		// toggle the lock state

					// toggle the lock state for all like-tagged movers at once (for double doors and such)
					if ((Tag != '') && (Tag != 'DeusExMover'))
						foreach AllActors(class'DeusExMover', M, Tag)
							if (M != Self)
								M.bLocked = !M.bLocked;

					bOpenIt = False;
					if (bLocked)
						msg = msgKeyLocked;
					else
						msg = msgKeyUnlocked;
				}
				else if (bLocked)
				{
					bOpenIt = False;
					msg = msgNoNanoKey;
				}
				else
				{
					msg = msgAlreadyUnlocked;
				}
			}
			else if (!bLocked)
			{
				bOpenIt = True;
				msg = "";
			}
		}
		else if (!bLocked)
		{
			bOpenIt = True;
			msg = "";
		}
	}

	// give the player a message
	if ((Player != None) && (msg != ""))
		Player.ClientMessage(msg);

	// open it!
	if (bOpenIt)
	{
		Super(Mover).Frob(Frobber, frobWith);
		Trigger(Frobber, P);

		// trigger all like-tagged movers at once (for double doors and such)
		if ((Tag != '') && (Tag != 'DeusExMover'))
			foreach AllActors(class'DeusExMover', M, Tag)
				if (M != Self)
					M.Trigger(Frobber, P);
	}
}


defaultproperties
{
	bStatic=False
	bNoDelete=False
}
