//=============================================================================
// HXDeusExWeapon.
//=============================================================================
class HXDeusExWeapon extends DeusExWeapon
	abstract;


// ----------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------
function PostBeginPlay()
{
	Super(Inventory).PostBeginPlay();
/*
	if (Level.NetMode != NM_Standalone)
	{
		bWeaponStay = True;
		if (bNeedToSetMPPickupAmmo)
		{
			PickupAmmoCount = PickupAmmoCount * 3;
			bNeedToSetMPPickupAmmo = False;
		}
	}
*/
}


// ----------------------------------------------------------------------
// Fire()
// ----------------------------------------------------------------------
function Fire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;

//	log("HXDeusExWeapon.Fire() mark I");
	if ( Level.NetMode != NM_Standalone )  // Turn up the sounds a bit in mulitplayer
	{
		sndVolume = TransientSoundVolume * 2.0;

//		log("HXDeusExWeapon.Fire() mark I.a");

//		if ( Owner.IsA('DeusExPlayer') && (DeusExPlayer(Owner).NintendoImmunityTimeLeft > 0.01) || (!bClientReady && (!bListenClient)) )
//		{
//			DeusExPlayer(Owner).bJustFired = False;
//			bReadyToFire = True;
//			bPointing = False;
//			bFiring = False;
//			log("HXDeusExWeapon.Fire() mark I.b");
//			return;
//		}
		if (Owner.isA('DeusExPlayer'))
		{
			if ((DeusExPlayer(Owner).NintendoImmunityTimeLeft > 0.01) || (!bClientReady && (!bListenClient)))
			{
				DeusExPlayer(Owner).bJustFired = False;
				bReadyToFire = True;
				bPointing = False;
				bFiring = False;
//				log("HXDeusExWeapon.Fire() mark I.b");
				return;
			}
		}
	}

//	log("HXDeusExWeapon.Fire() mark II");

	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{

//		log("HXDeusExWeapon.Fire() mark II.a");
		if (Region.Zone.bWaterZone)
		{
			log("HXDeusExWeapon.Fire() mark II.b");
			if (Pawn(Owner) != None)
			{
				log("HXDeusExWeapon.Fire() mark II.c");
				Pawn(Owner).ClientMessage(msgNotWorking);
				if (!bHandToHand)
					PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
			}
			GotoState('Idle');
//			log("HXDeusExWeapon.Fire() mark II.d");
			return;
		}
	}

//	log("HXDeusExWeapon.Fire() mark III");

	if (bHandToHand)
	{
		if (ReloadCount > 0)
			AmmoType.UseAmmo(1);

//		log("HXDeusExWeapon.Fire() mark III.a");

		if (( Level.NetMode != NM_Standalone ) && !bListenClient )
			bClientReady = False;
		bReadyToFire = False;
		GotoState('NormalFire');
		bPointing=True;
		if ( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveFiring();
		PlayFiringSound();

//		log("HXDeusExWeapon.Fire() mark III.b");
	}

	// if we are a single-use weapon, then our ReloadCount is 0 and we don't use ammo
	else if ((ClipCount < ReloadCount) || (ReloadCount == 0))
	{
		if ((ReloadCount == 0) || AmmoType.UseAmmo(1))
		{
			if (( Level.NetMode != NM_Standalone ) && !bListenClient )
				bClientReady = False;

			ClipCount++;
			bFiring = True;
			bReadyToFire = False;
			GotoState('NormalFire');
			if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient()) )
			{
				if ( PlayerPawn(Owner) != None )		// shake us based on accuracy
					PlayerPawn(Owner).ShakeView(ShakeTime, currentAccuracy * ShakeMag + ShakeMag, currentAccuracy * ShakeVert);
			}
			bPointing=True;
			if ( bInstantHit )
				TraceFire(currentAccuracy);
			else
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).PlayFiring();
			// Don't play firing anim for 20mm
			if ( Ammo20mm(AmmoType) == None )
				PlaySelectiveFiring();
			PlayFiringSound();
			if ( Owner.bHidden )
				CheckVisibility();
		}
		else
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
	}
	else
		PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound

	// Update ammo count on object belt
	if (DeusExPlayer(Owner) != None)
		DeusExPlayer(Owner).UpdateBeltText(Self);
}


// ----------------------------------------------------------------------
// HandToHandAttack()
// ----------------------------------------------------------------------
simulated function HandToHandAttack()
{
	local bool bOwnerIsPlayerPawn;

//	log("HXDeusExWeapon.HandToHandAttack() called");

	if (bOwnerWillNotify)
		return;

	// The controlling animator should be the one to do the tracefire and projfire
	if ( Level.NetMode != NM_Standalone )
	{
		bOwnerIsPlayerPawn = (DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn()));

		if (( Role < ROLE_Authority ) && bOwnerIsPlayerPawn )
			ServerHandleNotify( bInstantHit, ProjectileClass, ProjectileSpeed, bWarnTarget );
//		else if ( !bOwnerIsPlayerPawn )
//			return;
	}

	if (ScriptedPawn(Owner) != None)
		ScriptedPawn(Owner).SetAttackAngle();

	if (bInstantHit)
		TraceFire(0.0);
	else
		ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

	// if we are a thrown weapon and we run out of ammo, destroy the weapon
	if ( bHandToHand && (ReloadCount > 0) && (SimAmmoAmount <= 0))
	{
		DestroyOnFinish();
		if ( Role < ROLE_Authority )
		{
			ServerGotoFinishFire();
			GotoState('SimQuickFinish');
		}
	}
}


// ----------------------------------------------------------------------
// OwnerHandToHandAttack()
// ----------------------------------------------------------------------
simulated function OwnerHandToHandAttack()
{
	local bool bOwnerIsPlayerPawn;

//	log("HXDeusExWeapon.OwnerHandToHandAttack() called");

	if (!bOwnerWillNotify)
		return;

	// The controlling animator should be the one to do the tracefire and projfire
	if ( Level.NetMode != NM_Standalone )
	{
		bOwnerIsPlayerPawn = (DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn()));

		if (( Role < ROLE_Authority ) && bOwnerIsPlayerPawn )
			ServerHandleNotify( bInstantHit, ProjectileClass, ProjectileSpeed, bWarnTarget );
//		else if ( !bOwnerIsPlayerPawn )
//			return;
	}

	if (ScriptedPawn(Owner) != None)
		ScriptedPawn(Owner).SetAttackAngle();

	if (bInstantHit)
		TraceFire(0.0);
	else
		ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
}

// ----------------------------------------------------------------------
// defaultproperties
// ----------------------------------------------------------------------
defaultproperties
{
}
